/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.gui;

import com.hbm.inventory.container.ContainerPASource;
import com.hbm.inventory.gui.GuiInfoContainer;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.toserver.NBTControlPacket;
import com.hbm.tileentity.machine.albion.TileEntityPASource;
import com.hbm.util.i18n.I18nUtil;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GUIPASource
extends GuiInfoContainer {
    private static ResourceLocation texture = new ResourceLocation("hbm:textures/gui/particleaccelerator/gui_source.png");
    private TileEntityPASource source;

    public GUIPASource(InventoryPlayer player, TileEntityPASource source) {
        super(new ContainerPASource(player, source));
        this.source = source;
        this.field_146999_f = 176;
        this.field_147000_g = 204;
    }

    public void func_73863_a(int mouseX, int mouseY, float f) {
        String[] message;
        super.func_73863_a(mouseX, mouseY, f);
        this.source.coolantTanks[0].renderTankInfo(this, mouseX, mouseY, this.field_147003_i + 134, this.field_147009_r + 36, 16, 52);
        this.source.coolantTanks[1].renderTankInfo(this, mouseX, mouseY, this.field_147003_i + 152, this.field_147009_r + 36, 16, 52);
        this.drawElectricityInfo(this, mouseX, mouseY, this.field_147003_i + 8, this.field_147009_r + 18, 16, 52, this.source.power, this.source.getMaxPower());
        ArrayList<String> info = new ArrayList<String>();
        info.add(EnumChatFormatting.BLUE + "Last momentum: " + EnumChatFormatting.RESET + String.format(Locale.US, "%,d", this.source.lastSpeed));
        for (String s : message = I18nUtil.resolveKeyArray("pa." + this.source.state.name().toLowerCase(Locale.US) + ".desc", new Object[0])) {
            info.add(EnumChatFormatting.YELLOW + s);
        }
        this.drawCustomInfoStat(mouseX, mouseY, this.field_147003_i + 105, this.field_147009_r + 18, 10, 10, mouseX, mouseY, info);
        this.drawCustomInfoStat(mouseX, mouseY, this.field_147003_i + 105, this.field_147009_r + 30, 10, 10, mouseX, mouseY, EnumChatFormatting.RED + "Cancel operation");
    }

    protected void func_73864_a(int x, int y, int i) {
        super.func_73864_a(x, y, i);
        if (this.field_147003_i + 105 <= x && this.field_147003_i + 105 + 10 > x && this.field_147009_r + 30 < y && this.field_147009_r + 30 + 10 >= y) {
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
            NBTTagCompound data = new NBTTagCompound();
            data.func_74757_a("cancel", true);
            PacketDispatcher.wrapper.sendToServer(new NBTControlPacket(data, this.source.field_145851_c, this.source.field_145848_d, this.source.field_145849_e));
        }
    }

    protected void func_146979_b(int i, int j) {
        String name = this.source.func_145818_k_() ? this.source.func_145825_b() : I18n.func_135052_a((String)this.source.func_145825_b(), (Object[])new Object[0]);
        this.field_146289_q.func_78276_b(name, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(name) / 2 - 9, 4, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8, this.field_147000_g - 96 + 2, 0x404040);
        this.field_146289_q.func_78276_b(EnumChatFormatting.AQUA + "/123K", 136, 22, 0x404040);
        int heat = (int)Math.ceil(this.source.temperature);
        String label = (heat > 123 ? EnumChatFormatting.RED : EnumChatFormatting.AQUA) + "" + heat + "K";
        this.field_146289_q.func_78276_b(label, 166 - this.field_146289_q.func_78256_a(label), 12, 0x404040);
        String state = I18n.func_135052_a((String)("pa." + this.source.state.name().toLowerCase(Locale.US)), (Object[])new Object[0]);
        this.field_146289_q.func_78276_b(state, 79 - this.field_146289_q.func_78256_a(state) / 2, 76, this.source.state.color);
    }

    protected void func_146976_a(float interp, int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        int j = (int)(this.source.power * 52L / this.source.getMaxPower());
        this.func_73729_b(this.field_147003_i + 8, this.field_147009_r + 70 - j, 184, 52 - j, 16, j);
        int heat = (int)Math.ceil(this.source.temperature);
        if (heat <= 123) {
            this.func_73729_b(this.field_147003_i + 44, this.field_147009_r + 18, 176, 8, 8, 8);
        }
        if (this.source.power >= 100000L) {
            this.func_73729_b(this.field_147003_i + 44, this.field_147009_r + 43, 176, 8, 8, 8);
        }
        int color = this.source.state.color;
        float red = (color & 0xFF0000) >> 16;
        float green = (color & 0xFF00) >> 8;
        float blue = color & 0xFF;
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)1.0f);
        this.func_73729_b(this.field_147003_i + 45, this.field_147009_r + 73, 176, 52, 68, 14);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.source.coolantTanks[0].renderTank(this.field_147003_i + 134, this.field_147009_r + 88, this.field_73735_i, 16, 52);
        this.source.coolantTanks[1].renderTank(this.field_147003_i + 152, this.field_147009_r + 88, this.field_73735_i, 16, 52);
    }
}

