/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.gui;

import com.hbm.inventory.container.ContainerMachineArcFurnaceLarge;
import com.hbm.inventory.gui.GuiInfoContainer;
import com.hbm.inventory.material.Mats;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.toserver.NBTControlPacket;
import com.hbm.tileentity.machine.TileEntityMachineArcFurnaceLarge;
import com.hbm.util.i18n.I18nUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GUIMachineArcFurnaceLarge
extends GuiInfoContainer {
    private static ResourceLocation texture = new ResourceLocation("hbm:textures/gui/processing/gui_arc_furnace.png");
    private TileEntityMachineArcFurnaceLarge arc;

    public GUIMachineArcFurnaceLarge(InventoryPlayer invPlayer, TileEntityMachineArcFurnaceLarge arc) {
        super(new ContainerMachineArcFurnaceLarge(invPlayer, arc));
        this.arc = arc;
        this.field_146999_f = 176;
        this.field_147000_g = 256;
    }

    public void func_73863_a(int x, int y, float interp) {
        super.func_73863_a(x, y, interp);
        this.drawStackInfo(this.arc.liquids, x, y, 152, 36);
        this.drawElectricityInfo(this, x, y, this.field_147003_i + 8, this.field_147009_r + 36, 7, 70, this.arc.getPower(), this.arc.getMaxPower());
    }

    protected void func_73864_a(int x, int y, int k) {
        super.func_73864_a(x, y, k);
        if (this.checkClick(x, y, 151, 17, 18, 18)) {
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
            NBTTagCompound data = new NBTTagCompound();
            data.func_74757_a("liquid", true);
            PacketDispatcher.wrapper.sendToServer(new NBTControlPacket(data, this.arc.field_145851_c, this.arc.field_145848_d, this.arc.field_145849_e));
        }
    }

    protected void func_146979_b(int i, int j) {
        String name = this.arc.func_145818_k_() ? this.arc.func_145825_b() : I18n.func_135052_a((String)this.arc.func_145825_b(), (Object[])new Object[0]);
        this.field_146289_q.func_78276_b(name, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(name) / 2, 6, 0xFFFFFF);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8, this.field_147000_g - 96 + 2, 0x404040);
    }

    protected void func_146976_a(float interp, int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.arc.liquidMode) {
            this.func_73729_b(this.field_147003_i + 151, this.field_147009_r + 17, 190, 18, 18, 18);
        }
        if (this.arc.isProgressing) {
            this.func_73729_b(this.field_147003_i + 7, this.field_147009_r + 17, 190, 0, 18, 18);
        }
        int p = (int)(this.arc.power * 70L / 2500000L);
        this.func_73729_b(this.field_147003_i + 8, this.field_147009_r + 106 - p, 176, 70 - p, 7, p);
        int o = (int)(this.arc.progress * 70.0f);
        this.func_73729_b(this.field_147003_i + 17, this.field_147009_r + 106 - o, 183, 70 - o, 7, o);
        this.drawStack(this.arc.liquids, TileEntityMachineArcFurnaceLarge.maxLiquid, 152, 106);
    }

    protected void drawStackInfo(List<Mats.MaterialStack> stack, int mouseX, int mouseY, int x, int y) {
        ArrayList<String> list = new ArrayList<String>();
        if (stack.isEmpty()) {
            list.add(EnumChatFormatting.RED + "Empty");
        }
        for (Mats.MaterialStack sta : stack) {
            list.add(EnumChatFormatting.YELLOW + I18nUtil.resolveKey(sta.material.getUnlocalizedName(), new Object[0]) + ": " + Mats.formatAmount(sta.amount, Keyboard.isKeyDown((int)42)));
        }
        this.drawCustomInfoStat(mouseX, mouseY, this.field_147003_i + x, this.field_147009_r + y, 16, 70, mouseX, mouseY, list);
    }

    protected void drawStack(List<Mats.MaterialStack> stack, int capacity, int x, int y) {
        if (stack.isEmpty()) {
            return;
        }
        int lastHeight = 0;
        int lastQuant = 0;
        GL11.glBlendFunc((int)770, (int)1);
        for (Mats.MaterialStack sta : stack) {
            int targetHeight = (lastQuant + sta.amount) * 70 / capacity;
            if (lastHeight == targetHeight) continue;
            int hex = sta.material.moltenColor;
            Color color = new Color(hex);
            GL11.glColor3f((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f));
            this.func_73729_b(this.field_147003_i + x, this.field_147009_r + y - targetHeight, 208, 70 - targetHeight, 16, targetHeight - lastHeight);
            GL11.glEnable((int)3042);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.3f);
            this.func_73729_b(this.field_147003_i + x, this.field_147009_r + y - targetHeight, 208, 70 - targetHeight, 16, targetHeight - lastHeight);
            GL11.glDisable((int)3042);
            lastQuant += sta.amount;
            lastHeight = targetHeight;
        }
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glColor3f((float)255.0f, (float)255.0f, (float)255.0f);
    }
}

