/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.nei;

import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.hbm.handler.imc.ICompatNHNEI;
import com.hbm.inventory.recipes.MachineRecipes;
import com.hbm.items.ModItems;
import com.hbm.util.Tuple;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;

public class FluidRecipeHandler
extends TemplateRecipeHandler
implements ICompatNHNEI {
    @Override
    public ItemStack[] getMachinesForRecipe() {
        return new ItemStack[]{new ItemStack(ModItems.fluid_barrel_empty), new ItemStack(ModItems.fluid_tank_empty), new ItemStack(ModItems.fluid_tank_lead_empty), new ItemStack(ModItems.canister_empty), new ItemStack(ModItems.gas_empty), new ItemStack(ModItems.cell_empty), new ItemStack(ModItems.disperser_canister_empty), new ItemStack(ModItems.glyphid_gland_empty)};
    }

    @Override
    public String getRecipeID() {
        return "fluidcons";
    }

    public String getRecipeName() {
        return "Fluid Containers";
    }

    public String getGuiTexture() {
        return "hbm:textures/gui/nei/gui_nei_fluid.png";
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("fluidcons") && this.getClass() == FluidRecipeHandler.class) {
            List<Tuple.Triplet<ItemStack, ItemStack, ItemStack>> recipes = MachineRecipes.instance().getFluidContainers();
            for (Tuple.Triplet<ItemStack, ItemStack, ItemStack> recipe : recipes) {
                this.arecipes.add(new SmeltingSet(recipe.getX(), recipe.getY(), recipe.getZ()));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        List<Tuple.Triplet<ItemStack, ItemStack, ItemStack>> recipes = MachineRecipes.instance().getFluidContainers();
        for (Tuple.Triplet<ItemStack, ItemStack, ItemStack> recipe : recipes) {
            if (!NEIServerUtils.areStacksSameType((ItemStack)recipe.getY(), (ItemStack)result) && !NEIServerUtils.areStacksSameType((ItemStack)recipe.getZ(), (ItemStack)result) && !this.compareFluidStacks(result, recipe.getX())) continue;
            this.arecipes.add(new SmeltingSet(recipe.getX(), recipe.getY(), recipe.getZ()));
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("fluidcons") && this.getClass() == FluidRecipeHandler.class) {
            this.loadCraftingRecipes("fluidcons", new Object[0]);
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        List<Tuple.Triplet<ItemStack, ItemStack, ItemStack>> recipes = MachineRecipes.instance().getFluidContainers();
        for (Tuple.Triplet<ItemStack, ItemStack, ItemStack> recipe : recipes) {
            if (!NEIServerUtils.areStacksSameType((ItemStack)recipe.getY(), (ItemStack)ingredient) && !NEIServerUtils.areStacksSameType((ItemStack)recipe.getZ(), (ItemStack)ingredient) && !this.compareFluidStacks(ingredient, recipe.getX())) continue;
            this.arecipes.add(new SmeltingSet(recipe.getX(), recipe.getY(), recipe.getZ()));
        }
    }

    private boolean compareFluidStacks(ItemStack sta1, ItemStack sta2) {
        return sta1.func_77973_b() == sta2.func_77973_b() && sta1.func_77960_j() == sta2.func_77960_j();
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return null;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(71, 23, 42, 18), "fluidcons", new Object[0]));
        TemplateRecipeHandler.RecipeTransferRectHandler.registerRectsToGuis((List)this.getRecipeTransferRectGuis(), (List)this.transferRects);
    }

    public class SmeltingSet
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack[] input;
        PositionedStack result;

        public SmeltingSet(ItemStack fluid, ItemStack empty, ItemStack full) {
            super((TemplateRecipeHandler)FluidRecipeHandler.this);
            fluid.field_77994_a = 1;
            this.input = new PositionedStack[empty == null ? 1 : 2];
            this.input[0] = new PositionedStack((Object)fluid, 30, 24);
            if (empty != null) {
                this.input[1] = new PositionedStack((Object)empty, 48, 24);
            }
            this.result = new PositionedStack((Object)full, 120, 24);
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(FluidRecipeHandler.this.cycleticks / 48, Arrays.asList(this.input));
        }

        public PositionedStack getResult() {
            return this.result;
        }
    }
}

