/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler;

import com.hbm.dim.CelestialBody;
import com.hbm.dim.SolarSystem;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.items.ModItems;
import com.hbm.items.weapon.ItemCustomMissilePart;
import com.hbm.render.util.MissilePart;
import com.hbm.util.BufferUtil;
import com.hbm.util.Tuple;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.DataWatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;

public class RocketStruct {
    public MissilePart capsule;
    public ArrayList<RocketStage> stages = new ArrayList();
    public int satFreq = 0;
    public List<String> extraIssues = new ArrayList<String>();
    public static final int MAX_STAGES = 5;

    public RocketStruct() {
    }

    public RocketStruct(ItemStack capsule) {
        this.capsule = MissilePart.getPart(capsule);
    }

    public RocketStruct(MissilePart capsule) {
        this.capsule = capsule;
    }

    public void addStage(ItemStack fuselage, ItemStack fins, ItemStack thruster) {
        this.addStage(MissilePart.getPart(fuselage), MissilePart.getPart(fins), MissilePart.getPart(thruster), fuselage != null ? fuselage.field_77994_a : 1, thruster != null ? thruster.field_77994_a : 1);
    }

    public void addStage(MissilePart fuselage, MissilePart fins, MissilePart thruster, int fuselageCount, int thrusterCount) {
        RocketStage stage = new RocketStage();
        stage.fuselage = fuselage;
        stage.fins = fins;
        stage.thruster = thruster;
        stage.fuselageCount = fuselageCount;
        stage.thrusterCount = thrusterCount;
        this.stages.add(0, stage);
    }

    public boolean validate() {
        if (this.extraIssues.size() > 0) {
            return false;
        }
        if (this.capsule == null || this.capsule.type != ItemCustomMissilePart.PartType.WARHEAD) {
            return false;
        }
        if (this.capsule.part.attributes[0] != ItemCustomMissilePart.WarheadType.APOLLO && this.capsule.part.attributes[0] != ItemCustomMissilePart.WarheadType.SATELLITE) {
            return false;
        }
        if (this.stages.size() == 0) {
            return false;
        }
        for (RocketStage stage : this.stages) {
            if (stage.fuselage == null || stage.fuselage.type != ItemCustomMissilePart.PartType.FUSELAGE) {
                return false;
            }
            if (stage.fins != null && stage.fins.type != ItemCustomMissilePart.PartType.FINS) {
                return false;
            }
            if (stage.thruster == null || stage.thruster.type != ItemCustomMissilePart.PartType.THRUSTER) {
                return false;
            }
            if (stage.thrusterCount > stage.fuselageCount || stage.fuselageCount % stage.thrusterCount != 0) {
                return false;
            }
            if (stage.fuselage.part.attributes[0] == ItemCustomMissilePart.FuelType.ANY || stage.fuselage.part.attributes[0] == stage.thruster.part.attributes[0]) continue;
            return false;
        }
        return true;
    }

    public void addIssue(String issue) {
        this.extraIssues.add(issue);
    }

    public List<String> findIssues(int stageNum, CelestialBody from, CelestialBody to, boolean fromOrbit, boolean toOrbit) {
        ArrayList<String> issues = new ArrayList<String>();
        if (this.capsule == null && this.stages.size() == 0) {
            return issues;
        }
        if (this.capsule == null || this.capsule.part.attributes[0] != ItemCustomMissilePart.WarheadType.APOLLO && this.capsule.part.attributes[0] != ItemCustomMissilePart.WarheadType.SATELLITE) {
            issues.add(EnumChatFormatting.RED + "Invalid Capsule/Satellite");
        }
        if (stageNum < this.stages.size()) {
            RocketStage stage = this.stages.get(stageNum);
            issues.add("Dry mass: " + this.getLaunchMass(stageNum) + "kg");
            issues.add("Wet mass: " + this.getWetMass(stageNum) + "kg");
            if (stage.thruster != null) {
                issues.add("Thrust: " + this.getThrust(stage) + "N");
                issues.add("ISP: " + this.getISP(stage) + "s");
            }
        }
        for (int i = 0; i < this.stages.size(); ++i) {
            RocketStage stage = this.stages.get(i);
            if (stage.fuselage == null) {
                issues.add(EnumChatFormatting.RED + "Stage " + (i + 1) + " missing fuselage");
            }
            if (stage.thruster == null) {
                issues.add(EnumChatFormatting.RED + "Stage " + (i + 1) + " missing thruster");
            }
            if (stage.fuselage == null || stage.thruster == null) continue;
            if (stage.thrusterCount > stage.fuselageCount) {
                issues.add(EnumChatFormatting.RED + "Stage " + (i + 1) + " too many thrusters");
            }
            if (stage.fuselageCount % stage.thrusterCount != 0) {
                issues.add(EnumChatFormatting.RED + "Stage " + (i + 1) + " uneven thrusters");
            }
            if (stage.fuselage.part.attributes[0] != ItemCustomMissilePart.FuelType.ANY && stage.fuselage.part.attributes[0] != stage.thruster.part.attributes[0]) {
                issues.add(EnumChatFormatting.RED + "Stage " + (i + 1) + " fuel mismatch");
            }
            if (i <= 0 || stage.fins != null) continue;
            issues.add(EnumChatFormatting.YELLOW + "Stage " + (i + 1) + " lacks landing legs");
        }
        if (from != null && to != null) {
            int fuelRequirement = this.getFuelRequired(stageNum, from, to, fromOrbit, toOrbit);
            int fuelCapacity = this.getFuelCapacity(stageNum);
            if (fuelRequirement == Integer.MAX_VALUE) {
                issues.add(EnumChatFormatting.YELLOW + "Insufficient thrust");
            } else if (fuelCapacity < fuelRequirement) {
                issues.add(EnumChatFormatting.YELLOW + "Insufficient fuel: " + fuelCapacity + "/" + fuelRequirement + "mB");
            } else if (fuelCapacity > 0 && fuelRequirement > 0) {
                issues.add(EnumChatFormatting.GREEN + "Trip possible! " + fuelCapacity + "/" + fuelRequirement + "mB");
            }
        }
        for (String issue : this.extraIssues) {
            issues.add(issue);
        }
        return issues;
    }

    public Map<FluidType, Integer> getFillRequirement() {
        HashMap<FluidType, Integer> tanks = new HashMap<FluidType, Integer>();
        for (RocketStage stage : this.stages) {
            int amount;
            if (stage.thruster == null || stage.fuselage == null) continue;
            FluidType fuel = stage.thruster.part.getFuel();
            FluidType oxidizer = stage.thruster.part.getOxidizer();
            if (fuel != null) {
                amount = stage.fuselage.part.getTankSize() * stage.fuselageCount;
                if (tanks.containsKey(fuel)) {
                    amount += ((Integer)tanks.get(fuel)).intValue();
                }
                tanks.put(fuel, amount);
            }
            if (oxidizer == null) continue;
            amount = stage.fuselage.part.getTankSize() * stage.fuselageCount;
            if (tanks.containsKey(oxidizer)) {
                amount += ((Integer)tanks.get(oxidizer)).intValue();
            }
            tanks.put(oxidizer, amount);
        }
        return tanks;
    }

    public boolean hasSufficientFuel(CelestialBody from, CelestialBody to, boolean fromOrbit, boolean toOrbit) {
        if (this.capsule.part == ModItems.rp_pod_20) {
            return from == to && (fromOrbit || toOrbit);
        }
        if (this.stages.size() == 0) {
            return from == to && fromOrbit && !toOrbit;
        }
        int fuelRequirement = this.getFuelRequired(0, from, to, fromOrbit, toOrbit);
        int fuelCapacity = this.getFuelCapacity(0);
        return fuelCapacity >= fuelRequirement;
    }

    private int getFuelCapacity(int stageNum) {
        if (stageNum >= this.stages.size()) {
            return -1;
        }
        RocketStage stage = this.stages.get(stageNum);
        if (stage.fuselage == null) {
            return -1;
        }
        return stage.fuselage.part.getTankSize() * stage.fuselageCount;
    }

    private int getFuelRequired(int stageNum, CelestialBody from, CelestialBody to, boolean fromOrbit, boolean toOrbit) {
        if (stageNum >= this.stages.size()) {
            return -1;
        }
        RocketStage stage = this.stages.get(stageNum);
        if (stage.fuselage == null || stage.thruster == null) {
            return -1;
        }
        int rocketMass = this.getLaunchMass(stageNum);
        int thrust = this.getThrust(stage);
        int isp = this.getISP(stage);
        return SolarSystem.getCostBetween(from, to, rocketMass, thrust, isp, fromOrbit, toOrbit);
    }

    public int getThrust() {
        return this.getThrust(this.stages.get(0));
    }

    private int getThrust(RocketStage stage) {
        return stage.thruster.part.getThrust() * stage.thrusterCount;
    }

    private int getISP(RocketStage stage) {
        return stage.thruster.part.getISP();
    }

    public int getLaunchMass() {
        return this.getMass(0, false);
    }

    public int getLaunchMass(int stageNum) {
        return this.getMass(stageNum, false);
    }

    public int getWetMass(int stageNum) {
        return this.getMass(stageNum, true);
    }

    private int getMass(int stageNum, boolean wet) {
        int mass = 0;
        if (this.capsule != null) {
            mass += this.capsule.part.mass;
        }
        for (int i = stageNum; i < this.stages.size(); ++i) {
            RocketStage stage = this.stages.get(i);
            if (stage.fuselage != null) {
                mass += stage.fuselage.part.mass * stage.fuselageCount;
            }
            if (stage.thruster != null) {
                mass += stage.thruster.part.mass * stage.thrusterCount;
            }
            if (stage.fuselage == null || i <= stageNum && !wet) continue;
            mass += stage.fuselage.part.getTankSize() * stage.fuselageCount / 4;
        }
        return MathHelper.func_76123_f((float)mass);
    }

    public double getHeight() {
        double height = 0.0;
        if (this.capsule != null) {
            height += this.capsule.height;
        }
        boolean isDeployed = true;
        for (RocketStage stage : this.stages) {
            if (stage.fuselage != null) {
                height += stage.fuselage.height * (double)stage.getStack();
            }
            height += Math.max(stage.thruster != null ? stage.thruster.height : 0.0, isDeployed && stage.fins != null ? stage.fins.height : 0.0);
            isDeployed = false;
        }
        return height;
    }

    public double getHeight(int stageNum) {
        double height = 0.0;
        if (this.stages.size() > 0) {
            RocketStage stage = this.stages.get(Math.min(stageNum, this.stages.size() - 1));
            if (stage.fuselage != null) {
                height += stage.fuselage.height * (double)stage.getStack();
            }
            height += Math.max(stage.thruster != null ? stage.thruster.height : 0.0, stageNum == 0 && stage.fins != null ? stage.fins.height : 0.0);
        }
        if ((this.stages.size() == 0 || stageNum == this.stages.size() - 1) && this.capsule != null) {
            height += this.capsule.height;
        }
        return height;
    }

    public double getOffset(int stageNum) {
        double height = 0.0;
        for (int i = 0; i < Math.min(stageNum, this.stages.size() - 1); ++i) {
            RocketStage stage = this.stages.get(i);
            if (stage.fuselage != null) {
                height += stage.fuselage.height * (double)stage.getStack();
            }
            height += Math.max(stage.thruster != null ? stage.thruster.height : 0.0, i == 0 && stage.fins != null ? stage.fins.height : 0.0);
        }
        return height;
    }

    public void writeToByteBuffer(ByteBuf buf) {
        buf.writeInt(MissilePart.getId(this.capsule));
        buf.writeInt(this.stages.size());
        for (RocketStage stage : this.stages) {
            buf.writeInt(MissilePart.getId(stage.fuselage));
            buf.writeInt(MissilePart.getId(stage.fins));
            buf.writeInt(MissilePart.getId(stage.thruster));
            buf.writeByte(stage.fuselageCount);
            buf.writeByte(stage.thrusterCount);
        }
        buf.writeInt(this.extraIssues.size());
        for (String issue : this.extraIssues) {
            BufferUtil.writeString(buf, issue);
        }
    }

    public static RocketStruct readFromByteBuffer(ByteBuf buf) {
        int i;
        RocketStruct rocket = new RocketStruct();
        rocket.capsule = MissilePart.getPart(buf.readInt());
        int count = buf.readInt();
        for (i = 0; i < count; ++i) {
            RocketStage stage = new RocketStage();
            stage.fuselage = MissilePart.getPart(buf.readInt());
            stage.fins = MissilePart.getPart(buf.readInt());
            stage.thruster = MissilePart.getPart(buf.readInt());
            stage.fuselageCount = buf.readByte();
            stage.thrusterCount = buf.readByte();
            rocket.stages.add(stage);
        }
        count = buf.readInt();
        for (i = 0; i < count; ++i) {
            rocket.extraIssues.add(BufferUtil.readString(buf));
        }
        return rocket;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("capsule", MissilePart.getId(this.capsule));
        NBTTagList stagesTag = new NBTTagList();
        for (RocketStage stage : this.stages) {
            NBTTagCompound stageTag = new NBTTagCompound();
            stageTag.func_74768_a("fuselage", MissilePart.getId(stage.fuselage));
            stageTag.func_74768_a("fins", MissilePart.getId(stage.fins));
            stageTag.func_74768_a("thruster", MissilePart.getId(stage.thruster));
            stageTag.func_74768_a("fc", stage.fuselageCount);
            stageTag.func_74768_a("tc", stage.thrusterCount);
            stagesTag.func_74742_a((NBTBase)stageTag);
        }
        nbt.func_74782_a("stages", (NBTBase)stagesTag);
        nbt.func_74768_a("freq", this.satFreq);
    }

    public static RocketStruct readFromNBT(NBTTagCompound nbt) {
        RocketStruct rocket = new RocketStruct();
        rocket.capsule = MissilePart.getPart(nbt.func_74762_e("capsule"));
        NBTTagList stagesTag = nbt.func_150295_c("stages", 10);
        for (int i = 0; i < stagesTag.func_74745_c(); ++i) {
            NBTTagCompound stageTag = stagesTag.func_150305_b(i);
            RocketStage stage = new RocketStage();
            stage.fuselage = MissilePart.getPart(stageTag.func_74762_e("fuselage"));
            stage.fins = MissilePart.getPart(stageTag.func_74762_e("fins"));
            stage.thruster = MissilePart.getPart(stageTag.func_74762_e("thruster"));
            stage.fuselageCount = Math.max(stageTag.func_74762_e("fc"), 1);
            stage.thrusterCount = Math.max(stageTag.func_74762_e("tc"), 1);
            rocket.stages.add(stage);
        }
        return rocket;
    }

    public static void setupDataWatcher(DataWatcher watcher, int start) {
        watcher.func_75682_a(start, (Object)0);
        watcher.func_75682_a(start + 1, (Object)0);
        for (int i = 0; i < 5; ++i) {
            watcher.func_75682_a(start + i * 2 + 2, (Object)0);
            watcher.func_75682_a(start + i * 2 + 3, (Object)0);
        }
    }

    public void writeToDataWatcher(DataWatcher watcher, int start) {
        watcher.func_75692_b(start, (Object)MissilePart.getId(this.capsule));
        watcher.func_75692_b(start + 1, (Object)this.stages.size());
        for (int i = 0; i < this.stages.size(); ++i) {
            Tuple.Pair<Integer, Integer> watchable = this.stages.get(i).zipWatchable();
            watcher.func_75692_b(start + i * 2 + 2, watchable.key);
            watcher.func_75692_b(start + i * 2 + 3, watchable.value);
        }
    }

    public static RocketStruct readFromDataWatcher(DataWatcher watcher, int start) {
        RocketStruct rocket = new RocketStruct();
        rocket.capsule = MissilePart.getPart(watcher.func_75679_c(start));
        int count = watcher.func_75679_c(start + 1);
        for (int i = 0; i < count; ++i) {
            Tuple.Pair<Integer, Integer> watchable = new Tuple.Pair<Integer, Integer>(watcher.func_75679_c(start + i * 2 + 2), watcher.func_75679_c(start + i * 2 + 3));
            rocket.stages.add(RocketStage.unzipWatchable(watchable));
        }
        if (rocket.capsule == null) {
            rocket.capsule = MissilePart.getPart(ModItems.rp_capsule_20);
        }
        return rocket;
    }

    public static class RocketStage {
        public MissilePart fuselage;
        public MissilePart fins;
        public MissilePart thruster;
        public int fuselageCount = 1;
        public int thrusterCount = 1;

        public Tuple.Pair<Integer, Integer> zipWatchable() {
            int first = MissilePart.getId(this.fuselage) << 16 | MissilePart.getId(this.fins);
            int second = MissilePart.getId(this.thruster) << 16 | this.fuselageCount << 8 | this.thrusterCount;
            return new Tuple.Pair<Integer, Integer>(first, second);
        }

        public static RocketStage unzipWatchable(Tuple.Pair<Integer, Integer> pair) {
            RocketStage stage = new RocketStage();
            stage.fuselage = MissilePart.getPart((Integer)pair.key >> 16);
            stage.fins = MissilePart.getPart((Integer)pair.key & 0xFFFF);
            stage.thruster = MissilePart.getPart((Integer)pair.value >> 16);
            stage.fuselageCount = (Integer)pair.value >> 8 & 0xFF;
            stage.thrusterCount = (Integer)pair.value & 0xFF;
            return stage;
        }

        public int getStack() {
            return Math.max(this.fuselageCount / this.thrusterCount, 1);
        }

        public int getCluster() {
            return Math.max(this.fuselageCount / this.getStack(), 1);
        }
    }
}

