/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.projectile;

import com.hbm.blocks.ModBlocks;
import com.hbm.config.WorldConfig;
import com.hbm.explosion.ExplosionLarge;
import com.hbm.main.MainRegistry;
import com.hbm.sound.AudioWrapper;
import com.hbm.util.fauxpointtwelve.BlockPos;
import com.hbm.world.feature.Meteorite;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class EntityMeteor
extends Entity {
    public boolean safe = false;
    private AudioWrapper audioFly;

    public EntityMeteor(World world) {
        super(world);
        this.field_70158_ak = true;
        this.field_70178_ae = true;
        this.func_70105_a(4.0f, 4.0f);
        if (this.field_70170_p.field_72995_K) {
            this.audioFly = MainRegistry.proxy.getLoopedSound("hbm:entity.meteoriteFallingLoop", 0.0f, 0.0f, 0.0f, 1.0f, 200.0f, 0.9f + this.field_70146_Z.nextFloat() * 0.2f, 0);
        }
    }

    public List<BlockPos> getBlocksInRadius(World world, int x, int y, int z, int radius) {
        ArrayList<BlockPos> foundBlocks = new ArrayList<BlockPos>();
        int rSq = radius * radius;
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    if (dx * dx + dy * dy + dz * dz > rSq) continue;
                    foundBlocks.add(new BlockPos(x + dx, y + dy, z + dz));
                }
            }
        }
        return foundBlocks;
    }

    public void damageOrDestroyBlock(World world, int blockX, int blockY, int blockZ) {
        if (this.safe) {
            return;
        }
        Block block = world.func_147439_a(blockX, blockY, blockZ);
        if (block == null) {
            return;
        }
        float hardness = block.func_149712_f(world, blockX, blockY, blockZ);
        if (block == Blocks.field_150362_t || block == Blocks.field_150364_r || hardness >= 0.0f && hardness <= 0.3f) {
            world.func_147468_f(blockX, blockY, blockZ);
        } else {
            if (hardness < 0.0f || hardness > 5.0f) {
                return;
            }
            if (this.field_70146_Z.nextInt(6) == 1) {
                if (block == Blocks.field_150346_d) {
                    world.func_147449_b(blockX, blockY, blockZ, ModBlocks.dirt_dead);
                } else if (block == Blocks.field_150354_m) {
                    if (this.field_70146_Z.nextInt(2) == 1) {
                        world.func_147449_b(blockX, blockY, blockZ, Blocks.field_150322_A);
                    } else {
                        world.func_147449_b(blockX, blockY, blockZ, Blocks.field_150359_w);
                    }
                } else if (block == Blocks.field_150348_b) {
                    world.func_147449_b(blockX, blockY, blockZ, Blocks.field_150347_e);
                } else if (block == Blocks.field_150349_c) {
                    world.func_147449_b(blockX, blockY, blockZ, ModBlocks.waste_earth);
                }
            }
        }
    }

    public void clearMeteorPath(World world, int x, int y, int z) {
        for (BlockPos blockPos : this.getBlocksInRadius(world, x, y, z, 5)) {
            this.damageOrDestroyBlock(this.field_70170_p, blockPos.getX(), blockPos.getY(), blockPos.getZ());
        }
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && !WorldConfig.enableMeteorStrikes) {
            this.func_70106_y();
            return;
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.field_70181_x -= 0.03;
        if (this.field_70181_x < -2.5) {
            this.field_70181_x = -2.5;
        }
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        if (!this.field_70170_p.field_72995_K && this.field_70163_u < 260.0) {
            this.clearMeteorPath(this.field_70170_p, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v);
            if (this.field_70122_E) {
                this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 5.0f + this.field_70146_Z.nextFloat(), !this.safe);
                if (WorldConfig.enableMeteorTails) {
                    ExplosionLarge.spawnRubble(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 15);
                    ExplosionLarge.spawnParticles(this.field_70170_p, this.field_70165_t, this.field_70163_u + 5.0, this.field_70161_v, 75);
                    ExplosionLarge.spawnParticles(this.field_70170_p, this.field_70165_t + 5.0, this.field_70163_u, this.field_70161_v, 75);
                    ExplosionLarge.spawnParticles(this.field_70170_p, this.field_70165_t - 5.0, this.field_70163_u, this.field_70161_v, 75);
                    ExplosionLarge.spawnParticles(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v + 5.0, 75);
                    ExplosionLarge.spawnParticles(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v - 5.0, 75);
                }
                int spawnPosX = (int)((double)Math.round(this.field_70165_t - 0.5) + (this.safe ? 0.0 : this.field_70179_y * 4.0));
                int spawnPosY = (int)Math.round(this.field_70163_u - (double)(this.safe ? 0 : 4));
                int spawnPosZ = (int)((double)Math.round(this.field_70161_v - 0.5) + (this.safe ? 0.0 : this.field_70179_y * 4.0));
                new Meteorite().generate(this.field_70170_p, this.field_70146_Z, spawnPosX, spawnPosY, spawnPosZ, this.safe, true, true);
                this.clearMeteorPath(this.field_70170_p, spawnPosX, spawnPosY, spawnPosZ);
                this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, "hbm:entity.oldExplosion", 10000.0f, 0.5f + this.field_70146_Z.nextFloat() * 0.1f);
                this.func_70106_y();
            }
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.field_70128_L) {
                if (this.audioFly != null) {
                    this.audioFly.stopSound();
                }
            } else if (this.audioFly.isPlaying()) {
                this.audioFly.keepAlive();
                this.audioFly.updateVolume(1.0f);
                this.audioFly.updatePosition((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v);
            } else {
                EntityPlayer player = MainRegistry.proxy.me();
                double distance = player.func_70092_e(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                if (distance < 44100.0) {
                    this.audioFly.startSound();
                }
            }
            if (WorldConfig.enableMeteorTails) {
                NBTTagCompound data = new NBTTagCompound();
                data.func_74778_a("type", "exhaust");
                data.func_74778_a("mode", "meteor");
                data.func_74768_a("count", 10);
                data.func_74780_a("width", 1.0);
                data.func_74780_a("posX", this.field_70165_t - this.field_70159_w);
                data.func_74780_a("posY", this.field_70163_u - this.field_70181_x);
                data.func_74780_a("posZ", this.field_70161_v - this.field_70179_y);
                MainRegistry.proxy.effectNT(data);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float f) {
        return 0xF000F0;
    }

    public float func_70013_c(float f) {
        return 1.0f;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.safe = nbt.func_74767_n("safe");
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74757_a("safe", this.safe);
    }
}

