/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.dim.mapgen;

import com.hbm.dim.noise.DoublePerlinNoiseSampler;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.MapGenBase;

public class MapGenTiltedSpires
extends MapGenBase {
    private final int chanceHigh;
    private final int chanceLow;
    private final float threshold;
    public int minSize = 6;
    public int maxSize = 16;
    public float minPoint = 0.5f;
    public float maxPoint = 4.0f;
    public float minTilt = 0.2f;
    public float maxTilt = 2.5f;
    public boolean curve = false;
    public int mid = 64;
    public Block regolith;
    public Block rock;
    private DoublePerlinNoiseSampler perlin;

    public MapGenTiltedSpires(int chanceHigh, int chanceLow, float threshold) {
        this.chanceHigh = chanceHigh;
        this.chanceLow = chanceLow;
        this.threshold = threshold * 2.0f - 1.0f;
        this.field_75040_a = 4;
    }

    public void setRange(int range) {
        this.field_75040_a = range;
    }

    public void func_151539_a(IChunkProvider chunk, World world, int chunkX, int chunkZ, Block[] blocks) {
        if (this.field_75039_c != world) {
            this.field_75038_b.setSeed(world.func_72905_C() + 69L);
            this.perlin = DoublePerlinNoiseSampler.create(new Random(this.field_75038_b.nextLong()), -8, 1.0, 2.0);
        }
        super.func_151539_a(chunk, world, chunkX, chunkZ, blocks);
    }

    protected void func_151538_a(World world, int offsetX, int offsetZ, int chunkX, int chunkZ, Block[] blocks) {
        int chance;
        int n = chance = this.perlin.sample(offsetX * 16, 0.0, offsetZ * 16) > (double)this.threshold ? this.chanceHigh : this.chanceLow;
        if (this.field_75038_b.nextInt(chance) == Math.abs(offsetX) % chance && this.field_75038_b.nextInt(chance) == Math.abs(offsetZ) % chance) {
            float coneRadius = this.field_75038_b.nextInt(this.maxSize - this.minSize) + this.minSize;
            float stretch = 1.0f / (this.field_75038_b.nextFloat() * this.field_75038_b.nextFloat() * (this.maxPoint - this.minPoint) + this.minPoint);
            float direction = this.field_75038_b.nextFloat() * (float)Math.PI * 2.0f;
            float tilt = this.field_75038_b.nextFloat() * (this.maxTilt - this.minTilt) + this.minTilt;
            if (this.curve) {
                tilt = (float)((double)tilt * 0.01);
            }
            int xCoord = -offsetX + chunkX;
            int zCoord = -offsetZ + chunkZ;
            float tx = (float)Math.cos(direction) * tilt;
            float tz = (float)Math.sin(direction) * tilt;
            int ox = (int)(tx * (float)(this.curve ? 800 : 8));
            int oz = (int)(tz * (float)(this.curve ? 800 : 8));
            for (int bx = 15; bx >= 0; --bx) {
                block1: for (int bz = 15; bz >= 0; --bz) {
                    int index;
                    int d = 0;
                    for (int y = this.mid + 63; !(y < 0 || blocks[index = (bx * 16 + bz) * 256 + y] != null && blocks[index].func_149662_c()); --y) {
                        int x = xCoord * 16 + bx - ox;
                        int z = zCoord * 16 + bz - oz;
                        int oy = y - this.mid;
                        float factor = oy;
                        if (this.curve) {
                            factor *= factor;
                        }
                        x = (int)((float)x + tx * factor);
                        z = (int)((float)z + tz * factor);
                        float rs = x * x + z * z;
                        float radiusSqr = coneRadius - (float)oy * stretch;
                        if (radiusSqr > 0.0f) {
                            radiusSqr *= radiusSqr;
                        }
                        if (rs < radiusSqr) {
                            blocks[index] = this.rock;
                            if (d == 1) {
                                blocks[index + 1] = this.regolith;
                            }
                            ++d;
                            continue;
                        }
                        if (d > 0) continue block1;
                    }
                }
            }
        }
    }
}

