/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.dim.duna;

import com.hbm.blocks.ModBlocks;
import com.hbm.dim.WorldChunkManagerCelestial;
import com.hbm.dim.WorldProviderCelestial;
import com.hbm.dim.WorldTypeTeleport;
import com.hbm.dim.duna.ChunkProviderDuna;
import com.hbm.dim.duna.genlayer.GenLayerDiversifyDuna;
import com.hbm.dim.duna.genlayer.GenLayerDunaBiomes;
import com.hbm.dim.duna.genlayer.GenLayerDunaLowlands;
import com.hbm.util.BobMathUtil;
import com.hbm.util.ParticleUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.GenLayerFuzzyZoom;
import net.minecraft.world.gen.layer.GenLayerRiver;
import net.minecraft.world.gen.layer.GenLayerRiverMix;
import net.minecraft.world.gen.layer.GenLayerSmooth;
import net.minecraft.world.gen.layer.GenLayerVoronoiZoom;
import net.minecraft.world.gen.layer.GenLayerZoom;
import net.minecraftforge.client.event.EntityViewRenderEvent;

public class WorldProviderDuna
extends WorldProviderCelestial {
    private int dustStormTimer = 0;
    private float dustStormIntensity = 1.0f;
    private float dustStormSmoothed = 0.0f;

    @Override
    public void func_76572_b() {
        this.field_76578_c = new WorldChunkManagerCelestial(WorldProviderDuna.createBiomeGenerators(this.field_76579_a.func_72905_C()));
    }

    public String func_80007_l() {
        return "Duna";
    }

    public IChunkProvider func_76555_c() {
        return new ChunkProviderDuna(this.field_76579_a, this.getSeed(), false);
    }

    @Override
    public void updateWeather() {
        super.updateWeather();
        this.dustStormSmoothed = (float)BobMathUtil.lerp(0.008, this.dustStormSmoothed, this.dustStormIntensity);
        if (!this.field_76579_a.field_72995_K) {
            if (this.dustStormTimer <= 0) {
                if (this.dustStormIntensity >= 0.05f) {
                    this.dustStormIntensity = 0.0f;
                    this.dustStormTimer = this.field_76579_a.field_73012_v.nextInt(168000) + 12000;
                } else {
                    this.dustStormIntensity = this.field_76579_a.field_73012_v.nextFloat() * 0.75f + 0.25f;
                    this.dustStormTimer = this.field_76579_a.field_73012_v.nextInt(12000) + 12000;
                }
            }
            --this.dustStormTimer;
        } else if (this.dustStormSmoothed >= 0.05f && this.field_76579_a.field_73012_v.nextFloat() < this.dustStormSmoothed) {
            EntityLivingBase viewEntity = Minecraft.func_71410_x().field_71451_h;
            Vec3 vec = Vec3.func_72443_a((double)20.0, (double)0.0, (double)50.0);
            vec.func_72446_c((float)(this.field_76579_a.field_73012_v.nextDouble() * Math.PI * 10.0));
            vec.func_72442_b((float)(this.field_76579_a.field_73012_v.nextDouble() * Math.PI * 2.0 * 5.0));
            ParticleUtil.spawnDustFlame(this.field_76579_a, viewEntity.field_70165_t + vec.field_72450_a, viewEntity.field_70163_u, viewEntity.field_70161_v + vec.field_72449_c, -4.0, 0.0, 0.0);
        }
    }

    @Override
    public float fogDensity(EntityViewRenderEvent.FogDensity event) {
        if (this.dustStormSmoothed >= 0.25f) {
            return this.dustStormSmoothed * this.dustStormSmoothed * 0.075f;
        }
        return super.fogDensity(event);
    }

    public boolean isDaytime() {
        if (this.dustStormIntensity >= 0.2f) {
            return false;
        }
        return super.isDaytime();
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74768_a("dustStormTimer", this.dustStormTimer);
        nbt.func_74776_a("dustStormIntensity", this.dustStormIntensity);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.dustStormTimer = nbt.func_74762_e("dustStormTimer");
        this.dustStormIntensity = nbt.func_74760_g("dustStormIntensity");
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeFloat(this.dustStormIntensity);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.dustStormIntensity = buf.readFloat();
    }

    @Override
    public void resetRainAndThunder() {
        super.resetRainAndThunder();
        this.dustStormIntensity = 0.0f;
        this.dustStormSmoothed = 0.0f;
        this.dustStormTimer = this.field_76579_a.field_73012_v.nextInt(168000) + 12000;
    }

    @Override
    public Block getStone() {
        return ModBlocks.duna_rock;
    }

    @Override
    public boolean hasIce() {
        return true;
    }

    @Override
    public double getHorizon() {
        return 52.0;
    }

    @Override
    public int getRespawnDimension(EntityPlayerMP player) {
        if (this.field_76579_a.func_72912_H().func_76067_t() == WorldTypeTeleport.martian) {
            return this.field_76574_g;
        }
        return super.getRespawnDimension(player);
    }

    private static WorldChunkManagerCelestial.BiomeGenLayers createBiomeGenerators(long seed) {
        GenLayer biomes = new GenLayerDunaBiomes(seed);
        biomes = new GenLayerFuzzyZoom(2000L, biomes);
        biomes = new GenLayerZoom(2001L, biomes);
        biomes = new GenLayerDiversifyDuna(1000L, biomes);
        biomes = new GenLayerZoom(1000L, biomes);
        biomes = new GenLayerDiversifyDuna(1001L, biomes);
        biomes = new GenLayerZoom(1001L, biomes);
        biomes = new GenLayerDunaLowlands(1300L, biomes);
        biomes = new GenLayerZoom(1003L, biomes);
        biomes = new GenLayerSmooth(700L, biomes);
        biomes = new GenLayerZoom(1005L, biomes);
        biomes = new GenLayerSmooth(703L, biomes);
        biomes = new GenLayerFuzzyZoom(1000L, biomes);
        biomes = new GenLayerSmooth(705L, biomes);
        biomes = new GenLayerFuzzyZoom(1001L, biomes);
        biomes = new GenLayerZoom(1006L, biomes);
        GenLayerVoronoiZoom genlayerVoronoiZoom = new GenLayerVoronoiZoom(10L, biomes);
        GenLayerZoom genlayerRiverZoom = new GenLayerZoom(1000L, biomes);
        GenLayerRiver genlayerRiver = new GenLayerRiver(1004L, (GenLayer)genlayerRiverZoom);
        genlayerRiver = new GenLayerZoom(105L, (GenLayer)genlayerRiver);
        GenLayerRiverMix genlayerRiverMix = new GenLayerRiverMix(100L, biomes, (GenLayer)genlayerRiver);
        return new WorldChunkManagerCelestial.BiomeGenLayers((GenLayer)genlayerRiverMix, (GenLayer)genlayerVoronoiZoom, seed);
    }
}

