/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.dim;

import com.hbm.blocks.BlockEnums;
import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.generic.BlockOre;
import com.hbm.config.WorldConfig;
import com.hbm.dim.CelestialBody;
import com.hbm.dim.SolarSystem;
import com.hbm.dim.WorldProviderCelestial;
import com.hbm.inventory.FluidStack;
import com.hbm.items.ModItems;
import com.hbm.main.StructureManager;
import com.hbm.util.WeightedRandomGeneric;
import com.hbm.world.PlanetGen;
import com.hbm.world.feature.BedrockOre;
import com.hbm.world.feature.DepthDeposit;
import com.hbm.world.gen.component.Component;
import com.hbm.world.gen.nbt.JigsawPiece;
import com.hbm.world.gen.nbt.JigsawPool;
import com.hbm.world.gen.nbt.NBTStructure;
import com.hbm.world.gen.nbt.SpawnCondition;
import com.hbm.world.generator.DungeonToolbox;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraftforge.event.terraingen.OreGenEvent;

public class WorldGeneratorCelestial
implements IWorldGenerator {
    public WorldGeneratorCelestial() {
        final HashMap<Block, StructureComponent.BlockSelector> bricks = new HashMap<Block, StructureComponent.BlockSelector>(){
            {
                this.put(ModBlocks.meteor_brick, new Component.MeteorBricks());
            }
        };
        final HashMap<Block, StructureComponent.BlockSelector> crates = new HashMap<Block, StructureComponent.BlockSelector>(){
            {
                this.put(ModBlocks.meteor_brick, new Component.MeteorBricks());
                this.put(ModBlocks.crate, new Component.SupplyCrates());
                this.put(ModBlocks.meteor_spawner, new Component.CrabSpawners());
            }
        };
        final HashMap<Block, StructureComponent.BlockSelector> ooze = new HashMap<Block, StructureComponent.BlockSelector>(){
            {
                this.put(ModBlocks.meteor_brick, new Component.MeteorBricks());
                this.put(ModBlocks.concrete_colored, new Component.GreenOoze());
            }
        };
        NBTStructure.registerStructure(new SpawnCondition("meteor_dungeon"){
            {
                super(name);
                this.minHeight = 32;
                this.maxHeight = 32;
                this.sizeLimit = 128;
                this.canSpawn = biome -> biome.field_76748_D >= 0.0f;
                this.startPool = "start";
                this.pools = new HashMap<String, JigsawPool>(){
                    {
                        this.put("start", new JigsawPool(){
                            {
                                this.add(new JigsawPiece("meteor_core", StructureManager.meteor_core){
                                    {
                                        this.blockTable = bricks;
                                    }
                                }, 1);
                            }
                        });
                        this.put("spike", new JigsawPool(){
                            {
                                this.add(new JigsawPiece("meteor_spike", StructureManager.meteor_spike){
                                    {
                                        this.heightOffset = -3;
                                        this.conformToTerrain = true;
                                    }
                                }, 1);
                            }
                        });
                        this.put("default", new JigsawPool(){
                            {
                                this.add(new JigsawPiece("meteor_corner", StructureManager.meteor_corner){
                                    {
                                        this.blockTable = bricks;
                                    }
                                }, 2);
                                this.add(new JigsawPiece("meteor_t", StructureManager.meteor_t){
                                    {
                                        this.blockTable = bricks;
                                    }
                                }, 3);
                                this.add(new JigsawPiece("meteor_stairs", StructureManager.meteor_stairs){
                                    {
                                        this.blockTable = bricks;
                                    }
                                }, 1);
                                this.add(new JigsawPiece("meteor_room_base_thru", StructureManager.meteor_room_base_thru){
                                    {
                                        this.blockTable = bricks;
                                    }
                                }, 3);
                                this.add(new JigsawPiece("meteor_room_base_end", StructureManager.meteor_room_base_end){
                                    {
                                        this.blockTable = bricks;
                                    }
                                }, 4);
                                this.fallback = "fallback";
                            }
                        });
                        this.put("10room", new JigsawPool(){
                            {
                                this.add(new JigsawPiece("meteor_room_basic", StructureManager.meteor_room_basic){
                                    {
                                        this.blockTable = bricks;
                                    }
                                }, 1);
                                this.add(new JigsawPiece("meteor_room_balcony", StructureManager.meteor_room_balcony){
                                    {
                                        this.blockTable = bricks;
                                    }
                                }, 1);
                                this.add(new JigsawPiece("meteor_room_dragon", StructureManager.meteor_room_dragon){
                                    {
                                        this.blockTable = bricks;
                                    }
                                }, 1);
                                this.add(new JigsawPiece("meteor_room_ladder", StructureManager.meteor_room_ladder){
                                    {
                                        this.blockTable = bricks;
                                    }
                                }, 1);
                                this.add(new JigsawPiece("meteor_room_ooze", StructureManager.meteor_room_ooze){
                                    {
                                        this.blockTable = ooze;
                                    }
                                }, 1);
                                this.add(new JigsawPiece("meteor_room_split", StructureManager.meteor_room_split){
                                    {
                                        this.blockTable = bricks;
                                    }
                                }, 1);
                                this.add(new JigsawPiece("meteor_room_stairs", StructureManager.meteor_room_stairs){
                                    {
                                        this.blockTable = bricks;
                                    }
                                }, 1);
                                this.add(new JigsawPiece("meteor_room_triple", StructureManager.meteor_room_triple){
                                    {
                                        this.blockTable = bricks;
                                    }
                                }, 1);
                                this.fallback = "roomback";
                            }
                        });
                        this.put("3x3loot", new JigsawPool(){
                            {
                                this.add(new JigsawPiece("meteor_3_bale", StructureManager.meteor_3_bale), 1);
                                this.add(new JigsawPiece("meteor_3_blank", StructureManager.meteor_3_blank), 1);
                                this.add(new JigsawPiece("meteor_3_block", StructureManager.meteor_3_block), 1);
                                this.add(new JigsawPiece("meteor_3_crab", StructureManager.meteor_3_crab), 1);
                                this.add(new JigsawPiece("meteor_3_crab_tesla", StructureManager.meteor_3_crab_tesla), 1);
                                this.add(new JigsawPiece("meteor_3_crate", StructureManager.meteor_3_crate), 1);
                                this.add(new JigsawPiece("meteor_3_dirt", StructureManager.meteor_3_dirt), 1);
                                this.add(new JigsawPiece("meteor_3_lead", StructureManager.meteor_3_lead), 1);
                                this.add(new JigsawPiece("meteor_3_ooze", StructureManager.meteor_3_ooze), 1);
                                this.add(new JigsawPiece("meteor_3_pillar", StructureManager.meteor_3_pillar), 1);
                                this.add(new JigsawPiece("meteor_3_star", StructureManager.meteor_3_star), 1);
                                this.add(new JigsawPiece("meteor_3_tesla", StructureManager.meteor_3_tesla), 1);
                                this.add(new JigsawPiece("meteor_3_book", StructureManager.meteor_3_book), 1);
                                this.add(new JigsawPiece("meteor_3_mku", StructureManager.meteor_3_mku), 1);
                                this.add(new JigsawPiece("meteor_3_statue", StructureManager.meteor_3_statue), 1);
                                this.add(new JigsawPiece("meteor_3_glow", StructureManager.meteor_3_glow), 1);
                                this.fallback = "3x3loot";
                            }
                        });
                        this.put("headloot", new JigsawPool(){
                            {
                                this.add(new JigsawPiece("meteor_dragon_chest", StructureManager.meteor_dragon_chest){
                                    {
                                        this.blockTable = crates;
                                    }
                                }, 1);
                                this.add(new JigsawPiece("meteor_dragon_tesla", StructureManager.meteor_dragon_tesla){
                                    {
                                        this.blockTable = crates;
                                    }
                                }, 1);
                                this.add(new JigsawPiece("meteor_dragon_trap", StructureManager.meteor_dragon_trap){
                                    {
                                        this.blockTable = crates;
                                    }
                                }, 1);
                                this.add(new JigsawPiece("meteor_dragon_crate_crab", StructureManager.meteor_dragon_crate_crab){
                                    {
                                        this.blockTable = crates;
                                    }
                                }, 1);
                                this.fallback = "headback";
                            }
                        });
                        this.put("fallback", new JigsawPool(){
                            {
                                this.add(new JigsawPiece("meteor_fallback", StructureManager.meteor_fallback){
                                    {
                                        this.blockTable = bricks;
                                    }
                                }, 1);
                            }
                        });
                        this.put("roomback", new JigsawPool(){
                            {
                                this.add(new JigsawPiece("meteor_room_fallback", StructureManager.meteor_room_fallback){
                                    {
                                        this.blockTable = bricks;
                                    }
                                }, 1);
                            }
                        });
                        this.put("headback", new JigsawPool(){
                            {
                                this.add(new JigsawPiece("meteor_loot_fallback", StructureManager.meteor_dragon_fallback){
                                    {
                                        this.blockTable = crates;
                                    }
                                }, 1);
                            }
                        });
                    }
                };
            }
        }, PlanetGen.getSpaceDimensions());
        BlockOre.addAllBodies(ModBlocks.ore_iron);
        BlockOre.addAllBodies(ModBlocks.ore_gold);
        BlockOre.addAllBodies(ModBlocks.ore_diamond);
        BlockOre.addAllBodies(ModBlocks.ore_redstone);
        BlockOre.addValidBody(ModBlocks.ore_emerald, SolarSystem.Body.KERBIN);
        BlockOre.addValidBody(ModBlocks.ore_lapis, SolarSystem.Body.KERBIN);
        BlockOre.addAllBodies(ModBlocks.ore_uranium);
        BlockOre.addAllBodies(ModBlocks.ore_thorium);
        BlockOre.addAllBodies(ModBlocks.ore_titanium);
        BlockOre.addAllBodies(ModBlocks.ore_sulfur);
        BlockOre.addAllBodies(ModBlocks.ore_aluminium);
        BlockOre.addAllBodies(ModBlocks.ore_copper);
        BlockOre.addAllBodies(ModBlocks.ore_zinc);
        BlockOre.addAllBodies(ModBlocks.ore_fluorite);
        BlockOre.addAllBodies(ModBlocks.ore_niter);
        BlockOre.addAllBodies(ModBlocks.ore_tungsten);
        BlockOre.addAllBodies(ModBlocks.ore_lead);
        BlockOre.addAllBodies(ModBlocks.ore_beryllium);
        BlockOre.addAllBodies(ModBlocks.ore_rare);
        BlockOre.addAllBodies(ModBlocks.ore_cinnebar);
        BlockOre.addAllBodies(ModBlocks.ore_cobalt);
        BlockOre.addAllBodies(ModBlocks.cluster_iron);
        BlockOre.addAllBodies(ModBlocks.cluster_titanium);
        BlockOre.addAllBodies(ModBlocks.cluster_aluminium);
        BlockOre.addAllBodies(ModBlocks.cluster_copper);
        BlockOre.addValidBody(ModBlocks.ore_asbestos, SolarSystem.Body.KERBIN);
        BlockOre.addValidBody(ModBlocks.ore_lignite, SolarSystem.Body.KERBIN);
        BlockOre.addValidBody(ModBlocks.ore_oil, SolarSystem.Body.KERBIN);
        BlockOre.addValidBody(ModBlocks.ore_bedrock_oil, SolarSystem.Body.KERBIN);
        BlockOre.addValidBody(ModBlocks.ore_coltan, SolarSystem.Body.KERBIN);
        BlockOre.addAllExcept(ModBlocks.ore_nickel, SolarSystem.Body.KERBIN);
    }

    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (!(world.field_73011_w instanceof WorldProviderCelestial)) {
            return;
        }
        if (world.field_73011_w.field_76574_g == 0) {
            return;
        }
        WorldProviderCelestial celestialProvider = (WorldProviderCelestial)world.field_73011_w;
        Block blockToReplace = celestialProvider.getStone();
        FluidStack drillAcid = celestialProvider.getBedrockAcid();
        boolean hasIce = celestialProvider.hasIce();
        int meta = CelestialBody.getMeta(world);
        this.generateStructures(world, rand, chunkX * 16, chunkZ * 16);
        if (blockToReplace != Blocks.field_150348_b) {
            this.generateVanillaOres(world, rand, chunkX * 16, chunkZ * 16, blockToReplace, meta);
        }
        this.generateNTMOres(world, rand, chunkX * 16, chunkZ * 16, blockToReplace, meta);
        this.generateBedrockOres(world, rand, chunkX * 16, chunkZ * 16, blockToReplace, hasIce, drillAcid);
    }

    public void generateStructures(World world, Random rand, int x, int z) {
    }

    public void generateNTMOres(World world, Random rand, int x, int z, Block planetStone, int meta) {
        int rz;
        int ry;
        int rx;
        if (WorldConfig.alexandriteSpawn > 0 && rand.nextInt(WorldConfig.alexandriteSpawn) == 0) {
            DungeonToolbox.generateOre(world, rand, x, z, 1, 3, 10, 5, ModBlocks.ore_alexandrite, 0, planetStone);
        }
        DepthDeposit.generateCondition(world, x, 0, 3, z, 5, 0.6, ModBlocks.cluster_depth_iron, rand, 24, planetStone, ModBlocks.stone_depth);
        DepthDeposit.generateCondition(world, x, 0, 3, z, 5, 0.6, ModBlocks.cluster_depth_titanium, rand, 32, planetStone, ModBlocks.stone_depth);
        DepthDeposit.generateCondition(world, x, 0, 3, z, 5, 0.6, ModBlocks.cluster_depth_tungsten, rand, 32, planetStone, ModBlocks.stone_depth);
        DepthDeposit.generateCondition(world, x, 0, 3, z, 5, 0.8, ModBlocks.ore_depth_cinnebar, rand, 16, planetStone, ModBlocks.stone_depth);
        DepthDeposit.generateCondition(world, x, 0, 3, z, 5, 0.8, ModBlocks.ore_depth_zirconium, rand, 16, planetStone, ModBlocks.stone_depth);
        DepthDeposit.generateCondition(world, x, 0, 3, z, 5, 0.8, ModBlocks.ore_depth_borax, rand, 16, planetStone, ModBlocks.stone_depth);
        DungeonToolbox.generateOre(world, rand, x, z, WorldConfig.uraniumSpawn, 5, 5, 20, ModBlocks.ore_uranium, meta, planetStone);
        DungeonToolbox.generateOre(world, rand, x, z, WorldConfig.thoriumSpawn, 5, 5, 25, ModBlocks.ore_thorium, meta, planetStone);
        DungeonToolbox.generateOre(world, rand, x, z, WorldConfig.titaniumSpawn, 6, 5, 30, ModBlocks.ore_titanium, meta, planetStone);
        DungeonToolbox.generateOre(world, rand, x, z, WorldConfig.sulfurSpawn, 8, 5, 30, ModBlocks.ore_sulfur, meta, planetStone);
        DungeonToolbox.generateOre(world, rand, x, z, WorldConfig.aluminiumSpawn, 6, 5, 40, ModBlocks.ore_aluminium, meta, planetStone);
        DungeonToolbox.generateOre(world, rand, x, z, WorldConfig.copperSpawn, 6, 5, 45, ModBlocks.ore_copper, meta, planetStone);
        DungeonToolbox.generateOre(world, rand, x, z, WorldConfig.nickelSpawn, 6, 5, 10, ModBlocks.ore_nickel, meta, planetStone);
        DungeonToolbox.generateOre(world, rand, x, z, WorldConfig.zincSpawn, 6, 5, 32, ModBlocks.ore_zinc, meta, planetStone);
        DungeonToolbox.generateOre(world, rand, x, z, WorldConfig.fluoriteSpawn, 4, 5, 45, ModBlocks.ore_fluorite, meta, planetStone);
        DungeonToolbox.generateOre(world, rand, x, z, WorldConfig.niterSpawn, 6, 5, 30, ModBlocks.ore_niter, meta, planetStone);
        DungeonToolbox.generateOre(world, rand, x, z, WorldConfig.tungstenSpawn, 8, 5, 30, ModBlocks.ore_tungsten, meta, planetStone);
        DungeonToolbox.generateOre(world, rand, x, z, WorldConfig.leadSpawn, 9, 5, 30, ModBlocks.ore_lead, meta, planetStone);
        DungeonToolbox.generateOre(world, rand, x, z, WorldConfig.berylliumSpawn, 4, 5, 30, ModBlocks.ore_beryllium, meta, planetStone);
        DungeonToolbox.generateOre(world, rand, x, z, WorldConfig.rareSpawn, 5, 5, 20, ModBlocks.ore_rare, meta, planetStone);
        DungeonToolbox.generateOre(world, rand, x, z, WorldConfig.cinnebarSpawn, 4, 8, 16, ModBlocks.ore_cinnebar, meta, planetStone);
        DungeonToolbox.generateOre(world, rand, x, z, WorldConfig.cobaltSpawn, 4, 4, 8, ModBlocks.ore_cobalt, meta, planetStone);
        DungeonToolbox.generateOre(world, rand, x, z, WorldConfig.ironClusterSpawn, 6, 15, 45, ModBlocks.cluster_iron, meta, planetStone);
        DungeonToolbox.generateOre(world, rand, x, z, WorldConfig.titaniumClusterSpawn, 6, 15, 30, ModBlocks.cluster_titanium, meta, planetStone);
        DungeonToolbox.generateOre(world, rand, x, z, WorldConfig.aluminiumClusterSpawn, 6, 15, 35, ModBlocks.cluster_aluminium, meta, planetStone);
        DungeonToolbox.generateOre(world, rand, x, z, WorldConfig.copperClusterSpawn, 6, 15, 20, ModBlocks.cluster_copper, meta, planetStone);
        DungeonToolbox.generateOre(world, rand, x, z, WorldConfig.limestoneSpawn, 12, 25, 30, ModBlocks.stone_resource, BlockEnums.EnumStoneType.CALCIUM.ordinal(), planetStone);
        if (rand.nextInt(4) == 0 && world.func_147439_a(rx = x + rand.nextInt(16) + 8, ry = 6 + rand.nextInt(13), rz = z + rand.nextInt(16) + 8).isReplaceableOreGen(world, rx, ry, rz, planetStone)) {
            world.func_147449_b(rx, ry, rz, ModBlocks.stone_keyhole);
        }
    }

    public void generateBedrockOres(World world, Random rand, int x, int z, Block planetStone, boolean hasIce, FluidStack drillAcid) {
        if (WorldConfig.newBedrockOres) {
            if (rand.nextInt(10) == 0) {
                int randPosX = x + rand.nextInt(2) + 8;
                int randPosZ = z + rand.nextInt(2) + 8;
                BedrockOre.generate(world, randPosX, randPosZ, new ItemStack(ModItems.bedrock_ore_base), drillAcid, 14125590, 1, ModBlocks.stone_depth, planetStone);
            } else if (hasIce && rand.nextInt(3) == 0) {
                int randPosX = x + rand.nextInt(2) + 8;
                int randPosZ = z + rand.nextInt(2) + 8;
                BedrockOre.generate(world, randPosX, randPosZ, new ItemStack(Blocks.field_150403_cj, 32), null, 0xAAFFFF, 1);
            }
        } else if (rand.nextInt(3) == 0) {
            List<WeightedRandomGeneric<BedrockOre.BedrockOreDefinition>> list = BedrockOre.weightedOres;
            SolarSystem.Body bodyEnum = CelestialBody.getEnum(world);
            if (BedrockOre.weightedPlanetOres.containsKey((Object)bodyEnum)) {
                list = BedrockOre.weightedPlanetOres.get((Object)bodyEnum);
            }
            WeightedRandomGeneric item = (WeightedRandomGeneric)WeightedRandom.func_76271_a((Random)rand, list);
            BedrockOre.BedrockOreDefinition def = (BedrockOre.BedrockOreDefinition)item.get();
            int randPosX = x + rand.nextInt(2) + 8;
            int randPosZ = z + rand.nextInt(2) + 8;
            BedrockOre.generate(world, randPosX, randPosZ, def.stack, def.acid, def.color, def.tier, ModBlocks.stone_depth, planetStone);
        }
    }

    public void generateVanillaOres(World world, Random rand, int x, int z, Block planetStone, int meta) {
        this.genVanillaOre(world, rand, x, z, 0, 64, 20, 8, ModBlocks.ore_iron, planetStone, meta);
        this.genVanillaOre(world, rand, x, z, 0, 32, 2, 8, ModBlocks.ore_gold, planetStone, meta);
        this.genVanillaOre(world, rand, x, z, 0, 16, 8, 7, ModBlocks.ore_redstone, planetStone, meta);
        this.genVanillaOre(world, rand, x, z, 0, 16, 1, 7, ModBlocks.ore_diamond, planetStone, meta);
    }

    public static void onGenerateOre(OreGenEvent.GenerateMinable event) {
        if (event.type == OreGenEvent.GenerateMinable.EventType.COAL) {
            event.setResult(Event.Result.DENY);
        }
    }

    private void genVanillaOre(World world, Random rand, int x, int z, int yMin, int yMax, int count, int numberOfBlocks, Block ore, Block target, int meta) {
        WorldGenMinable worldGenMinable = new WorldGenMinable(ore, meta, numberOfBlocks, target);
        for (int l = 0; l < count; ++l) {
            int genX = x + rand.nextInt(16);
            int genY = rand.nextInt(yMax - yMin) + yMin;
            int genZ = z + rand.nextInt(16);
            worldGenMinable.func_76484_a(world, rand, genX, genY, genZ);
        }
    }
}

