/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.machine;

import com.hbm.blocks.BlockDummyable;
import com.hbm.blocks.ILookOverlay;
import com.hbm.dim.CelestialBody;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.tileentity.TileEntityProxyCombo;
import com.hbm.tileentity.machine.TileEntityXenonThruster;
import com.hbm.util.BobMathUtil;
import com.hbm.util.i18n.I18nUtil;
import java.util.ArrayList;
import net.minecraft.block.material.Material;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.util.ForgeDirection;

public class MachineXenonThruster
extends BlockDummyable
implements ILookOverlay {
    public MachineXenonThruster(Material mat) {
        super(mat);
    }

    public TileEntity func_149915_a(World world, int meta) {
        if (meta >= 12) {
            return new TileEntityXenonThruster();
        }
        if (meta >= 6) {
            return new TileEntityProxyCombo(false, true, true);
        }
        return null;
    }

    @Override
    public int[] getDimensions() {
        return new int[]{1, 1, 0, 1, 1, 1};
    }

    @Override
    public int getOffset() {
        return 1;
    }

    @Override
    public int getHeightOffset() {
        return 1;
    }

    @Override
    public void fillSpace(World world, int x, int y, int z, ForgeDirection dir, int o) {
        super.fillSpace(world, x, y, z, dir, o);
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        this.makeExtra(world, (x += dir.offsetX * o) - rot.offsetX, y, (z += dir.offsetZ * o) - rot.offsetZ);
        this.makeExtra(world, x + rot.offsetX, y, z + rot.offsetZ);
    }

    @Override
    public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
        if (!CelestialBody.inOrbit(world)) {
            return;
        }
        int[] pos = this.findCore(world, x, y, z);
        if (pos == null) {
            return;
        }
        TileEntity te = world.func_147438_o(pos[0], pos[1], pos[2]);
        if (!(te instanceof TileEntityXenonThruster)) {
            return;
        }
        TileEntityXenonThruster thruster = (TileEntityXenonThruster)te;
        ArrayList<String> text = new ArrayList<String>();
        if (!thruster.isFacingPrograde()) {
            text.add("&[" + (BobMathUtil.getBlink() ? 0xFF0000 : 0xFFFF00) + "&]! ! ! " + I18nUtil.resolveKey("atmosphere.engineFacing", new Object[0]) + " ! ! !");
        } else {
            text.add((thruster.power == 0L ? EnumChatFormatting.RED : EnumChatFormatting.GREEN) + BobMathUtil.getShortNumber(thruster.power) + "HE");
            for (int i = 0; i < thruster.tanks.length; ++i) {
                FluidTank tank = thruster.tanks[i];
                text.add(EnumChatFormatting.GREEN + "-> " + EnumChatFormatting.RESET + tank.getTankType().getLocalizedName() + ": " + tank.getFill() + "/" + tank.getMaxFill() + "mB");
            }
        }
        ILookOverlay.printGeneric(event, I18nUtil.resolveKey(this.func_149739_a() + ".name", new Object[0]), 0xFFFF00, 0x404000, text);
    }
}

