/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.chunk.internal.mixin.mixins.common.vanilla;

import com.falsepattern.chunk.internal.mixin.helpers.LockHelper;
import java.io.IOException;
import java.util.concurrent.Semaphore;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.S21PacketChunkData;
import net.minecraft.network.play.server.S26PacketMapChunkBulk;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={S26PacketMapChunkBulk.class})
public abstract class S26PacketMapChunkBulkMixin {
    @Shadow(aliases={"field_149268_i"}, remap=false)
    private static byte[] inflaterBuffer;
    @Shadow(aliases={"field_149263_e"}, remap=false)
    private byte[] deflatedData;
    @Shadow(remap=false)
    private Semaphore deflateGate;
    @Shadow(aliases={"field_149266_a"}, remap=false)
    private int[] xPositions;
    @Shadow(aliases={"field_149264_b"}, remap=false)
    private int[] zPositions;
    @Shadow(aliases={"field_149265_c"}, remap=false)
    private int[] subChunkMasks;
    @Shadow(aliases={"field_149262_d"}, remap=false)
    private int[] subChunkMSBMasks;
    @Shadow(aliases={"field_149261_g"}, remap=false)
    private int deflatedSize;
    @Shadow(aliases={"field_149267_h"}, remap=false)
    private boolean skylight;
    @Shadow(aliases={"field_149260_f"}, remap=false)
    private byte[][] datas;

    @Shadow(remap=false)
    protected abstract void deflate();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite
    public void func_148837_a(PacketBuffer data) throws IOException {
        byte[] buf;
        int chunkCount = data.readShort();
        int[] sizes = new int[chunkCount];
        for (int i = 0; i < chunkCount; ++i) {
            sizes[i] = data.readInt();
        }
        this.deflatedSize = data.readInt();
        this.skylight = data.readBoolean();
        this.xPositions = new int[chunkCount];
        this.zPositions = new int[chunkCount];
        this.subChunkMasks = new int[chunkCount];
        this.subChunkMSBMasks = new int[chunkCount];
        this.datas = new byte[chunkCount][];
        while (!LockHelper.bufferLockS26PacketMapChunkBulk.tryLock()) {
            Thread.yield();
        }
        try {
            if (inflaterBuffer.length < this.deflatedSize) {
                inflaterBuffer = new byte[this.deflatedSize];
            }
            data.readBytes(inflaterBuffer, 0, this.deflatedSize);
            buf = new byte[S21PacketChunkData.func_149275_c() * chunkCount];
            Inflater inflater = new Inflater();
            inflater.setInput(inflaterBuffer, 0, this.deflatedSize);
            try {
                inflater.inflate(buf);
            }
            catch (DataFormatException dataformatexception) {
                throw new IOException("Bad compressed data format");
            }
            finally {
                inflater.end();
            }
        }
        finally {
            LockHelper.bufferLockS26PacketMapChunkBulk.unlock();
        }
        int pos = 0;
        for (int i = 0; i < chunkCount; ++i) {
            int size = sizes[i];
            this.xPositions[i] = data.readInt();
            this.zPositions[i] = data.readInt();
            this.subChunkMasks[i] = data.readUnsignedShort();
            this.datas[i] = new byte[size];
            System.arraycopy(buf, pos, this.datas[i], 0, size);
            pos += size;
        }
    }

    @Overwrite
    public void func_148840_b(PacketBuffer data) {
        if (this.deflatedData == null) {
            this.deflateGate.acquireUninterruptibly();
            if (this.deflatedData == null) {
                this.deflate();
            }
            this.deflateGate.release();
        }
        data.writeShort(this.xPositions.length);
        for (byte[] bytes : this.datas) {
            data.writeInt(bytes.length);
        }
        data.writeInt(this.deflatedSize);
        data.writeBoolean(this.skylight);
        data.writeBytes(this.deflatedData, 0, this.deflatedSize);
        for (int i = 0; i < this.xPositions.length; ++i) {
            data.writeInt(this.xPositions[i]);
            data.writeInt(this.zPositions[i]);
            data.writeShort((int)((short)(this.subChunkMasks[i] & 0xFFFF)));
        }
    }
}

