/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.chunk.internal.mixin.mixins.common.vanilla;

import com.falsepattern.chunk.internal.DataRegistryImpl;
import com.falsepattern.chunk.internal.impl.CustomPacketBlockChange;
import com.falsepattern.chunk.internal.impl.CustomPacketMultiBlockChange;
import java.io.IOException;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.S22PacketMultiBlockChange;
import net.minecraft.network.play.server.S23PacketBlockChange;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.chunk.Chunk;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={S22PacketMultiBlockChange.class})
public abstract class S22PacketMultiBlockChangeMixin
implements CustomPacketMultiBlockChange {
    @Shadow(aliases={"field_148925_b"}, remap=false)
    private ChunkCoordIntPair coord;
    private S23PacketBlockChange[] subPackets;

    @Inject(method={"<init>(I[SLnet/minecraft/world/chunk/Chunk;)V"}, at={@At(value="FIELD", target="Lnet/minecraft/network/play/server/S22PacketMultiBlockChange;field_148925_b:Lnet/minecraft/world/ChunkCoordIntPair;", unsafe=true)}, require=1)
    private void suppressConstructor(int p_i45181_1_, short[] crammedPositions, Chunk chunk, CallbackInfo ci) {
        throw new IllegalStateException("S22PacketMultiBlockChange constructor is not supported by ChunkAPI. Please report this to FalsePattern!");
    }

    @Override
    public void chunkapi$init(int count, short[] crammedPositions, Chunk chunk) {
        this.coord = new ChunkCoordIntPair(chunk.field_76635_g, chunk.field_76647_h);
        this.subPackets = new S23PacketBlockChange[count];
        for (int i = 0; i < count; ++i) {
            S23PacketBlockChange subPacket = new S23PacketBlockChange();
            int x = crammedPositions[i] >> 12 & 0xF;
            int z = crammedPositions[i] >> 8 & 0xF;
            int y = crammedPositions[i] & 0xFF;
            ((CustomPacketBlockChange)subPacket).chunkapi$init(x, y, z, chunk);
            this.subPackets[i] = subPacket;
        }
    }

    @Overwrite
    public void func_148837_a(PacketBuffer data) throws IOException {
        this.coord = new ChunkCoordIntPair(data.readInt(), data.readInt());
        int count = data.func_150792_a();
        this.subPackets = new S23PacketBlockChange[count];
        for (int i = 0; i < count; ++i) {
            S23PacketBlockChange subPacket;
            this.subPackets[i] = subPacket = new S23PacketBlockChange();
            CustomPacketBlockChange cSub = (CustomPacketBlockChange)subPacket;
            int pos = data.readUnsignedShort();
            int x = pos >> 12 & 0xF;
            int z = pos >> 8 & 0xF;
            int y = pos & 0xFF;
            cSub.chunkapi$x(x);
            cSub.chunkapi$y(y);
            cSub.chunkapi$z(z);
            DataRegistryImpl.readBlockPacketFromBuffer(subPacket, data);
        }
    }

    @Overwrite
    public void func_148840_b(PacketBuffer data) throws IOException {
        data.writeInt(this.coord.field_77276_a);
        data.writeInt(this.coord.field_77275_b);
        if (this.subPackets != null) {
            data.func_150787_b(this.subPackets.length);
            for (S23PacketBlockChange subPacket : this.subPackets) {
                CustomPacketBlockChange cSub = (CustomPacketBlockChange)subPacket;
                int pos = (cSub.chunkapi$x() & 0xF) << 12 | (cSub.chunkapi$z() & 0xF) << 8 | cSub.chunkapi$y() & 0xFF;
                data.writeShort(pos);
                DataRegistryImpl.writeBlockPacketToBuffer(subPacket, data);
            }
        } else {
            data.writeInt(0);
        }
    }

    @Override
    public S23PacketBlockChange[] chunkapi$subPackets() {
        return this.subPackets;
    }
}

