/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.chunk.internal.mixin.mixins.common.lookingglass;

import com.xcompwiz.lookingglass.log.LoggerUtils;
import com.xcompwiz.lookingglass.network.LookingGlassPacketManager;
import com.xcompwiz.lookingglass.network.packet.PacketChunkInfo;
import com.xcompwiz.lookingglass.network.packet.PacketHandlerBase;
import com.xcompwiz.lookingglass.network.packet.PacketRequestChunk;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import io.netty.buffer.ByteBuf;
import java.util.concurrent.Semaphore;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.play.server.S21PacketChunkData;
import net.minecraft.world.chunk.Chunk;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={PacketChunkInfo.class})
public abstract class PacketChunkInfoMixin
extends PacketHandlerBase {
    @Shadow(remap=false)
    private static Semaphore deflateGate;

    @Shadow(remap=false)
    private static int deflate(byte[] chunkData, byte[] compressedChunkData) {
        return 0;
    }

    @Shadow(remap=false)
    public abstract void handle(EntityPlayer var1, byte[] var2, int var3, int var4, int var5, boolean var6, short var7, short var8);

    @Shadow(remap=false)
    protected abstract byte[] inflateChunkData(ByteBuf var1, int var2, int var3);

    @Overwrite(remap=false)
    public static S21PacketChunkData.Extracted getMapChunkData(Chunk chunk, boolean forceUpdate, int subChunkMask) {
        return S21PacketChunkData.func_149269_a((Chunk)chunk, (boolean)forceUpdate, (int)subChunkMask);
    }

    @Overwrite(remap=false)
    public static FMLProxyPacket createPacket(Chunk chunk, boolean forceUpdate, int subChunkMask, int dim) {
        int xPos = chunk.field_76635_g;
        int zPos = chunk.field_76647_h;
        S21PacketChunkData.Extracted extracted = PacketChunkInfoMixin.getMapChunkData(chunk, forceUpdate, subChunkMask);
        int realSubChunkMask = extracted.field_150280_b;
        byte[] chunkData = extracted.field_150282_a;
        deflateGate.acquireUninterruptibly();
        byte[] compressedChunkData = new byte[chunkData.length];
        int len = PacketChunkInfoMixin.deflate(chunkData, compressedChunkData);
        deflateGate.release();
        ByteBuf data = PacketHandlerBase.createDataBuffer(PacketChunkInfo.class);
        data.writeInt(dim);
        data.writeInt(xPos);
        data.writeInt(zPos);
        data.writeBoolean(forceUpdate);
        data.writeShort((int)((short)(realSubChunkMask & 0xFFFF)));
        data.writeInt(len);
        data.writeInt(chunkData.length);
        data.ensureWritable(len);
        data.writeBytes(compressedChunkData, 0, len);
        return PacketChunkInfoMixin.buildPacket((ByteBuf)data);
    }

    @Overwrite(remap=false)
    public void handle(ByteBuf in, EntityPlayer player) {
        int uncompressedSize;
        int dim = in.readInt();
        int xPos = in.readInt();
        int zPos = in.readInt();
        boolean forceUpdate = in.readBoolean();
        int subChunkMask = in.readShort() & 0xFFFF;
        int compressedSize = in.readInt();
        byte[] chunkData = this.inflateChunkData(in, compressedSize, uncompressedSize = in.readInt());
        if (chunkData == null) {
            LookingGlassPacketManager.bus.sendToServer(PacketRequestChunk.createPacket((int)xPos, (int)subChunkMask, (int)zPos, (int)dim));
            LoggerUtils.error((String)"Chunk decompression failed: \t%d\t\t%d : %d\n", (Object[])new Object[]{subChunkMask, compressedSize, uncompressedSize});
        } else {
            this.handle(player, chunkData, dim, xPos, zPos, forceUpdate, (short)subChunkMask, (short)0);
        }
    }
}

