/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.chunk.internal;

import com.falsepattern.chunk.api.OrderedManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class DualMap<T> {
    private final Map<String, T> unordered = new HashMap<String, T>();
    private final SortedMap<OrderedManager, T> ordered = new TreeMap<OrderedManager, T>();

    public void put(OrderedManager man, T value) {
        T b;
        T a = this.unordered.put(man.id, value);
        if (a != (b = this.ordered.put(man, value))) {
            throw new AssertionError();
        }
    }

    public int size() {
        return this.unordered.size();
    }

    public T get(OrderedManager ord) {
        return this.unordered.get(ord.id);
    }

    public T get(String id) {
        return this.unordered.get(id);
    }

    public T remove(OrderedManager ord) {
        Object b;
        T a = this.unordered.remove(ord.id);
        if (a != (b = this.ordered.remove(ord))) {
            throw new AssertionError();
        }
        return (T)b;
    }

    public boolean containsKey(String id) {
        return this.unordered.containsKey(id);
    }

    public boolean containsKey(OrderedManager ord) {
        return this.unordered.containsKey(ord.id);
    }

    public Set<OrderedManager> keySet() {
        return this.ordered.keySet();
    }

    public Set<Map.Entry<OrderedManager, T>> entrySet() {
        return this.ordered.entrySet();
    }

    public Iterable<T> values() {
        return this.ordered.values();
    }
}

