/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.chunk.internal;

import com.falsepattern.chunk.api.DataManager;
import com.falsepattern.chunk.api.OrderedManager;
import com.falsepattern.chunk.internal.Common;
import com.falsepattern.chunk.internal.DualMap;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderState;
import cpw.mods.fml.common.StartupQuery;
import cpw.mods.fml.common.ZipperUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import lombok.Generated;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.S23PacketBlockChange;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import org.jetbrains.annotations.Nullable;

public class DataRegistryImpl {
    private static final Map<String, OrderedManager> managersUnordered = new HashMap<String, OrderedManager>();
    private static final SortedSet<OrderedManager> managers = new TreeSet<OrderedManager>();
    private static final DualMap<PacketManagerInfo> packetManagers = new DualMap();
    private static final DualMap<DataManager.BlockPacketDataManager> blockPacketManagers = new DualMap();
    private static final DualMap<DataManager.StorageDataManager> NBTManagers = new DualMap();
    private static final SortedMap<OrderedManager, DataManager.ChunkDataManager> chunkNBTManagers = new TreeMap<OrderedManager, DataManager.ChunkDataManager>();
    private static final SortedMap<OrderedManager, DataManager.SubChunkDataManager> subChunkNBTManagers = new TreeMap<OrderedManager, DataManager.SubChunkDataManager>();
    private static final Set<String> disabledManagers = new HashSet<String>();
    private static int maxPacketSize = 4;

    public static void registerDataManager(DataManager manager, int ordering) throws IllegalStateException, IllegalArgumentException {
        if (Loader.instance().getLoaderState() != LoaderState.INITIALIZATION) {
            throw new IllegalStateException("ChunkDataManager registration is not allowed at this time! Please register your ChunkDataManager in the init phase.");
        }
        String id = manager.domain() + ":" + manager.id();
        if (managersUnordered.containsKey(id)) {
            throw new IllegalArgumentException("ChunkDataManager " + manager + " has a duplicate id!");
        }
        if (disabledManagers.contains(id)) {
            return;
        }
        OrderedManager ord = new OrderedManager(ordering, id);
        managersUnordered.put(id, ord);
        managers.add(ord);
        if (manager instanceof DataManager.PacketDataManager) {
            DataManager.PacketDataManager packetManager = (DataManager.PacketDataManager)manager;
            int maxSize = packetManager.maxPacketSize();
            maxPacketSize += 4 + id.getBytes(StandardCharsets.UTF_8).length + 4 + maxSize;
            PacketManagerInfo man = new PacketManagerInfo(maxSize, packetManager);
            packetManagers.put(ord, man);
        }
        if (manager instanceof DataManager.BlockPacketDataManager) {
            DataManager.BlockPacketDataManager blockPacketManager = (DataManager.BlockPacketDataManager)manager;
            blockPacketManagers.put(ord, blockPacketManager);
        }
        if (manager instanceof DataManager.StorageDataManager) {
            NBTManagers.put(ord, (DataManager.StorageDataManager)manager);
            if (manager instanceof DataManager.ChunkDataManager) {
                chunkNBTManagers.put(ord, (DataManager.ChunkDataManager)manager);
            }
            if (manager instanceof DataManager.SubChunkDataManager) {
                subChunkNBTManagers.put(ord, (DataManager.SubChunkDataManager)manager);
            }
        }
    }

    public static void disableDataManager(String domain, String id) {
        if (Loader.instance().getLoaderState() != LoaderState.POSTINITIALIZATION) {
            throw new IllegalStateException("ChunkDataManager disabling is not allowed at this time! Please disable any ChunkDataManagers in the postInit phase.");
        }
        Common.LOG.debug("Disabling ChunkDataManager " + id + " in domain " + domain + ". See the stacktrace for the source of this event.\nThis is NOT an error.", new Throwable());
        String manager = domain + ":" + id;
        OrderedManager ord = managersUnordered.remove(manager);
        if (ord != null) {
            managers.remove(ord);
            if (packetManagers.containsKey(ord)) {
                PacketManagerInfo removed = packetManagers.remove(ord);
                maxPacketSize -= 4 + id.getBytes(StandardCharsets.UTF_8).length + 4 + removed.maxPacketSize;
            }
            blockPacketManagers.remove(ord);
            chunkNBTManagers.remove(ord);
            subChunkNBTManagers.remove(ord);
            NBTManagers.remove(ord);
        }
        disabledManagers.add(manager);
    }

    public static int maxPacketSize() {
        return maxPacketSize;
    }

    private static void writeString(ByteBuffer buffer, String string) {
        byte[] bytes = string.getBytes();
        buffer.putInt(bytes.length);
        buffer.put(bytes);
    }

    private static String readString(ByteBuffer buffer) {
        int length = buffer.getInt();
        byte[] bytes = new byte[length];
        buffer.get(bytes);
        return new String(bytes);
    }

    public static void readFromBuffer(Chunk chunk, int subChunkMask, boolean forceUpdate, byte[] data) {
        ByteBuffer buf = ByteBuffer.wrap(data);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        int count = buf.getInt();
        for (int i = 0; i < count; ++i) {
            String id = DataRegistryImpl.readString(buf);
            int length = buf.getInt();
            PacketManagerInfo managerInfo = packetManagers.get(id);
            if (managerInfo == null) {
                Common.LOG.error("Received data for unknown PacketDataManager " + id + ". Skipping.");
                buf.position(buf.position() + length);
                continue;
            }
            if (length > managerInfo.maxPacketSize) {
                Common.LOG.error("Received packet larger than max size for PacketDataManager " + id + "! Continuing anyways, things might break!");
            }
            int start = buf.position();
            ByteBuffer slice = DataRegistryImpl.createSlice(buf, start, length);
            managerInfo.manager.readFromBuffer(chunk, subChunkMask, forceUpdate, slice);
            buf.position(start + length);
        }
    }

    public static int writeToBuffer(Chunk chunk, int subChunkMask, boolean forceUpdate, byte[] data) {
        ByteBuffer buf = ByteBuffer.wrap(data);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.putInt(packetManagers.size());
        for (Map.Entry<OrderedManager, PacketManagerInfo> pair : packetManagers.entrySet()) {
            OrderedManager ord = pair.getKey();
            PacketManagerInfo managerInfo = pair.getValue();
            DataRegistryImpl.writeString(buf, ord.id);
            int start = buf.position() + 4;
            ByteBuffer slice = DataRegistryImpl.createSlice(buf, start, managerInfo.maxPacketSize);
            managerInfo.manager.writeToBuffer(chunk, subChunkMask, forceUpdate, slice);
            int length = slice.position();
            buf.putInt(length);
            buf.position(start + length);
        }
        return buf.position();
    }

    public static void writeBlockToPacket(Chunk chunk, int x, int y, int z, S23PacketBlockChange packet) {
        for (DataManager.BlockPacketDataManager manager : blockPacketManagers.values()) {
            manager.writeBlockToPacket(chunk, x, y, z, packet);
        }
    }

    public static void readBlockFromPacket(Chunk chunk, int x, int y, int z, S23PacketBlockChange packet) {
        for (DataManager.BlockPacketDataManager manager : blockPacketManagers.values()) {
            manager.readBlockFromPacket(chunk, x, y, z, packet);
        }
    }

    public static void writeBlockPacketToBuffer(S23PacketBlockChange packet, PacketBuffer buffer) throws IOException {
        buffer.writeInt(blockPacketManagers.size());
        for (Map.Entry<OrderedManager, DataManager.BlockPacketDataManager> pair : blockPacketManagers.entrySet()) {
            OrderedManager ord = pair.getKey();
            DataManager.BlockPacketDataManager manager = pair.getValue();
            buffer.func_150785_a(ord.id);
            manager.writeBlockPacketToBuffer(packet, buffer);
        }
    }

    public static void readBlockPacketFromBuffer(S23PacketBlockChange packet, PacketBuffer buffer) throws IOException {
        int count = buffer.readInt();
        for (int i = 0; i < count; ++i) {
            String id = buffer.func_150789_c(1024);
            DataManager.BlockPacketDataManager manager = blockPacketManagers.get(id);
            manager.readBlockPacketFromBuffer(packet, buffer);
        }
    }

    private static ByteBuffer createSlice(ByteBuffer buffer, int start, int length) {
        int oldLimit = buffer.limit();
        int oldPosition = buffer.position();
        buffer.position(start);
        buffer.limit(start + length);
        ByteBuffer slice = buffer.slice();
        buffer.limit(oldLimit);
        buffer.position(oldPosition);
        return slice;
    }

    private static NBTTagCompound createManagerNBT(boolean privileged, NBTTagCompound root, DataManager manager) {
        NBTTagCompound domainNBT;
        if (privileged) {
            return root;
        }
        String domain = manager.domain();
        String id = manager.id();
        if (root.func_74764_b(domain)) {
            domainNBT = root.func_74775_l(domain);
        } else {
            domainNBT = new NBTTagCompound();
            root.func_74782_a(domain, (NBTBase)domainNBT);
        }
        if (domainNBT.func_74764_b(id)) {
            return domainNBT.func_74775_l(id);
        }
        NBTTagCompound subNBT = new NBTTagCompound();
        domainNBT.func_74782_a(id, (NBTBase)subNBT);
        return subNBT;
    }

    private static NBTTagCompound getManagerNBT(boolean privileged, NBTTagCompound root, DataManager manager) {
        if (privileged) {
            return root;
        }
        String domain = manager.domain();
        if (!root.func_74764_b(domain)) {
            return new NBTTagCompound();
        }
        NBTTagCompound domainNBT = root.func_74775_l(domain);
        if (!domainNBT.func_74764_b(manager.id())) {
            return new NBTTagCompound();
        }
        return domainNBT.func_74775_l(manager.id());
    }

    public static void writeSubChunkToNBT(Chunk chunk, ExtendedBlockStorage subChunk, NBTTagCompound nbt) {
        for (DataManager.SubChunkDataManager manager : subChunkNBTManagers.values()) {
            manager.writeSubChunkToNBT(chunk, subChunk, DataRegistryImpl.createManagerNBT(manager.subChunkPrivilegedAccess(), nbt, manager));
        }
    }

    public static void readSubChunkFromNBT(Chunk chunk, ExtendedBlockStorage subChunk, NBTTagCompound nbt) {
        for (DataManager.SubChunkDataManager manager : subChunkNBTManagers.values()) {
            manager.readSubChunkFromNBT(chunk, subChunk, DataRegistryImpl.getManagerNBT(manager.subChunkPrivilegedAccess(), nbt, manager));
        }
    }

    public static void writeChunkToNBT(Chunk chunk, NBTTagCompound chunkNBT) {
        for (DataManager.ChunkDataManager manager : chunkNBTManagers.values()) {
            manager.writeChunkToNBT(chunk, DataRegistryImpl.createManagerNBT(manager.chunkPrivilegedAccess(), chunkNBT, manager));
        }
    }

    public static void readChunkFromNBT(Chunk chunk, NBTTagCompound chunkNBT) {
        for (DataManager.ChunkDataManager manager : chunkNBTManagers.values()) {
            manager.readChunkFromNBT(chunk, DataRegistryImpl.getManagerNBT(manager.chunkPrivilegedAccess(), chunkNBT, manager));
        }
    }

    public static void cloneChunk(Chunk from, Chunk to) {
        for (DataManager.ChunkDataManager manager : chunkNBTManagers.values()) {
            manager.cloneChunk(from, to);
        }
    }

    public static void cloneSubChunk(Chunk fromChunk, ExtendedBlockStorage from, ExtendedBlockStorage to) {
        for (DataManager.SubChunkDataManager manager : subChunkNBTManagers.values()) {
            manager.cloneSubChunk(fromChunk, from, to);
        }
    }

    public static Set<String> getRegisteredManagers() {
        return Collections.unmodifiableSet(managersUnordered.keySet());
    }

    public static SortedSet<OrderedManager> getRegisteredManagersOrdered() {
        return Collections.unmodifiableSortedSet(managers);
    }

    public static void readLevelDat(NBTTagCompound tag) {
        String managerCompat;
        boolean triggerScreen = false;
        boolean newlyInstalled = false;
        StringBuilder builder = new StringBuilder();
        if (!tag.func_74764_b("version")) {
            newlyInstalled = true;
            builder.append("The world you are trying to load is a vanilla world, or a world that was created with a very old version of ChunkAPI.\n");
        }
        if ((managerCompat = DataRegistryImpl.verifyManagerCompatibility(tag)) != null) {
            if (!newlyInstalled) {
                builder.append("The world you are trying to load was created with a different version of ChunkAPI data managers.\nData managers are used by other mods to save extra data in chunks, and changes to these data managers can cause worlds to become corrupted.\n");
            }
            triggerScreen = true;
        }
        if (triggerScreen) {
            builder.append("ChunkAPI will attempt to load the world, but it is possible that chunks might get corrupted.\nRead the following text carefully, and make sure you understand the risks before continuing.\n\n");
        }
        if (managerCompat != null) {
            builder.append(managerCompat);
        }
        if (triggerScreen) {
            builder.append("\nA world backup will be automatically created in your saves directory.\n\n");
            boolean confirmed = StartupQuery.confirm((String)builder.toString());
            if (!confirmed) {
                StartupQuery.abort();
            }
            try {
                ZipperUtil.backupWorld();
            }
            catch (IOException e) {
                StartupQuery.notify((String)("The world backup couldn't be created.\n\n" + e));
                StartupQuery.abort();
            }
        }
    }

    private static String verifyManagerCompatibility(NBTTagCompound tag) {
        Set addedManagers;
        boolean compatWarning = false;
        StringBuilder builder = new StringBuilder();
        Map<String, SaveManagerInfo> saveManagers = DataRegistryImpl.readManagers(tag);
        HashSet<String> removedManagers = new HashSet<String>(saveManagers.keySet());
        for (OrderedManager orderedManager : NBTManagers.keySet()) {
            removedManagers.remove(orderedManager.id);
        }
        if (!removedManagers.isEmpty()) {
            compatWarning = true;
            builder.append("\nThe following data managers are no longer present:\n");
            for (String string : removedManagers) {
                SaveManagerInfo saveManager = saveManagers.get(string);
                builder.append(string);
                if (saveManager.version != null) {
                    builder.append(' ').append(saveManager.version);
                }
                builder.append("\nUninstall information: ");
                if (saveManager.uninstallMessage != null) {
                    builder.append(saveManager.getUninstallMessage());
                } else {
                    builder.append("No uninstall information available.");
                }
                builder.append('\n');
            }
        }
        if (!(addedManagers = NBTManagers.keySet().stream().filter(manager -> !manager.id.startsWith("minecraft:")).filter(manager -> !saveManagers.containsKey(manager.id)).collect(Collectors.toSet())).isEmpty()) {
            compatWarning = true;
            builder.append("\nThe following data managers have been newly added:\n");
            for (OrderedManager manager3 : addedManagers) {
                DataManager.StorageDataManager addedManager = NBTManagers.get(manager3);
                if (addedManager == null) continue;
                builder.append(manager3).append(' ').append(addedManager.version()).append('\n');
                String installMessage = addedManager.newInstallDescription();
                if (installMessage == null) continue;
                builder.append("Install information: ").append(addedManager.newInstallDescription()).append('\n');
            }
        }
        boolean bl = false;
        for (Map.Entry<String, SaveManagerInfo> savedManager : saveManagers.entrySet()) {
            boolean bl2;
            String managerName = savedManager.getKey();
            if (!NBTManagers.containsKey(managerName)) continue;
            SaveManagerInfo manager4 = savedManager.getValue();
            DataManager.StorageDataManager currentManager = NBTManagers.get(managerName);
            String extraMessage = currentManager.versionChangeMessage(manager4.version);
            if (extraMessage == null) continue;
            compatWarning = true;
            if (!bl2) {
                builder.append("\nThe following data managers have changed versions in an incompatible way:\n");
                bl2 = true;
            }
            builder.append(managerName).append(" has changed versions from ").append(manager4.version).append(" to ").append(currentManager.version()).append(".\n");
            builder.append("Upgrade information: ").append(extraMessage).append('\n');
        }
        if (!compatWarning) {
            return null;
        }
        return "The following managers have changed:\n" + builder;
    }

    public static void writeLevelDat(NBTTagCompound tag) {
        NBTTagCompound managers = new NBTTagCompound();
        tag.func_74782_a("managers", (NBTBase)managers);
        tag.func_74778_a("version", "0.7.0");
        for (Map.Entry<OrderedManager, DataManager.StorageDataManager> manager : NBTManagers.entrySet()) {
            OrderedManager ord = manager.getKey();
            if (ord.id.startsWith("minecraft:")) continue;
            DataManager.StorageDataManager value = manager.getValue();
            managers.func_74782_a(ord.id, (NBTBase)SaveManagerInfo.fromManager(value).toNBT());
        }
    }

    private static Map<String, SaveManagerInfo> readManagers(NBTTagCompound tag) {
        HashMap<String, SaveManagerInfo> managers = new HashMap<String, SaveManagerInfo>();
        if (!tag.func_74764_b("managers")) {
            return managers;
        }
        if (tag.func_150299_b("managers") != 10) {
            return managers;
        }
        NBTTagCompound managerTag = tag.func_74775_l("managers");
        for (String key : managerTag.func_150296_c()) {
            managers.put(key, SaveManagerInfo.fromNBT(managerTag.func_74775_l(key)));
        }
        return managers;
    }

    private static class SaveManagerInfo {
        @Nullable
        public final String version;
        @Nullable
        public final String uninstallMessage;

        public NBTTagCompound toNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            if (this.version != null) {
                tag.func_74778_a("version", this.version);
            }
            if (this.uninstallMessage != null) {
                tag.func_74778_a("uninstallMessage", this.uninstallMessage);
            }
            return tag;
        }

        public static SaveManagerInfo fromNBT(NBTTagCompound tag) {
            return new SaveManagerInfo(SaveManagerInfo.getNBTStringNullable(tag, "version"), SaveManagerInfo.getNBTStringNullable(tag, "uninstallMessage"));
        }

        private static String getNBTStringNullable(NBTTagCompound tag, String key) {
            if (tag.func_74764_b(key) && tag.func_150299_b(key) == 8) {
                return tag.func_74779_i(key);
            }
            return null;
        }

        public static SaveManagerInfo fromManager(DataManager.StorageDataManager manager) {
            return new SaveManagerInfo(manager.version(), manager.uninstallMessage());
        }

        @Generated
        public SaveManagerInfo(@Nullable String version, @Nullable String uninstallMessage) {
            this.version = version;
            this.uninstallMessage = uninstallMessage;
        }

        @Nullable
        @Generated
        public String getVersion() {
            return this.version;
        }

        @Nullable
        @Generated
        public String getUninstallMessage() {
            return this.uninstallMessage;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SaveManagerInfo)) {
                return false;
            }
            SaveManagerInfo other = (SaveManagerInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            String this$uninstallMessage = this.getUninstallMessage();
            String other$uninstallMessage = other.getUninstallMessage();
            return !(this$uninstallMessage == null ? other$uninstallMessage != null : !this$uninstallMessage.equals(other$uninstallMessage));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SaveManagerInfo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            String $uninstallMessage = this.getUninstallMessage();
            result = result * 59 + ($uninstallMessage == null ? 43 : $uninstallMessage.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DataRegistryImpl.SaveManagerInfo(version=" + this.getVersion() + ", uninstallMessage=" + this.getUninstallMessage() + ")";
        }
    }

    private static class PacketManagerInfo {
        public final int maxPacketSize;
        public final DataManager.PacketDataManager manager;

        @Generated
        public PacketManagerInfo(int maxPacketSize, DataManager.PacketDataManager manager) {
            this.maxPacketSize = maxPacketSize;
            this.manager = manager;
        }

        @Generated
        public int getMaxPacketSize() {
            return this.maxPacketSize;
        }

        @Generated
        public DataManager.PacketDataManager getManager() {
            return this.manager;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PacketManagerInfo)) {
                return false;
            }
            PacketManagerInfo other = (PacketManagerInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getMaxPacketSize() != other.getMaxPacketSize()) {
                return false;
            }
            DataManager.PacketDataManager this$manager = this.getManager();
            DataManager.PacketDataManager other$manager = other.getManager();
            return !(this$manager == null ? other$manager != null : !this$manager.equals(other$manager));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PacketManagerInfo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getMaxPacketSize();
            DataManager.PacketDataManager $manager = this.getManager();
            result = result * 59 + ($manager == null ? 43 : $manager.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DataRegistryImpl.PacketManagerInfo(maxPacketSize=" + this.getMaxPacketSize() + ", manager=" + this.getManager() + ")";
        }
    }
}

