/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.chunk.api;

import java.io.IOException;
import java.nio.ByteBuffer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.S23PacketBlockChange;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DataManager {
    @Contract(pure=true)
    public String domain();

    @Contract(pure=true)
    public String id();

    public static interface SubChunkDataManager
    extends StorageDataManager {
        @Contract(pure=true)
        default public boolean subChunkPrivilegedAccess() {
            return false;
        }

        @Contract(mutates="param3")
        public void writeSubChunkToNBT(Chunk var1, ExtendedBlockStorage var2, NBTTagCompound var3);

        @Contract(mutates="param2")
        public void readSubChunkFromNBT(Chunk var1, ExtendedBlockStorage var2, NBTTagCompound var3);

        @Contract(mutates="param3")
        public void cloneSubChunk(Chunk var1, ExtendedBlockStorage var2, ExtendedBlockStorage var3);
    }

    public static interface ChunkDataManager
    extends StorageDataManager {
        @Contract(pure=true)
        default public boolean chunkPrivilegedAccess() {
            return false;
        }

        @Contract(mutates="param2")
        public void writeChunkToNBT(Chunk var1, NBTTagCompound var2);

        @Contract(mutates="param1")
        public void readChunkFromNBT(Chunk var1, NBTTagCompound var2);

        @Contract(mutates="param2")
        public void cloneChunk(Chunk var1, Chunk var2);
    }

    public static interface StorageDataManager
    extends DataManager {
        @Contract(pure=true)
        @NotNull
        public String version();

        @Contract(pure=true)
        @Nullable
        public String newInstallDescription();

        @Contract(pure=true)
        @NotNull
        public String uninstallMessage();

        @Contract(pure=true)
        @Nullable
        public String versionChangeMessage(String var1);
    }

    public static interface BlockPacketDataManager
    extends DataManager {
        @Contract(mutates="param1")
        public void writeBlockToPacket(Chunk var1, int var2, int var3, int var4, S23PacketBlockChange var5);

        @Contract(mutates="param1,param5")
        public void readBlockFromPacket(Chunk var1, int var2, int var3, int var4, S23PacketBlockChange var5);

        @Contract(mutates="param2")
        public void writeBlockPacketToBuffer(S23PacketBlockChange var1, PacketBuffer var2) throws IOException;

        @Contract(mutates="param1,param2")
        public void readBlockPacketFromBuffer(S23PacketBlockChange var1, PacketBuffer var2) throws IOException;
    }

    public static interface PacketDataManager
    extends DataManager {
        @Contract(pure=true)
        public int maxPacketSize();

        @Contract(mutates="param4")
        public void writeToBuffer(Chunk var1, int var2, boolean var3, ByteBuffer var4);

        @Contract(mutates="param1,param4")
        public void readFromBuffer(Chunk var1, int var2, boolean var3, ByteBuffer var4);
    }
}

