/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.chunk.api;

import java.util.Arrays;
import net.minecraft.world.chunk.NibbleArray;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;

@ApiStatus.NonExtendable
public class ArrayUtil {
    @Contract(value="null, _ -> null;!null, null -> new;", mutates="param2")
    public static boolean[] copyArray(boolean[] src, boolean[] dst) {
        if (src == null) {
            return null;
        }
        if (dst == null || src.length != dst.length) {
            return Arrays.copyOf(src, src.length);
        }
        System.arraycopy(src, 0, dst, 0, src.length);
        return dst;
    }

    @Contract(value="null, _ -> null;!null, null -> new;", mutates="param2")
    public static byte[] copyArray(byte[] src, byte[] dst) {
        if (src == null) {
            return null;
        }
        if (dst == null || src.length != dst.length) {
            return Arrays.copyOf(src, src.length);
        }
        System.arraycopy(src, 0, dst, 0, src.length);
        return dst;
    }

    @Contract(value="null, _ -> null;!null, null -> new;", mutates="param2")
    public static char[] copyArray(char[] src, char[] dst) {
        if (src == null) {
            return null;
        }
        if (dst == null || src.length != dst.length) {
            return Arrays.copyOf(src, src.length);
        }
        System.arraycopy(src, 0, dst, 0, src.length);
        return dst;
    }

    @Contract(value="null, _ -> null;!null, null -> new;", mutates="param2")
    public static short[] copyArray(short[] src, short[] dst) {
        if (src == null) {
            return null;
        }
        if (dst == null || src.length != dst.length) {
            return Arrays.copyOf(src, src.length);
        }
        System.arraycopy(src, 0, dst, 0, src.length);
        return dst;
    }

    @Contract(value="null, _ -> null;!null, null -> new;", mutates="param2")
    public static int[] copyArray(int[] src, int[] dst) {
        if (src == null) {
            return null;
        }
        if (dst == null || src.length != dst.length) {
            return Arrays.copyOf(src, src.length);
        }
        System.arraycopy(src, 0, dst, 0, src.length);
        return dst;
    }

    @Contract(value="null, _ -> null;!null, null -> new;", mutates="param2")
    public static long[] copyArray(long[] src, long[] dst) {
        if (src == null) {
            return null;
        }
        if (dst == null || src.length != dst.length) {
            return Arrays.copyOf(src, src.length);
        }
        System.arraycopy(src, 0, dst, 0, src.length);
        return dst;
    }

    @Contract(value="null, _ -> null;!null, null -> new;", mutates="param2")
    public static float[] copyArray(float[] src, float[] dst) {
        if (src == null) {
            return null;
        }
        if (dst == null || src.length != dst.length) {
            return Arrays.copyOf(src, src.length);
        }
        System.arraycopy(src, 0, dst, 0, src.length);
        return dst;
    }

    @Contract(value="null, _ -> null;!null, null -> new;", mutates="param2")
    public static double[] copyArray(double[] src, double[] dst) {
        if (src == null) {
            return null;
        }
        if (dst == null || src.length != dst.length) {
            return Arrays.copyOf(src, src.length);
        }
        System.arraycopy(src, 0, dst, 0, src.length);
        return dst;
    }

    @Contract(value="null, _ -> null;!null, null -> new;", mutates="param2")
    public static <T> T[] copyArray(T[] src, T[] dst) {
        if (src == null) {
            return null;
        }
        if (dst == null || src.length != dst.length) {
            return Arrays.copyOf(src, src.length);
        }
        System.arraycopy(src, 0, dst, 0, src.length);
        return dst;
    }

    @Contract(value="null, _ -> null;!null, null -> new;", mutates="param2")
    public static NibbleArray copyArray(NibbleArray srcArray, NibbleArray dstArray) {
        if (srcArray == null) {
            return null;
        }
        if (dstArray == null) {
            return new NibbleArray(Arrays.copyOf(srcArray.field_76585_a, srcArray.field_76585_a.length), srcArray.field_76583_b);
        }
        dstArray.field_76583_b = srcArray.field_76583_b;
        dstArray.field_76584_c = srcArray.field_76584_c;
        dstArray.field_76585_a = ArrayUtil.copyArray(srcArray.field_76585_a, dstArray.field_76585_a);
        return dstArray;
    }
}

