/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.aquaacrobatics.util.math;

import com.fuzs.aquaacrobatics.util.BlockPos;
import com.fuzs.aquaacrobatics.util.math.CubeCoordinateIterator;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Spliterators;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class AxisAlignedBBSpliterator
extends Spliterators.AbstractSpliterator<AxisAlignedBB> {
    @Nullable
    private final Entity entity;
    private final AxisAlignedBB aabb;
    private final CubeCoordinateIterator cubeCoordinateIterator;
    private final World reader;
    private boolean isEntityPresent;
    private final BiPredicate<Block, BlockPos> statePositionPredicate;
    public static final AxisAlignedBB FULL_BLOCK_AABB = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);

    public AxisAlignedBBSpliterator(World reader, @Nullable Entity entity, AxisAlignedBB aabb) {
        this(reader, entity, aabb, (state, pos) -> true);
    }

    public AxisAlignedBBSpliterator(World reader, @Nullable Entity entity, AxisAlignedBB aabb, BiPredicate<Block, BlockPos> statePositionPredicate) {
        super(Long.MAX_VALUE, 1280);
        this.reader = reader;
        this.isEntityPresent = entity != null;
        this.entity = entity;
        this.aabb = aabb;
        this.statePositionPredicate = statePositionPredicate;
        int startX = MathHelper.func_76128_c((double)(aabb.field_72340_a - 1.0E-7)) - 1;
        int endX = MathHelper.func_76128_c((double)(aabb.field_72336_d + 1.0E-7)) + 1;
        int startY = MathHelper.func_76128_c((double)(aabb.field_72338_b - 1.0E-7)) - 1;
        int heightY = MathHelper.func_76128_c((double)(aabb.field_72337_e + 1.0E-7)) + 1;
        int startZ = MathHelper.func_76128_c((double)(aabb.field_72339_c - 1.0E-7)) - 1;
        int endZ = MathHelper.func_76128_c((double)(aabb.field_72334_f + 1.0E-7)) + 1;
        this.cubeCoordinateIterator = new CubeCoordinateIterator(startX, startY, startZ, endX, heightY, endZ);
    }

    @Override
    public boolean tryAdvance(Consumer<? super AxisAlignedBB> consumer) {
        return this.isEntityPresent && this.isEntityOutsideOfBorder(consumer) || this.isAABBColliding(consumer);
    }

    private boolean isAABBColliding(Consumer<? super AxisAlignedBB> consumer) {
        BlockPos.PooledMutableBlockPos mutablePos = BlockPos.PooledMutableBlockPos.retain();
        while (this.cubeCoordinateIterator.hasNext()) {
            Block blockstate;
            int x = this.cubeCoordinateIterator.getX();
            int y = this.cubeCoordinateIterator.getY();
            int z = this.cubeCoordinateIterator.getZ();
            int boundariesTouched = this.cubeCoordinateIterator.numBoundariesTouched();
            if (boundariesTouched == 3) continue;
            mutablePos.setPos(x, y, z);
            if (!this.reader.func_72899_e(mutablePos.getX(), mutablePos.getY(), mutablePos.getZ()) || !this.statePositionPredicate.test(blockstate = this.reader.func_147439_a(mutablePos.getX(), mutablePos.getY(), mutablePos.getZ()), mutablePos) || boundariesTouched == 2 && blockstate != Blocks.field_150326_M) continue;
            AxisAlignedBB collisionBoundingBox = blockstate.func_149668_a(this.reader, mutablePos.getX(), mutablePos.getY(), mutablePos.getZ());
            if (collisionBoundingBox == FULL_BLOCK_AABB && blockstate.func_149686_d()) {
                AxisAlignedBB aabbOffset = collisionBoundingBox.func_72317_d((double)x, (double)y, (double)z);
                if (!this.aabb.func_72326_a(aabbOffset) || this.entity != null && !this.entity.field_70121_D.func_72326_a(aabbOffset)) continue;
                consumer.accept((AxisAlignedBB)collisionBoundingBox);
                mutablePos.release();
                return true;
            }
            ArrayList collidingBoxes = Lists.newArrayList();
            this.getCollisionBoxList(collidingBoxes, blockstate, mutablePos);
            if (collidingBoxes.isEmpty()) continue;
            consumer.accept((AxisAlignedBB)collisionBoundingBox);
            mutablePos.release();
            return true;
        }
        mutablePos.release();
        return false;
    }

    private void getCollisionBoxList(List<AxisAlignedBB> collidingBoxes, Block blockstate, BlockPos.PooledMutableBlockPos mutablePos) {
        blockstate.func_149743_a(this.reader, mutablePos.getX(), mutablePos.getY(), mutablePos.getZ(), this.aabb, collidingBoxes, this.entity);
        if (this.entity != null) {
            ArrayList entityCollidingBoxes = Lists.newArrayList();
            blockstate.func_149743_a(this.reader, mutablePos.getX(), mutablePos.getY(), mutablePos.getZ(), this.entity.field_70121_D, (List)entityCollidingBoxes, this.entity);
            collidingBoxes.retainAll(entityCollidingBoxes);
        }
    }

    private boolean isEntityOutsideOfBorder(Consumer<? super AxisAlignedBB> consumer) {
        Objects.requireNonNull(this.entity);
        this.isEntityPresent = false;
        return false;
    }
}

