/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.aquaacrobatics.util;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Lists;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BlockPos {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final BlockPos ORIGIN = new BlockPos(0, 0, 0);
    private static final int NUM_X_BITS = 26;
    private static final int NUM_Z_BITS = 26;
    private static final int NUM_Y_BITS = 12;
    private static final int Y_SHIFT = 26;
    private static final int X_SHIFT = 38;
    private static final long X_MASK = 0x3FFFFFFL;
    private static final long Y_MASK = 4095L;
    private static final long Z_MASK = 0x3FFFFFFL;
    protected int x;
    protected int y;
    protected int z;

    public BlockPos(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public BlockPos(BlockPos pos) {
        this.x = pos.x;
        this.y = pos.y;
        this.z = pos.z;
    }

    public BlockPos(double x, double y, double z) {
        this(MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)z));
    }

    public BlockPos(Vec3 vec) {
        this(MathHelper.func_76128_c((double)vec.field_72450_a), MathHelper.func_76128_c((double)vec.field_72448_b), MathHelper.func_76128_c((double)vec.field_72449_c));
    }

    public BlockPos(Entity entity) {
        this(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public int chunkX() {
        return this.x >> 4;
    }

    public int chunkZ() {
        return this.z >> 4;
    }

    public Block getBlock(World world) {
        return world.func_147439_a(this.getX(), this.getY(), this.getZ());
    }

    public int getMetadata(World world) {
        return world.func_72805_g(this.getX(), this.getY(), this.getZ());
    }

    public BlockPos add(int x, int y, int z) {
        return new BlockPos(this.getX() + x, this.getY() + y, this.getZ() + z);
    }

    public BlockPos add(double x, double y, double z) {
        return x == 0.0 && y == 0.0 && z == 0.0 ? this : new BlockPos((double)this.getX() + x, (double)this.getY() + y, (double)this.getZ() + z);
    }

    public BlockPos add(BlockPos pos) {
        if (pos == null) {
            return new BlockPos(this.getX(), this.getY(), this.getZ());
        }
        return this.add(pos.getX(), pos.getY(), pos.getZ());
    }

    public BlockPos substract(BlockPos pos) {
        return this.add(-pos.getX(), -pos.getY(), -pos.getZ());
    }

    public BlockPos getPosition() {
        return new BlockPos((double)this.getX(), (double)this.getY() + 0.5, (double)this.getZ());
    }

    public Vec3 getPositionVec() {
        return new BlockPos((double)this.getX(), (double)this.getY() + 0.5, (double)this.getZ()).getPositionVec();
    }

    public Vec3 getPositionVector() {
        return Vec3.func_72443_a((double)this.getX(), (double)this.getY(), (double)this.getZ());
    }

    public BlockPos up() {
        return this.up(1);
    }

    public BlockPos up(int n) {
        return this.offset(ForgeDirection.UP, n);
    }

    public BlockPos down() {
        return this.down(1);
    }

    public BlockPos down(int n) {
        return this.offset(ForgeDirection.DOWN, n);
    }

    public BlockPos north() {
        return this.north(1);
    }

    public BlockPos north(int n) {
        return this.offset(ForgeDirection.NORTH, n);
    }

    public BlockPos south() {
        return this.south(1);
    }

    public BlockPos south(int n) {
        return this.offset(ForgeDirection.SOUTH, n);
    }

    public BlockPos west() {
        return this.west(1);
    }

    public BlockPos west(int n) {
        return this.offset(ForgeDirection.WEST, n);
    }

    public BlockPos east() {
        return this.east(1);
    }

    public BlockPos east(int n) {
        return this.offset(ForgeDirection.EAST, n);
    }

    public BlockPos offset(ForgeDirection facing) {
        return this.offset(facing, 1);
    }

    public BlockPos offset(ForgeDirection facing, int n) {
        return new BlockPos(this.getX() + facing.offsetX * n, this.getY() + facing.offsetY * n, this.getZ() + facing.offsetZ * n);
    }

    public BlockPos rotate(int rotation) {
        int[] cos = new int[]{1, 0, -1, 0};
        int[] sin = new int[]{0, 1, 0, -1};
        int a = rotation % 4;
        if (a < 0) {
            a += 4;
        }
        int newX = this.x * cos[a] - this.z * sin[a];
        int newZ = this.x * sin[a] + this.z * cos[a];
        return new BlockPos(newX, this.y, newZ);
    }

    public boolean isInRange(BlockPos pos, int range) {
        double x = pos.x - this.x;
        double y = pos.y - this.y;
        double z = pos.z - this.z;
        return x * x + y * y + z * z <= (double)(range * range);
    }

    public boolean isInside(AxisAlignedBB aabb) {
        return aabb.func_72326_a(AxisAlignedBB.func_72330_a((double)this.x, (double)this.y, (double)this.z, (double)(this.x + 1), (double)(this.y + 1), (double)(this.z + 1)));
    }

    public ChunkPosition toChunkPosition() {
        return new ChunkPosition(this.chunkX(), this.y, this.chunkZ());
    }

    public double getDistance(int xIn, int yIn, int zIn) {
        double d0 = this.getX() - xIn;
        double d1 = this.getY() - yIn;
        double d2 = this.getZ() - zIn;
        return Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
    }

    public double distanceSq(double toX, double toY, double toZ) {
        double d0 = (double)this.getX() - toX;
        double d1 = (double)this.getY() - toY;
        double d2 = (double)this.getZ() - toZ;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public double distanceSqToCenter(double xIn, double yIn, double zIn) {
        double d0 = (double)this.getX() + 0.5 - xIn;
        double d1 = (double)this.getY() + 0.5 - yIn;
        double d2 = (double)this.getZ() + 0.5 - zIn;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public double distanceSq(Vec3 to) {
        return this.distanceSq(to.field_72450_a, to.field_72448_b, to.field_72449_c);
    }

    public double distanceSq(BlockPos to) {
        return this.distanceSq(to.getX(), to.getY(), to.getZ());
    }

    public double squareDistanceTo(Vec3 vec) {
        double d0 = vec.field_72450_a - (double)this.x;
        double d1 = vec.field_72448_b - (double)this.y;
        double d2 = vec.field_72449_c - (double)this.z;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public double squareDistanceTo(double xIn, double yIn, double zIn) {
        double d0 = xIn - (double)this.x;
        double d1 = yIn - (double)this.y;
        double d2 = zIn - (double)this.z;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public long toLong() {
        return ((long)this.getX() & 0x3FFFFFFL) << 38 | ((long)this.getY() & 0xFFFL) << 26 | ((long)this.getZ() & 0x3FFFFFFL) << 0;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BlockPos)) {
            return false;
        }
        BlockPos pos = (BlockPos)obj;
        return this.getX() != pos.getX() ? false : (this.getY() != pos.getY() ? false : this.getZ() == pos.getZ());
    }

    public int hashCode() {
        return (this.getY() + this.getZ() * 31) * 31 + this.getX();
    }

    public String toString() {
        return this.x + ", " + this.y + ", " + this.z;
    }

    public static BlockPos fromLong(long serialized) {
        int j = (int)(serialized << 0 >> 38);
        int k = (int)(serialized << 26 >> 52);
        int l = (int)(serialized << 38 >> 38);
        return new BlockPos(j, k, l);
    }

    public static BlockPos minOf(BlockPos p1, BlockPos p2) {
        return new BlockPos(Math.min(p1.getX(), p2.getX()), Math.min(p1.getY(), p2.getY()), Math.min(p1.getZ(), p2.getZ()));
    }

    public static BlockPos maxOf(BlockPos p1, BlockPos p2) {
        return new BlockPos(Math.max(p1.getX(), p2.getX()), Math.max(p1.getY(), p2.getY()), Math.max(p1.getZ(), p2.getZ()));
    }

    public static Iterable<BlockPos> getAllInBox(AxisAlignedBB aabb) {
        BlockPos.AABBFix(aabb);
        return BlockPos.getAllInBox(new BlockPos(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c), new BlockPos(Math.ceil(aabb.field_72336_d) - 1.0, Math.ceil(aabb.field_72337_e) - 1.0, Math.ceil(aabb.field_72334_f) - 1.0));
    }

    public static Iterable<BlockPos> getAllInBox(BlockPos from, BlockPos to) {
        return new BlockIterator(from, to).asIterable();
    }

    public static AxisAlignedBB AABBFix(AxisAlignedBB aabb) {
        double tmp;
        if (aabb.field_72340_a > aabb.field_72336_d) {
            tmp = aabb.field_72340_a;
            aabb.field_72340_a = aabb.field_72336_d;
            aabb.field_72336_d = tmp;
        }
        if (aabb.field_72338_b > aabb.field_72337_e) {
            tmp = aabb.field_72338_b;
            aabb.field_72338_b = aabb.field_72337_e;
            aabb.field_72337_e = tmp;
        }
        if (aabb.field_72339_c > aabb.field_72334_f) {
            tmp = aabb.field_72339_c;
            aabb.field_72339_c = aabb.field_72334_f;
            aabb.field_72334_f = tmp;
        }
        return aabb;
    }

    public BlockPos toImmutable() {
        return this;
    }

    public static Iterable<MutableBlockPos> getAllInBoxMutable(BlockPos from, BlockPos to) {
        return BlockPos.getAllInBoxMutable(Math.min(from.getX(), to.getX()), Math.min(from.getY(), to.getY()), Math.min(from.getZ(), to.getZ()), Math.max(from.getX(), to.getX()), Math.max(from.getY(), to.getY()), Math.max(from.getZ(), to.getZ()));
    }

    public static Iterable<MutableBlockPos> getAllInBoxMutable(final int x1, final int y1, final int z1, final int x2, final int y2, final int z2) {
        return new Iterable<MutableBlockPos>(){

            @Override
            public Iterator<MutableBlockPos> iterator() {
                return new AbstractIterator<MutableBlockPos>(){
                    private MutableBlockPos pos;

                    protected MutableBlockPos computeNext() {
                        if (this.pos == null) {
                            this.pos = new MutableBlockPos(x1, y1, z1);
                            return this.pos;
                        }
                        if (this.pos.x == x2 && this.pos.y == y2 && this.pos.z == z2) {
                            return (MutableBlockPos)this.endOfData();
                        }
                        if (this.pos.x < x2) {
                            ++this.pos.x;
                        } else if (this.pos.y < y2) {
                            this.pos.x = x1;
                            ++this.pos.y;
                        } else if (this.pos.z < z2) {
                            this.pos.x = x1;
                            this.pos.y = y1;
                            ++this.pos.z;
                        }
                        return this.pos;
                    }
                };
            }
        };
    }

    public static class BlockIterator
    implements Iterator<BlockPos> {
        private BlockPos from;
        private BlockPos to;
        private int x;
        private int y;
        private int z;

        public BlockIterator(BlockPos from, BlockPos to) {
            this.from = BlockPos.minOf(from, to);
            this.to = BlockPos.maxOf(from, to);
            this.x = from.getX();
            this.y = from.getY();
            this.z = from.getZ();
        }

        @Override
        public boolean hasNext() {
            return this.x <= this.to.getX() && this.y <= this.to.getY() && this.z <= this.to.getZ();
        }

        @Override
        public BlockPos next() {
            BlockPos retVal = this.hasNext() ? new BlockPos(this.x, this.y, this.z) : null;
            ++this.x;
            if (this.x > this.to.getX()) {
                this.x = this.from.getX();
                ++this.y;
                if (this.y > this.to.getY()) {
                    this.y = this.from.getY();
                    ++this.z;
                }
            }
            return retVal;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public Iterable<BlockPos> asIterable() {
            return new Iterable<BlockPos>(){

                @Override
                public Iterator<BlockPos> iterator() {
                    return this;
                }
            };
        }
    }

    public static final class PooledMutableBlockPos
    extends MutableBlockPos {
        private boolean released;
        private static final List<PooledMutableBlockPos> POOL = Lists.newArrayList();

        private PooledMutableBlockPos(int xIn, int yIn, int zIn) {
            super(xIn, yIn, zIn);
        }

        public static PooledMutableBlockPos retain() {
            return PooledMutableBlockPos.retain(0, 0, 0);
        }

        public static PooledMutableBlockPos retain(double xIn, double yIn, double zIn) {
            return PooledMutableBlockPos.retain(MathHelper.func_76128_c((double)xIn), MathHelper.func_76128_c((double)yIn), MathHelper.func_76128_c((double)zIn));
        }

        @SideOnly(value=Side.CLIENT)
        public static PooledMutableBlockPos retain(Vec3 vec) {
            return PooledMutableBlockPos.retain(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static PooledMutableBlockPos retain(int xIn, int yIn, int zIn) {
            List<PooledMutableBlockPos> list = POOL;
            synchronized (list) {
                PooledMutableBlockPos blockpos$pooledmutableblockpos;
                if (!POOL.isEmpty() && (blockpos$pooledmutableblockpos = POOL.remove(POOL.size() - 1)) != null && blockpos$pooledmutableblockpos.released) {
                    blockpos$pooledmutableblockpos.released = false;
                    blockpos$pooledmutableblockpos.setPos(xIn, yIn, zIn);
                    return blockpos$pooledmutableblockpos;
                }
            }
            return new PooledMutableBlockPos(xIn, yIn, zIn);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            List<PooledMutableBlockPos> list = POOL;
            synchronized (list) {
                if (POOL.size() < 100) {
                    POOL.add(this);
                }
                this.released = true;
            }
        }

        @Override
        public PooledMutableBlockPos setPos(int xIn, int yIn, int zIn) {
            if (this.released) {
                LOGGER.error("PooledMutableBlockPosition modified after it was released.", new Throwable());
                this.released = false;
            }
            return (PooledMutableBlockPos)super.setPos(xIn, yIn, zIn);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public PooledMutableBlockPos setPos(Entity entityIn) {
            return (PooledMutableBlockPos)super.setPos(entityIn);
        }

        @Override
        public PooledMutableBlockPos setPos(double xIn, double yIn, double zIn) {
            return (PooledMutableBlockPos)super.setPos(xIn, yIn, zIn);
        }

        @Override
        public PooledMutableBlockPos setPos(Vec3 vec) {
            return (PooledMutableBlockPos)super.setPos(vec);
        }

        @Override
        public PooledMutableBlockPos move(ForgeDirection facing) {
            return (PooledMutableBlockPos)super.move(facing);
        }

        @Override
        public PooledMutableBlockPos move(ForgeDirection facing, int n) {
            return (PooledMutableBlockPos)super.move(facing, n);
        }
    }

    public static class MutableBlockPos
    extends BlockPos {
        protected int x;
        protected int y;
        protected int z;

        public MutableBlockPos() {
            this(0, 0, 0);
        }

        public MutableBlockPos(BlockPos pos) {
            this(pos.getX(), pos.getY(), pos.getZ());
        }

        public MutableBlockPos(int x_, int y_, int z_) {
            super(0, 0, 0);
            this.x = x_;
            this.y = y_;
            this.z = z_;
        }

        @Override
        public BlockPos add(double x, double y, double z) {
            return super.add(x, y, z).toImmutable();
        }

        @Override
        public BlockPos add(int x, int y, int z) {
            return super.add(x, y, z).toImmutable();
        }

        @Override
        public BlockPos offset(ForgeDirection facing, int n) {
            return super.offset(facing, n).toImmutable();
        }

        @Override
        public BlockPos rotate(int rotationIn) {
            return super.rotate(rotationIn).toImmutable();
        }

        @Override
        public int getX() {
            return this.x;
        }

        @Override
        public int getY() {
            return this.y;
        }

        @Override
        public int getZ() {
            return this.z;
        }

        public MutableBlockPos setPos(int xIn, int yIn, int zIn) {
            this.x = xIn;
            this.y = yIn;
            this.z = zIn;
            return this;
        }

        public MutableBlockPos setPos(double xIn, double yIn, double zIn) {
            return this.setPos(MathHelper.func_76128_c((double)xIn), MathHelper.func_76128_c((double)yIn), MathHelper.func_76128_c((double)zIn));
        }

        @SideOnly(value=Side.CLIENT)
        public MutableBlockPos setPos(Entity entityIn) {
            return this.setPos(entityIn.field_70165_t, entityIn.field_70163_u, entityIn.field_70161_v);
        }

        public MutableBlockPos setPos(Vec3 vec) {
            return this.setPos(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
        }

        public MutableBlockPos move(ForgeDirection facing) {
            return this.move(facing, 1);
        }

        public MutableBlockPos move(ForgeDirection facing, int n) {
            return this.setPos(this.x + facing.offsetX * n, this.y + facing.offsetY * n, this.z + facing.offsetZ * n);
        }

        public void setY(int yIn) {
            this.y = yIn;
        }

        @Override
        public BlockPos toImmutable() {
            return new BlockPos(this);
        }
    }
}

