/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.aquaacrobatics.proxy;

import com.fuzs.aquaacrobatics.biome.BiomeWaterFogColors;
import com.fuzs.aquaacrobatics.config.ConfigHandler;
import com.fuzs.aquaacrobatics.entity.player.IPlayerResizeable;
import com.fuzs.aquaacrobatics.handler.CommonHandler;
import com.fuzs.aquaacrobatics.integration.IntegrationManager;
import com.fuzs.aquaacrobatics.integration.hats.HatsIntegration;
import com.fuzs.aquaacrobatics.network.NetworkHandler;
import com.gtnewhorizon.gtnhlib.eventbus.EventBusSubscriber;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;

@EventBusSubscriber
public class CommonProxy {
    private boolean needNetworking() {
        return ConfigHandler.MovementConfig.enableToggleCrawling;
    }

    public void onPreInit(FMLPreInitializationEvent event) {
        IntegrationManager.loadCompat();
        if (this.needNetworking()) {
            NetworkHandler.registerMessages("aquaacrobatics");
        }
        MinecraftForge.EVENT_BUS.register((Object)new CommonHandler());
        MinecraftForge.EVENT_BUS.register((Object)new CrawlHandler());
    }

    public void onInit(FMLInitializationEvent event) {
    }

    public void onMappings() {
    }

    public void onPostInit(FMLPostInitializationEvent event) {
        if (IntegrationManager.isHatsEnabled()) {
            HatsIntegration.register();
        }
        BiomeWaterFogColors.recomputeColors();
    }

    public class CrawlHandler {
        @SubscribeEvent
        public void onPlayerJump(LivingEvent.LivingJumpEvent event) {
            IPlayerResizeable r;
            if (!(event.entityLiving instanceof EntityPlayer)) {
                return;
            }
            EntityPlayer player = (EntityPlayer)event.entityLiving;
            if (player instanceof IPlayerResizeable && (r = (IPlayerResizeable)player).isForcingCrawling()) {
                r.setForcingCrawling(false);
                player.func_82170_o(Potion.field_76421_d.field_76415_H);
                player.func_82170_o(Potion.field_76419_f.field_76415_H);
            }
        }
    }
}

