/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.aquaacrobatics.mixins.early.minecraft.client;

import com.fuzs.aquaacrobatics.client.model.IModelBipedSwimming;
import com.fuzs.aquaacrobatics.config.ConfigHandler;
import com.fuzs.aquaacrobatics.entity.player.IPlayerResizeable;
import com.fuzs.aquaacrobatics.integration.efr.EFRIntegration;
import com.fuzs.aquaacrobatics.util.math.MathHelperNew;
import javax.annotation.Nonnull;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ModelBiped.class})
public abstract class ModelBipedMixin
extends ModelBase
implements IModelBipedSwimming {
    @Shadow
    public ModelRenderer field_78116_c;
    @Shadow
    public ModelRenderer field_78114_d;
    @Shadow
    public ModelRenderer field_78112_f;
    @Shadow
    public ModelRenderer field_78113_g;
    @Shadow
    public ModelRenderer field_78123_h;
    @Shadow
    public ModelRenderer field_78124_i;
    @Unique
    public float swimAnimation;

    @Redirect(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/model/ModelBiped;setRotationAngles(FFFFFFLnet/minecraft/entity/Entity;)V"))
    public void setRotationAngles(ModelBiped modelBiped, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, Entity entityIn) {
        if (entityIn instanceof IPlayerResizeable) {
            boolean flag = EFRIntegration.getTicksElytraFlying((EntityPlayer)entityIn) > 4.0f;
            boolean flag1 = ((IPlayerResizeable)entityIn).isActuallySwimming();
            if (!flag && this.swimAnimation > 0.0f) {
                headPitch = flag1 ? this.rotLerpRad(this.swimAnimation, this.field_78116_c.field_78795_f, -0.7853982f) / ((float)Math.PI / 180) : this.rotLerpRad(this.swimAnimation, this.field_78116_c.field_78795_f, headPitch * ((float)Math.PI / 180)) / ((float)Math.PI / 180);
            }
        }
        modelBiped.func_78087_a(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor, entityIn);
    }

    @Inject(method={"setRotationAngles"}, at={@At(value="FIELD", target="net/minecraft/client/model/ModelBiped.onGround:F", ordinal=0)})
    public void setRotationAnglesPre(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, Entity entityIn, CallbackInfo callbackInfo) {
        ItemStack stack;
        EntityPlayer player;
        if (!ConfigHandler.MiscellaneousConfig.eatingAnimation || !(entityIn instanceof EntityLivingBase)) {
            return;
        }
        EntityLivingBase livingEntityIn = (EntityLivingBase)entityIn;
        if (livingEntityIn instanceof EntityPlayer && (player = (EntityPlayer)livingEntityIn).func_70694_bm() != null && player.func_71052_bv() > 0 && ((stack = livingEntityIn.func_70694_bm()) != null && stack.func_77975_n() == EnumAction.eat || stack.func_77975_n() == EnumAction.drink)) {
            float partialTicks = (float)((double)ageInTicks - Math.floor(ageInTicks));
            float animationCount = (float)player.func_71052_bv() - partialTicks + 1.0f;
            float useRatio = animationCount / (float)stack.func_77988_m();
            float f = 1.0f - (float)Math.pow(useRatio, 27.0);
            if (useRatio < 0.8f) {
                f += MathHelper.func_76135_e((float)(MathHelper.func_76134_b((float)(animationCount / 4.0f * (float)Math.PI)) * 0.1f));
            }
            this.field_78112_f.field_78795_f = f * (this.field_78112_f.field_78795_f * 0.5f - 1.2566371f);
            this.field_78112_f.field_78796_g = f * (float)Math.PI / 6.0f * -1.0f;
            this.field_78113_g.field_78795_f = f * (this.field_78113_g.field_78795_f * 0.5f - 1.2566371f);
            this.field_78113_g.field_78796_g = f * (float)Math.PI / 6.0f * 1.0f;
        }
    }

    @Inject(method={"setRotationAngles"}, at={@At(value="TAIL")}, cancellable=true)
    public void setRotationAnglesPost(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, Entity entityIn, CallbackInfo callbackInfo) {
        if (this.swimAnimation > 0.0f) {
            float f3;
            float f1 = limbSwing % 26.0f;
            float f2 = this.field_78095_p > 0.0f ? 0.0f : this.swimAnimation;
            float f = f3 = this.field_78095_p > 0.0f ? 0.0f : this.swimAnimation;
            if (f1 < 14.0f) {
                this.field_78113_g.field_78795_f = this.rotLerpRad(f3, this.field_78113_g.field_78795_f, 0.0f);
                this.field_78112_f.field_78795_f = MathHelperNew.lerp(f2, this.field_78112_f.field_78795_f, 0.0f);
                this.field_78113_g.field_78796_g = this.rotLerpRad(f3, this.field_78113_g.field_78796_g, (float)Math.PI);
                this.field_78112_f.field_78796_g = MathHelperNew.lerp(f2, this.field_78112_f.field_78796_g, (float)Math.PI);
                this.field_78113_g.field_78808_h = this.rotLerpRad(f3, this.field_78113_g.field_78808_h, (float)Math.PI + 1.8707964f * this.getArmAngleSq(f1) / this.getArmAngleSq(14.0f));
                this.field_78112_f.field_78808_h = MathHelperNew.lerp(f2, this.field_78112_f.field_78808_h, (float)Math.PI - 1.8707964f * this.getArmAngleSq(f1) / this.getArmAngleSq(14.0f));
            } else if (f1 >= 14.0f && f1 < 22.0f) {
                float f10 = (f1 - 14.0f) / 8.0f;
                this.field_78113_g.field_78795_f = this.rotLerpRad(f3, this.field_78113_g.field_78795_f, 1.5707964f * f10);
                this.field_78112_f.field_78795_f = MathHelperNew.lerp(f2, this.field_78112_f.field_78795_f, 1.5707964f * f10);
                this.field_78113_g.field_78796_g = this.rotLerpRad(f3, this.field_78113_g.field_78796_g, (float)Math.PI);
                this.field_78112_f.field_78796_g = MathHelperNew.lerp(f2, this.field_78112_f.field_78796_g, (float)Math.PI);
                this.field_78113_g.field_78808_h = this.rotLerpRad(f3, this.field_78113_g.field_78808_h, 5.012389f - 1.8707964f * f10);
                this.field_78112_f.field_78808_h = MathHelperNew.lerp(f2, this.field_78112_f.field_78808_h, 1.2707963f + 1.8707964f * f10);
            } else if (f1 >= 22.0f && f1 < 26.0f) {
                float f9 = (f1 - 22.0f) / 4.0f;
                this.field_78113_g.field_78795_f = this.rotLerpRad(f3, this.field_78113_g.field_78795_f, 1.5707964f - 1.5707964f * f9);
                this.field_78112_f.field_78795_f = MathHelperNew.lerp(f2, this.field_78112_f.field_78795_f, 1.5707964f - 1.5707964f * f9);
                this.field_78113_g.field_78796_g = this.rotLerpRad(f3, this.field_78113_g.field_78796_g, (float)Math.PI);
                this.field_78112_f.field_78796_g = MathHelperNew.lerp(f2, this.field_78112_f.field_78796_g, (float)Math.PI);
                this.field_78113_g.field_78808_h = this.rotLerpRad(f3, this.field_78113_g.field_78808_h, (float)Math.PI);
                this.field_78112_f.field_78808_h = MathHelperNew.lerp(f2, this.field_78112_f.field_78808_h, (float)Math.PI);
            }
            this.field_78124_i.field_78795_f = MathHelperNew.lerp(this.swimAnimation, this.field_78124_i.field_78795_f, 0.3f * MathHelper.func_76134_b((float)(limbSwing * 0.33333334f + (float)Math.PI)));
            this.field_78123_h.field_78795_f = MathHelperNew.lerp(this.swimAnimation, this.field_78123_h.field_78795_f, 0.3f * MathHelper.func_76134_b((float)(limbSwing * 0.33333334f)));
            callbackInfo.cancel();
        }
    }

    public void func_78086_a(@Nonnull EntityLivingBase entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTickTime) {
        if (entitylivingbaseIn instanceof IPlayerResizeable) {
            this.swimAnimation = ((IPlayerResizeable)entitylivingbaseIn).getSwimAnimation(partialTickTime);
        }
    }

    private float getArmAngleSq(float limbSwing) {
        return -65.0f * limbSwing + limbSwing * limbSwing;
    }

    @Unique
    protected float rotLerpRad(float angleIn, float maxAngleIn, float mulIn) {
        float f = (mulIn - maxAngleIn) % ((float)Math.PI * 2);
        if (f < (float)(-Math.PI)) {
            f += (float)Math.PI * 2;
        }
        if (f >= (float)Math.PI) {
            f -= (float)Math.PI * 2;
        }
        return maxAngleIn + angleIn * f;
    }

    @Override
    public void setSwimAnimation(float swimAnimation) {
        this.swimAnimation = swimAnimation;
    }
}

