/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.aquaacrobatics.mixins.early.minecraft.client;

import com.fuzs.aquaacrobatics.client.entity.IPlayerSPSwimming;
import com.fuzs.aquaacrobatics.config.ConfigHandler;
import com.fuzs.aquaacrobatics.entity.Pose;
import com.fuzs.aquaacrobatics.entity.player.IPlayerResizeable;
import com.fuzs.aquaacrobatics.integration.efr.EFRIntegration;
import com.fuzs.aquaacrobatics.util.BlockPos;
import com.fuzs.aquaacrobatics.util.MovementInputStorage;
import com.fuzs.aquaacrobatics.util.math.AxisAlignedBBSpliterator;
import com.mojang.authlib.GameProfile;
import java.util.Objects;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovementInput;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityPlayerSP.class})
public abstract class EntityPlayerSPMixin
extends AbstractClientPlayer
implements IPlayerSPSwimming {
    @Shadow
    protected Minecraft field_71159_c;
    @Shadow
    protected int field_71156_d;
    @Shadow
    public MovementInput field_71158_b;
    private final MovementInputStorage movementStorage = new MovementInputStorage();
    private boolean isCrouching;

    public EntityPlayerSPMixin(World worldIn, GameProfile playerProfile) {
        super(worldIn, playerProfile);
    }

    @Inject(method={"isSneaking"}, at={@At(value="HEAD")}, cancellable=true)
    public void isSneaking(CallbackInfoReturnable<Boolean> callbackInfo) {
        callbackInfo.setReturnValue((Object)this.isCrouching);
    }

    @Override
    public boolean isActuallySneaking() {
        return this.field_71158_b != null && this.field_71158_b.field_78899_d;
    }

    @Override
    public boolean isForcedDown() {
        return ((IPlayerResizeable)((Object)this)).isResizingAllowed() && !this.field_71075_bZ.field_75100_b ? this.func_70093_af() || ((IPlayerResizeable)((Object)this)).isVisuallySwimming() : this.isActuallySneaking();
    }

    @Override
    public boolean isUsingSwimmingAnimation() {
        return this.isUsingSwimmingAnimation(this.field_71158_b.field_78900_b, this.field_71158_b.field_78902_a);
    }

    @Override
    public boolean isUsingSwimmingAnimation(float moveForward, float moveStrafe) {
        if (this.canSwim()) {
            return this.isMovingForward(moveForward, moveStrafe);
        }
        if (ConfigHandler.MovementConfig.sidewaysSprinting) {
            return moveForward >= 0.8f || Math.abs(moveStrafe) > 0.8f;
        }
        return moveForward >= 0.8f;
    }

    @Override
    public boolean canSwim() {
        return ((IPlayerResizeable)((Object)this)).getEyesInWaterPlayer();
    }

    @Override
    public boolean isMovingForward(float moveForward, float moveStrafe) {
        if (moveForward > 1.0E-5f) {
            return true;
        }
        if (ConfigHandler.MovementConfig.sidewaysSwimming) {
            return Math.abs(moveStrafe) > 1.0E-5f;
        }
        return false;
    }

    @Inject(method={"func_145771_j"}, at={@At(value="HEAD")}, cancellable=true)
    protected void pushOutOfBlocks(double x, double y, double z, CallbackInfoReturnable<Boolean> callbackInfo) {
        if (ConfigHandler.playerBlockCollisions != ConfigHandler.PlayerBlockCollisions.EXACT) {
            return;
        }
        if (!this.field_70145_X) {
            this.setPlayerOffsetMotion(x, z);
        }
        callbackInfo.setReturnValue((Object)false);
    }

    private void setPlayerOffsetMotion(double x, double z) {
        int blockZ;
        int blockX = (int)Math.floor(x);
        if (this.shouldBlockPushPlayer(blockX, blockZ = (int)Math.floor(z))) {
            ForgeDirection[] xzPlane;
            double d0 = x - (double)blockX;
            double d1 = z - (double)blockZ;
            ForgeDirection direction = null;
            double closest = Double.MAX_VALUE;
            for (ForgeDirection dir : xzPlane = new ForgeDirection[]{ForgeDirection.WEST, ForgeDirection.EAST, ForgeDirection.NORTH, ForgeDirection.SOUTH}) {
                boolean isX = dir.offsetX != 0;
                double d3 = isX ? d0 : d1;
                double d4 = dir.offsetX + dir.offsetZ > 0 ? 1.0 - d3 : d3;
                int offsetX = blockX + dir.offsetX;
                int offsetZ = blockZ + dir.offsetZ;
                if (!(d4 < closest) || this.shouldBlockPushPlayer(offsetX, offsetZ)) continue;
                closest = d4;
                direction = dir;
            }
            if (direction != null) {
                if (direction.offsetX != 0) {
                    this.field_70159_w = 0.1 * (double)direction.offsetX;
                } else {
                    this.field_70179_y = 0.1 * (double)direction.offsetZ;
                }
            }
        }
    }

    private boolean shouldBlockPushPlayer(int x, int z) {
        double minY = this.field_70121_D.field_72338_b;
        double maxY = this.field_70121_D.field_72337_e;
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)x, (double)minY, (double)z, (double)((double)x + 1.0), (double)maxY, (double)((double)z + 1.0));
        return !EntityPlayerSPMixin.isAxisAlignedBBNotClear(this.field_70170_p, (Entity)this, aabb.func_72314_b(-1.0E-7, -1.0E-7, -1.0E-7));
    }

    private boolean shouldBlockPushPlayer(BlockPos pos) {
        double minY = this.field_70121_D.field_72338_b;
        double maxY = this.field_70121_D.field_72337_e;
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)pos.getX(), (double)minY, (double)pos.getZ(), (double)((double)pos.getX() + 1.0), (double)maxY, (double)((double)pos.getZ() + 1.0));
        return !EntityPlayerSPMixin.isAxisAlignedBBNotClear(this.field_70170_p, (Entity)this, aabb.func_72314_b(-1.0E-7, -1.0E-7, -1.0E-7));
    }

    private static boolean isAxisAlignedBBNotClear(World world, @Nullable Entity entity, AxisAlignedBB aabb) {
        return EntityPlayerSPMixin.createAxisAlignedBBStream(world, entity, aabb).allMatch(Objects::isNull);
    }

    private static Stream<AxisAlignedBB> createAxisAlignedBBStream(World world, @Nullable Entity entity, AxisAlignedBB aabb) {
        return StreamSupport.stream(new AxisAlignedBBSpliterator(world, entity, aabb), false);
    }

    @Redirect(method={"func_145771_j"}, at=@At(value="INVOKE", target="java/lang/Math.round(F)I"))
    private int round(float a) {
        if (ConfigHandler.playerBlockCollisions == ConfigHandler.PlayerBlockCollisions.APPROXIMATE) {
            a = (float)((double)a - 0.65);
        }
        return Math.round(a);
    }

    @Inject(method={"onLivingUpdate"}, at={@At(value="HEAD")})
    public void onLivingUpdatePre(CallbackInfo callbackInfo) {
        this.updateSprintToggleTimer();
        this.movementStorage.copyFrom(this.field_71158_b);
        this.movementStorage.isSprinting = this.func_70051_ag();
        this.movementStorage.isFlying = this.field_71075_bZ.field_75100_b;
        this.movementStorage.isStartingToFly = this.isStartingToFly();
    }

    private void updateSprintToggleTimer() {
        if (this.field_71158_b.field_78899_d) {
            this.field_71156_d = 0;
        }
        this.movementStorage.sprintToggleTimer = this.field_71156_d;
        if (this.movementStorage.sprintToggleTimer > 0) {
            --this.movementStorage.sprintToggleTimer;
        }
        if (this.func_71039_bw() && !this.func_70115_ae()) {
            this.movementStorage.sprintToggleTimer = 0;
        }
    }

    private boolean isStartingToFly() {
        if (this.field_71075_bZ.field_75101_c) {
            if (EFRIntegration.isSpectator((EntityPlayer)this)) {
                return !this.field_71075_bZ.field_75100_b;
            }
            if (!this.field_71158_b.field_78901_c && this.field_71159_c.field_71474_y.field_74314_A.func_151470_d()) {
                return this.field_71101_bC != 0 && !((IPlayerResizeable)((Object)this)).isSwimming();
            }
        }
        return false;
    }

    @Inject(method={"onLivingUpdate"}, at={@At(value="TAIL")})
    public void onLivingUpdate(CallbackInfo callbackInfo) {
        this.updatePlayerMoveState();
        this.isCrouching = this.isCrouching(!((IPlayerResizeable)((Object)this)).isPoseClear(Pose.STANDING));
        this.func_70031_b(this.movementStorage.isSprinting);
        boolean isSaturated = (float)this.func_71024_bL().func_75116_a() > 6.0f || this.field_71075_bZ.field_75101_c;
        this.startSprinting(isSaturated);
        this.stopSprinting(isSaturated);
        this.handleWaterSneaking();
        this.slowDownSneakFlying();
    }

    private void updatePlayerMoveState() {
        if (!this.field_71158_b.field_78899_d && this.isForcedDown()) {
            this.field_71158_b.field_78902_a = (float)((double)this.field_71158_b.field_78902_a * 0.3);
            this.field_71158_b.field_78900_b = (float)((double)this.field_71158_b.field_78900_b * 0.3);
        }
        if (this.field_71158_b.field_78899_d && !this.isForcedDown()) {
            this.field_71158_b.field_78902_a = (float)((double)this.field_71158_b.field_78902_a / 0.3);
            this.field_71158_b.field_78900_b = (float)((double)this.field_71158_b.field_78900_b / 0.3);
        }
    }

    private boolean isCrouching(boolean cantStand) {
        if (!(this.movementStorage.isFlying && cantStand || !(EFRIntegration.getTicksElytraFlying((EntityPlayer)this) <= 4.0f) || ((IPlayerResizeable)((Object)this)).isSwimming() || !this.field_70122_E && this.func_70090_H() || this.func_70617_f_() || !((IPlayerResizeable)((Object)this)).isPoseClear(Pose.CROUCHING) && !this.field_70145_X)) {
            return this.field_71158_b.field_78899_d || ((IPlayerResizeable)((Object)this)).isResizingAllowed() && !this.func_70608_bn() && cantStand;
        }
        return false;
    }

    private void startSprinting(boolean isSaturated) {
        boolean isSprintingEnvironment;
        boolean wasSneaking = this.movementStorage.field_78899_d;
        boolean wasSwimming = this.isUsingSwimmingAnimation(this.movementStorage.field_78900_b, this.movementStorage.field_78902_a);
        boolean bl = isSprintingEnvironment = this.field_70122_E || this.canSwim() || this.movementStorage.isFlying;
        if (isSprintingEnvironment && !wasSneaking && !wasSwimming && this.isUsingSwimmingAnimation() && !this.func_70051_ag() && isSaturated && !this.func_70644_a(Potion.field_76440_q)) {
            if (this.movementStorage.sprintToggleTimer <= 0 && !this.field_71159_c.field_71474_y.field_151444_V.func_151470_d()) {
                this.field_71156_d = ConfigHandler.MovementConfig.noDoubleTapSprinting ? 0 : 7;
            } else {
                this.func_70031_b(true);
            }
        }
        if (!this.func_70051_ag() && (!this.func_70090_H() || this.canSwim()) && this.isUsingSwimmingAnimation() && isSaturated && !this.func_70644_a(Potion.field_76440_q) && this.field_71159_c.field_71474_y.field_151444_V.func_151470_d()) {
            this.func_70031_b(true);
        }
    }

    private void stopSprinting(boolean isSaturated) {
        if (this.func_70051_ag()) {
            boolean hasCollided;
            boolean isNotMoving = !this.isMovingForward(this.field_71158_b.field_78900_b, this.field_71158_b.field_78902_a) || !isSaturated;
            boolean bl = hasCollided = isNotMoving || this.func_70090_H() && !this.canSwim() && !this.movementStorage.isFlying;
            if (((IPlayerResizeable)((Object)this)).isSwimming()) {
                if (!this.field_71158_b.field_78899_d && isNotMoving || !this.func_70090_H()) {
                    this.func_70031_b(false);
                }
            } else if (hasCollided) {
                this.func_70031_b(false);
            }
        }
    }

    @Override
    public boolean canPerformElytraTakeoff() {
        return ConfigHandler.MovementConfig.easyElytraTakeoff && this.field_71158_b.field_78901_c && !this.movementStorage.isStartingToFly && !this.movementStorage.field_78901_c && this.field_70181_x >= 0.0 && !this.field_71075_bZ.field_75100_b && !this.func_70115_ae() && !this.func_70617_f_();
    }

    private void handleWaterSneaking() {
        if (this.func_70090_H() && this.field_71158_b.field_78899_d && !this.field_71075_bZ.field_75100_b) {
            this.handleSneakWater();
        }
    }

    private void slowDownSneakFlying() {
        if (this.field_71075_bZ.field_75100_b && this.field_71158_b.field_78899_d) {
            this.field_71158_b.field_78902_a = (float)((double)this.field_71158_b.field_78902_a * 0.3);
            this.field_71158_b.field_78900_b = (float)((double)this.field_71158_b.field_78900_b * 0.3);
        }
    }

    protected void handleSneakWater() {
        this.field_70181_x -= (double)0.04f * this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e();
    }
}

