/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.aquaacrobatics.mixins.early.minecraft;

import com.fuzs.aquaacrobatics.config.ConfigHandler;
import com.fuzs.aquaacrobatics.entity.EntitySize;
import com.fuzs.aquaacrobatics.entity.Pose;
import com.fuzs.aquaacrobatics.entity.player.IPlayerResizeable;
import com.fuzs.aquaacrobatics.integration.IntegrationManager;
import com.fuzs.aquaacrobatics.integration.efr.EFRIntegration;
import com.fuzs.aquaacrobatics.integration.morph.MorphIntegration;
import com.fuzs.aquaacrobatics.util.math.MathHelperNew;
import com.google.common.collect.ImmutableMap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.PlayerCapabilities;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidBlock;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityPlayer.class})
public abstract class EntityPlayerMixin
extends EntityLivingBase
implements IPlayerResizeable {
    private static final EntitySize STANDING_SIZE = EntitySize.flexible(0.6f, 1.8f);
    private static final Map<Pose, EntitySize> SIZE_BY_POSE = ImmutableMap.builder().put((Object)Pose.STANDING, (Object)STANDING_SIZE).put((Object)Pose.SLEEPING, (Object)EntitySize.fixed(0.2f, 0.2f)).put((Object)Pose.FALL_FLYING, (Object)EntitySize.flexible(0.6f, 0.6f)).put((Object)Pose.SWIMMING, (Object)EntitySize.flexible(0.6f, 0.6f)).put((Object)Pose.SPIN_ATTACK, (Object)EntitySize.flexible(0.6f, 0.6f)).put((Object)Pose.CROUCHING, (Object)EntitySize.flexible(0.6f, 1.5f)).put((Object)Pose.DYING, (Object)EntitySize.fixed(0.2f, 0.2f)).build();
    @Shadow
    public PlayerCapabilities field_71075_bZ;
    @Shadow
    public float field_71107_bF;
    @Shadow
    public float field_71109_bG;
    @Shadow(remap=false)
    @Final
    public float eyeHeight;
    protected boolean eyesInWater;
    protected boolean eyesInWaterPlayer;
    private EntitySize size;
    private float playerEyeHeight;
    private float previousEyeHeight;
    private float swimAnimation;
    private float lastSwimAnimation;
    private float timeUnderwater;
    private boolean inBubbleColumn;

    public EntityPlayerMixin(World worldIn) {
        super(worldIn);
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onConstructed(CallbackInfo callbackInfo) {
        this.size = EntitySize.flexible(0.6f, 1.8f);
        this.playerEyeHeight = this.getEyeHeight(Pose.STANDING, this.size);
        this.func_70096_w().func_75682_a(ConfigHandler.MiscellaneousConfig.poseId, (Object)Pose.STANDING.ordinal());
        if (ConfigHandler.MovementConfig.enableToggleCrawling) {
            this.func_70096_w().func_75682_a(ConfigHandler.MiscellaneousConfig.CrawlingId, (Object)0);
        }
    }

    public void func_145781_i(@Nonnull int key) {
        if (key == ConfigHandler.MiscellaneousConfig.poseId && this.field_70170_p.field_72995_K && !this.func_70115_ae()) {
            this.recalculateEyeHeight();
            this.recalculateSize();
        }
        super.func_145781_i(key);
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.func_70090_H()) {
            int i = EFRIntegration.isSpectator(this.getPlayer()) ? 10 : 1;
            this.timeUnderwater = MathHelper.func_76131_a((float)(this.timeUnderwater + (float)i), (float)0.0f, (float)600.0f);
        } else if (this.timeUnderwater > 0.0f) {
            this.timeUnderwater = MathHelper.func_76131_a((float)(this.timeUnderwater - 10.0f), (float)0.0f, (float)600.0f);
        }
        this.updateEyesInWater();
        this.updateSwimming();
    }

    @Override
    public float getWaterVision() {
        if (!this.func_70090_H()) {
            return 0.0f;
        }
        float f = 600.0f;
        float f1 = 100.0f;
        if (this.timeUnderwater >= 600.0f) {
            return 1.0f;
        }
        float f2 = MathHelper.func_76131_a((float)(this.timeUnderwater / 100.0f), (float)0.0f, (float)1.0f);
        float f3 = this.timeUnderwater < 100.0f ? 0.0f : MathHelper.func_76131_a((float)((this.timeUnderwater - 100.0f) / 500.0f), (float)0.0f, (float)1.0f);
        return f2 * 0.6f + f3 * 0.39999998f;
    }

    @Override
    public boolean canForceCrawling() {
        return ConfigHandler.MovementConfig.enableToggleCrawling && !this.func_70115_ae() && !this.field_71075_bZ.field_75100_b && !this.func_70617_f_();
    }

    @Override
    public boolean isForcingCrawling() {
        return this.canForceCrawling() && this.func_70096_w().func_75679_c(ConfigHandler.MiscellaneousConfig.CrawlingId) == 1;
    }

    @Override
    public void setForcingCrawling(boolean flag) {
        if (!this.canForceCrawling()) {
            return;
        }
        this.func_70096_w().func_75692_b(ConfigHandler.MiscellaneousConfig.CrawlingId, (Object)(flag ? 1 : 0));
    }

    @Override
    public boolean canSwim() {
        return this.eyesInWater && this.func_70090_H();
    }

    @Override
    public void updateSwimming() {
        if (this.field_71075_bZ.field_75100_b) {
            this.setSwimming(false);
        } else if (this.isSwimming()) {
            this.setSwimming(this.func_70051_ag() && this.func_70090_H() && !this.func_70115_ae());
        } else {
            this.setSwimming(this.func_70051_ag() && this.canSwim() && !this.func_70115_ae());
        }
    }

    private void updateEyesInWater() {
        this.eyesInWater = this.func_70055_a(Material.field_151586_h);
    }

    protected boolean updateEyesInWaterPlayer() {
        this.eyesInWaterPlayer = this.func_70055_a(Material.field_151586_h);
        return this.eyesInWaterPlayer;
    }

    @Override
    public boolean getEyesInWaterPlayer() {
        return this.eyesInWaterPlayer;
    }

    @Override
    public final float getWidth() {
        return this.size.width;
    }

    @Override
    public final float getHeight() {
        return this.size.height;
    }

    @Override
    public EntitySize getSize(Pose poseIn) {
        return SIZE_BY_POSE.getOrDefault((Object)poseIn, STANDING_SIZE);
    }

    @Override
    public void recalculateSize() {
        EntitySize oldSize = this.size;
        Pose pose = this.getPose();
        EntitySize newSize = this.getSize(pose);
        if (this.isResizingAllowed()) {
            this.recalculateSize(oldSize, newSize);
            this.field_70130_N = newSize.width;
            this.field_70131_O = newSize.height;
        }
        this.size = newSize;
    }

    protected void recalculateSize(EntitySize oldSize, EntitySize newSize) {
        if (newSize.width < oldSize.width) {
            double d0 = (double)newSize.width / 2.0;
            this.field_70121_D.func_72328_c(AxisAlignedBB.func_72330_a((double)(this.field_70165_t - d0), (double)this.field_70163_u, (double)(this.field_70161_v - d0), (double)(this.field_70165_t + d0), (double)(this.field_70163_u + (double)newSize.height), (double)(this.field_70161_v + d0)));
        } else {
            AxisAlignedBB axisalignedbb = this.field_70121_D;
            this.field_70121_D.func_72328_c(AxisAlignedBB.func_72330_a((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72339_c, (double)(axisalignedbb.field_72340_a + (double)newSize.width), (double)(axisalignedbb.field_72338_b + (double)newSize.height), (double)(axisalignedbb.field_72339_c + (double)newSize.width)));
            if (newSize.width > oldSize.width && !this.field_70148_d && !this.field_70170_p.field_72995_K) {
                float distance = oldSize.width - newSize.width;
                this.func_70091_d(distance, 0.0, distance);
            }
        }
    }

    private void recalculateEyeHeight() {
        Pose pose = this.getPose();
        EntitySize entitysize = this.getSize(pose);
        this.playerEyeHeight = this.getEyeHeight(pose, entitysize);
        this.previousEyeHeight = this.eyeHeight;
    }

    @Override
    public boolean isResizingAllowed() {
        if (IntegrationManager.isMorphEnabled() && MorphIntegration.isMorphing(this.getPlayer())) {
            return false;
        }
        float delta = 0.025f;
        AxisAlignedBB bb = this.field_70121_D;
        if (this.field_70130_N < 0.025f || this.field_70131_O < 0.025f || bb.field_72336_d - bb.field_72340_a < (double)0.025f || bb.field_72337_e - bb.field_72338_b < (double)0.025f) {
            return true;
        }
        boolean sizeIsOk = Math.abs(this.field_70130_N / this.getWidth() - 1.0f) < 0.025f && Math.abs(this.field_70131_O / this.getHeight() - 1.0f) < 0.025f;
        boolean boundingBoxIsOk = Math.abs((bb.field_72336_d - bb.field_72340_a) / (double)this.getWidth() - 1.0) < (double)0.025f && Math.abs((bb.field_72337_e - bb.field_72338_b) / (double)this.getHeight() - 1.0) < (double)0.025f;
        return sizeIsOk && boundingBoxIsOk;
    }

    protected float getEyeHeight(Pose poseIn, EntitySize sizeIn) {
        return poseIn == Pose.SLEEPING || poseIn == Pose.DYING ? 0.2f : this.getStandingEyeHeight(poseIn, sizeIn);
    }

    @Inject(method={"getSize"}, at={@At(value="HEAD")}, cancellable=true)
    private void fixDyingSize(Pose pose, CallbackInfoReturnable<EntitySize> cir) {
        if (pose == Pose.DYING) {
            cir.setReturnValue((Object)new EntitySize(0.6f, 1.8f, false));
        }
    }

    @Override
    public boolean isActuallySneaking() {
        return this.func_70093_af();
    }

    @Override
    public float getStandingEyeHeight(Pose poseIn, EntitySize sizeIn) {
        switch (poseIn) {
            case SWIMMING: 
            case FALL_FLYING: 
            case SPIN_ATTACK: {
                return this.eyeHeight;
            }
            case CROUCHING: {
                return this.isResizingAllowed() ? 0.35f : 0.08f;
            }
        }
        return this.eyeHeight;
    }

    @Override
    public void setPose(Pose poseIn) {
        this.func_70096_w().func_75692_b(ConfigHandler.MiscellaneousConfig.poseId, (Object)poseIn.ordinal());
    }

    @Override
    public Pose getPose() {
        try {
            return Pose.values()[this.func_70096_w().func_75679_c(ConfigHandler.MiscellaneousConfig.poseId)];
        }
        catch (Exception e) {
            return Pose.STANDING;
        }
    }

    @Override
    public boolean isPoseClear(Pose poseIn) {
        return this.field_70170_p.func_72945_a((Entity)this, this.getBoundingBox(poseIn)).isEmpty();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70065_x() {
        this.field_70129_M = 1.62f;
        this.setPose(Pose.STANDING);
        super.func_70065_x();
        this.func_70606_j(this.func_110138_aP());
        this.field_70725_aQ = 0;
    }

    @Inject(method={"onUpdate"}, at={@At(value="INVOKE", target="cpw/mods/fml/common/FMLCommonHandler.onPlayerPostTick(Lnet/minecraft/entity/player/EntityPlayer;)V", shift=At.Shift.BEFORE, remap=false)})
    protected void onUpdate(CallbackInfo callbackInfo) {
        this.updateSwimAnimation();
        this.updateEyesInWaterPlayer();
    }

    @Inject(method={"onUpdate"}, at={@At(value="INVOKE", target="cpw/mods/fml/common/FMLCommonHandler.onPlayerPostTick(Lnet/minecraft/entity/player/EntityPlayer;)V", shift=At.Shift.AFTER, remap=false)})
    protected void onUpdateSize(CallbackInfo callbackInfo) {
        this.updatePose();
        this.updateEyeHeight();
    }

    protected void updatePose() {
        if (this.getShouldBeDead()) {
            this.setPose(Pose.DYING);
            return;
        }
        if (this.func_70608_bn()) {
            this.setPose(Pose.SLEEPING);
            return;
        }
        if (this.isPoseClear(Pose.SWIMMING)) {
            Pose pose;
            if (EFRIntegration.isElytraFlying(this.getPlayer())) {
                pose = Pose.FALL_FLYING;
            } else if (this.isForcingCrawling() || this.isSwimming()) {
                pose = Pose.SWIMMING;
                if (this.field_70170_p.field_72995_K) {
                    this.field_70129_M = 0.28f;
                }
            } else if (!(!this.isActuallySneaking() || this.field_71075_bZ.field_75100_b || !this.field_70122_E && this.func_70090_H() || this.func_70617_f_())) {
                pose = Pose.CROUCHING;
                if (this.field_70170_p.field_72995_K) {
                    this.field_70129_M = 1.62f;
                }
            } else {
                pose = Pose.STANDING;
                if (this.field_70170_p.field_72995_K) {
                    this.field_70129_M = 1.62f;
                }
            }
            Pose finalPose = !this.field_70145_X && !this.func_70115_ae() && this.isResizingAllowed() && !this.isPoseClear(pose) ? (this.isPoseClear(Pose.CROUCHING) ? Pose.CROUCHING : (ConfigHandler.MovementConfig.enableCrawling ? Pose.SWIMMING : Pose.STANDING)) : pose;
            this.setPose(finalPose);
        }
    }

    private void updateEyeHeight() {
        if (this.eyeHeight != this.previousEyeHeight) {
            this.recalculateEyeHeight();
        }
    }

    protected AxisAlignedBB getBoundingBox(Pose pose) {
        EntitySize entitysize = this.getSize(pose);
        float f = entitysize.width / 2.0f;
        return AxisAlignedBB.func_72330_a((double)(this.field_70165_t - (double)f), (double)(this.field_70163_u - (double)this.field_70129_M + (double)this.field_70139_V), (double)(this.field_70161_v - (double)f), (double)(this.field_70165_t + (double)f), (double)(this.field_70163_u - (double)this.field_70129_M + (double)this.field_70139_V + (double)entitysize.height), (double)(this.field_70161_v + (double)f));
    }

    @Override
    public boolean getShouldBeDead() {
        return this.field_70725_aQ > 0;
    }

    @Override
    public boolean isSwimming() {
        return !this.field_71075_bZ.field_75100_b && this.func_70083_f(6) && !EFRIntegration.isSpectator(this.getPlayer());
    }

    @Override
    public boolean isActuallySwimming() {
        boolean isFallFlying = this.getPose() == Pose.FALL_FLYING;
        return this.getPose() == Pose.SWIMMING || isFallFlying;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isVisuallySwimming() {
        return this.isActuallySwimming() && !this.func_70090_H();
    }

    @Override
    public void setSwimming(boolean flag) {
        this.func_70052_a(6, flag);
    }

    @Override
    public float getSwimAnimation(float partialTicks) {
        return MathHelperNew.lerp(partialTicks, this.lastSwimAnimation, this.swimAnimation);
    }

    private void updateSwimAnimation() {
        this.lastSwimAnimation = this.swimAnimation;
        this.swimAnimation = this.isActuallySwimming() ? Math.min(1.0f, this.swimAnimation + 0.09f) : Math.max(0.0f, this.swimAnimation - 0.09f);
    }

    @Inject(method={"moveEntityWithHeading"}, at={@At(value="HEAD")}, cancellable=true)
    public void travel(float strafe, float forward, CallbackInfo callbackInfo) {
        double d3;
        double d0 = this.field_70165_t;
        double d1 = this.field_70163_u;
        double d2 = this.field_70161_v;
        if (this.isSwimming() && !this.func_70115_ae()) {
            d3 = this.func_70040_Z().field_72448_b;
            double d4 = d3 < -0.2 ? 0.085 : 0.06;
            Block fluidState = this.field_70170_p.func_147439_a((int)this.field_70165_t, (int)(this.field_70163_u + 1.0 - 0.1), (int)this.field_70161_v);
            if (d3 <= 0.0 || this.field_70703_bu || fluidState instanceof BlockLiquid || fluidState instanceof IFluidBlock) {
                double d5 = this.field_70181_x;
                this.field_70181_x += (d3 - d5) * d4;
            }
        }
        d3 = this.field_70181_x;
        float f = this.field_70747_aH;
        if (this.field_71075_bZ.field_75100_b && !this.func_70115_ae()) {
            this.field_70747_aH = this.field_71075_bZ.func_75093_a() * (float)(this.func_70051_ag() ? 2 : 1);
        }
        if (!this.field_71075_bZ.field_75100_b && this.func_70090_H()) {
            if (this.func_70613_aW()) {
                double d8 = this.field_70163_u;
                float f5 = this.func_70051_ag() ? 0.9f : 0.8f;
                float f6 = 0.02f;
                float f7 = 1.0f;
                if (f7 > 3.0f) {
                    f7 = 3.0f;
                }
                if (!this.field_70122_E) {
                    f7 *= 0.5f;
                }
                if (f7 > 0.0f) {
                    f5 += (0.54600006f - f5) * f7 / 3.0f;
                    f6 += (this.func_70689_ay() - f6) * f7 / 3.0f;
                }
                this.func_70060_a(strafe, forward, f6);
                this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
                if (this.field_70123_F && this.func_70617_f_()) {
                    this.field_70181_x = 0.2;
                }
                this.field_70159_w *= (double)f5;
                this.field_70181_x *= 0.8;
                this.field_70179_y *= (double)f5;
                this.applyGravity();
                if (this.field_70123_F && this.func_70038_c(this.field_70159_w, this.field_70181_x + (double)0.6f - this.field_70163_u + d8, this.field_70179_y)) {
                    this.field_70181_x = 0.3;
                }
                this.updateLimbSwing();
            }
        } else {
            super.func_70612_e(strafe, forward);
        }
        if (this.field_71075_bZ.field_75100_b && !this.func_70115_ae()) {
            this.field_70181_x = d3 * 0.6;
            this.field_70747_aH = f;
            this.field_70143_R = 0.0f;
            if (IntegrationManager.isEFREnabled()) {
                this.func_70052_a(EFRIntegration.elytraDataWatcherFlag(), false);
            }
        }
        this.func_71000_j(this.field_70165_t - d0, this.field_70163_u - d1, this.field_70161_v - d2);
        callbackInfo.cancel();
    }

    public void applyGravity() {
        if (!this.func_70051_ag()) {
            this.field_70181_x = this.field_70181_x <= 0.0 && Math.abs(this.field_70181_x - 0.005) >= 0.003 && Math.abs(this.field_70181_x - 0.005) < 0.003 ? -0.003 : (this.field_70181_x -= 0.005);
        }
    }

    private void updateLimbSwing() {
        this.field_70722_aY = this.field_70721_aZ;
        double d5 = this.field_70165_t - this.field_70169_q;
        double d9 = 0.0;
        double d7 = this.field_70161_v - this.field_70166_s;
        float f10 = MathHelper.func_76133_a((double)(d5 * d5 + d9 * d9 + d7 * d7)) * 4.0f;
        if (f10 > 1.0f) {
            f10 = 1.0f;
        }
        this.field_70721_aZ += (f10 - this.field_70721_aZ) * 0.4f;
        this.field_70754_ba += this.field_70721_aZ;
    }

    @Shadow
    public abstract void func_71000_j(double var1, double var3, double var5);

    @Inject(method={"onLivingUpdate"}, at={@At(value="TAIL")})
    public void onLivingUpdate(CallbackInfo callbackInfo) {
        float f = 0.0f;
        if (this.field_70122_E && !this.getShouldBeDead() && !this.isSwimming()) {
            f = Math.min(0.1f, MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y)));
        }
        this.field_71109_bG = this.field_71107_bF + (f - this.field_71107_bF) * 0.4f;
        this.field_70726_aT = 0.0f;
    }

    @Redirect(method={"sleepInBedAt"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/EntityPlayer;setSize(FF)V"))
    public void setSizeTrySleep(EntityPlayer player, float width, float height) {
        this.setPose(Pose.SLEEPING);
    }

    private EntityPlayer getPlayer() {
        return (EntityPlayer)this;
    }
}

