/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.aquaacrobatics.mixins.early.minecraft;

import com.fuzs.aquaacrobatics.config.ConfigHandler;
import com.fuzs.aquaacrobatics.entity.IBubbleColumnInteractable;
import com.fuzs.aquaacrobatics.entity.IRockableBoat;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityBoat.class})
public abstract class EntityBoatMixin
extends Entity
implements IBubbleColumnInteractable,
IRockableBoat {
    private boolean aqua$rocking;
    private boolean aqua$rockingDownwards;
    private float rockingIntensity;
    private float rockingAngle;
    private float prevRockingAngle;

    public EntityBoatMixin(World worldIn) {
        super(worldIn);
    }

    @Override
    public void onEnterBubbleColumnWithAirAbove(boolean downwards) {
        if (!this.field_70170_p.field_72995_K) {
            this.aqua$rocking = true;
            this.aqua$rockingDownwards = downwards;
            if (this.getRockingTicks() == 0) {
                this.setRockingTicks(60);
            }
        }
        this.field_70170_p.func_72869_a("splash", this.field_70165_t + (double)this.field_70146_Z.nextFloat(), this.field_70163_u + 0.7, this.field_70161_v + (double)this.field_70146_Z.nextFloat(), 0.0, 0.0, 0.0);
        if (this.field_70146_Z.nextInt(20) == 0) {
            this.field_70170_p.func_72980_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.func_145777_O(), 1.0f, 0.8f + 0.4f * this.field_70146_Z.nextFloat(), false);
        }
    }

    @Override
    public void aqua$doRegisterData() {
        this.func_70096_w().func_75682_a(ConfigHandler.MiscellaneousConfig.BoatId, (Object)0);
    }

    @Inject(method={"onUpdate"}, at={@At(value="INVOKE", target="net/minecraft/entity/item/EntityBoat.setRotation(FF)V", ordinal=1)})
    private void updateRocking(CallbackInfo ci) {
        if (this.field_70170_p.field_72995_K) {
            int i = this.getRockingTicks();
            this.rockingIntensity = i > 0 ? (this.rockingIntensity += 0.05f) : (this.rockingIntensity -= 0.1f);
            this.rockingIntensity = MathHelper.func_76131_a((float)this.rockingIntensity, (float)0.0f, (float)1.0f);
            this.prevRockingAngle = this.rockingAngle;
            this.rockingAngle = 10.0f * (float)Math.sin(0.5f * (float)this.field_70170_p.func_82737_E()) * this.rockingIntensity;
        } else {
            int k;
            if (!this.aqua$rocking) {
                this.setRockingTicks(0);
            }
            if ((k = this.getRockingTicks()) > 0) {
                this.setRockingTicks(--k);
                int j = 60 - k - 1;
                if (j > 0 && k == 0) {
                    this.setRockingTicks(0);
                    if (this.aqua$rockingDownwards) {
                        this.field_70181_x -= 0.7;
                        this.removePassengers();
                    } else {
                        this.field_70181_x = this.aqua$isPlayerRiding() ? 2.7 : 0.6;
                    }
                }
                this.aqua$rocking = false;
            }
        }
    }

    private boolean aqua$isPlayerRiding() {
        for (Entity entity : this.getPassengers()) {
            if (!EntityPlayer.class.isAssignableFrom(entity.getClass())) continue;
            return true;
        }
        return false;
    }

    public void setRockingTicks(int p_203055_1_) {
        if (!ConfigHandler.MiscellaneousConfig.bubbleColumns) {
            return;
        }
        this.field_70180_af.func_75692_b(ConfigHandler.MiscellaneousConfig.BoatId, (Object)p_203055_1_);
    }

    public int getRockingTicks() {
        if (!ConfigHandler.MiscellaneousConfig.bubbleColumns) {
            return 0;
        }
        return this.field_70180_af.func_75679_c(ConfigHandler.MiscellaneousConfig.BoatId);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public float getRockingAngle(float partialTicks) {
        if (!ConfigHandler.MiscellaneousConfig.bubbleColumns) {
            return 0.0f;
        }
        return this.prevRockingAngle + (this.rockingAngle - this.prevRockingAngle) * partialTicks;
    }

    private void removePassengers() {
        if (this.field_70153_n != null) {
            this.field_70153_n.func_70078_a(null);
            this.field_70153_n = null;
        }
    }

    private List<Entity> getPassengers() {
        ArrayList<Entity> passengers = new ArrayList<Entity>();
        if (this.field_70153_n != null) {
            passengers.add(this.field_70153_n);
        }
        return passengers;
    }
}

