/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.aquaacrobatics.client.handler;

import com.fuzs.aquaacrobatics.biome.BiomeWaterFogColors;
import com.fuzs.aquaacrobatics.config.ConfigHandler;
import com.fuzs.aquaacrobatics.entity.player.IPlayerResizeable;
import com.fuzs.aquaacrobatics.util.math.MathHelperNew;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Arrays;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.potion.Potion;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.common.BiomeDictionary;
import org.lwjgl.opengl.GL11;

public class FogHandler {
    private int targetFogColor = -1;
    private int prevFogColor = -1;
    private long fogAdjustTime = -1L;
    private static HashSet<String> worldProviderClassNames = null;

    public static void recomputeBlacklist() {
        worldProviderClassNames = new HashSet();
        worldProviderClassNames.addAll(Arrays.asList(ConfigHandler.MiscellaneousConfig.providerFogBlacklist));
    }

    private boolean shouldSkipFogOverride(World world) {
        if (!ConfigHandler.BlocksConfig.newWaterFog) {
            return true;
        }
        return worldProviderClassNames.contains(world.field_73011_w.getClass().getName());
    }

    @SubscribeEvent
    public void onRenderFogDensity(EntityViewRenderEvent.FogDensity event) {
        EntityLivingBase eventEntity = event.entity;
        if (eventEntity instanceof EntityLivingBase && eventEntity.func_70644_a(Potion.field_76440_q)) {
            return;
        }
        if (event.block.func_149688_o() == Material.field_151586_h && !this.shouldSkipFogOverride(eventEntity.field_70170_p)) {
            GL11.glFogi((int)2917, (int)2049);
            float density = 0.05f;
            if (eventEntity instanceof EntityPlayer) {
                EntityPlayer playerEntity = (EntityPlayer)eventEntity;
                float waterVision = ((IPlayerResizeable)playerEntity).getWaterVision();
                density -= waterVision * waterVision * 0.03f;
                BiomeGenBase biome = playerEntity.field_70170_p.func_72807_a((int)playerEntity.field_70165_t, (int)playerEntity.field_70161_v);
                if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
                    density += 0.005f;
                }
            }
            event.density = density;
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onRenderFogColor(EntityViewRenderEvent.FogColors event) {
        if (!ConfigHandler.BlocksConfig.newWaterColors) {
            return;
        }
        Block blockInside = event.block;
        if (event.block.func_149688_o() == Material.field_151586_h && event.entity instanceof EntityPlayer && !this.shouldSkipFogOverride(event.entity.field_70170_p)) {
            EntityPlayer playerEntity = (EntityPlayer)event.entity;
            long i = System.nanoTime() / 1000000L;
            int j = BiomeWaterFogColors.getWaterFogColorForBiome(playerEntity.field_70170_p.func_72807_a((int)playerEntity.field_70165_t, (int)playerEntity.field_70161_v));
            if (this.fogAdjustTime < 0L) {
                this.targetFogColor = j;
                this.prevFogColor = j;
                this.fogAdjustTime = i;
            }
            int k = this.targetFogColor >> 16 & 0xFF;
            int l = this.targetFogColor >> 8 & 0xFF;
            int i1 = this.targetFogColor & 0xFF;
            int j1 = this.prevFogColor >> 16 & 0xFF;
            int k1 = this.prevFogColor >> 8 & 0xFF;
            int l1 = this.prevFogColor & 0xFF;
            float f = MathHelper.func_76131_a((float)((float)(i - this.fogAdjustTime) / 5000.0f), (float)0.0f, (float)1.0f);
            float f1 = MathHelperNew.lerp(f, j1, k);
            float f2 = MathHelperNew.lerp(f, k1, l);
            float f3 = MathHelperNew.lerp(f, l1, i1);
            float fogRed = f1 / 255.0f;
            float fogGreen = f2 / 255.0f;
            float fogBlue = f3 / 255.0f;
            if (this.targetFogColor != j) {
                this.targetFogColor = j;
                this.prevFogColor = MathHelper.func_76141_d((float)f1) << 16 | MathHelper.func_76141_d((float)f2) << 8 | MathHelper.func_76141_d((float)f3);
                this.fogAdjustTime = i;
            }
            float f6 = ((IPlayerResizeable)playerEntity).getWaterVision();
            float f9 = Math.min(1.0f / fogRed, Math.min(1.0f / fogGreen, 1.0f / fogBlue));
            fogRed = fogRed * (1.0f - f6) + fogRed * f9 * f6;
            fogGreen = fogGreen * (1.0f - f6) + fogGreen * f9 * f6;
            fogBlue = fogBlue * (1.0f - f6) + fogBlue * f9 * f6;
            double blindnessFactor = 1.0;
            if (playerEntity.func_70644_a(Potion.field_76440_q)) {
                int potionDuration = playerEntity.func_70660_b(Potion.field_76440_q).func_76459_b();
                blindnessFactor = potionDuration < 20 ? (blindnessFactor *= (double)(1.0f - (float)i / 20.0f)) : 0.0;
            }
            if (blindnessFactor < 1.0) {
                if (blindnessFactor < 0.0) {
                    blindnessFactor = 0.0;
                }
                blindnessFactor *= blindnessFactor;
                fogRed = (float)((double)fogRed * blindnessFactor);
                fogGreen = (float)((double)fogGreen * blindnessFactor);
                fogBlue = (float)((double)fogBlue * blindnessFactor);
            }
            event.red = fogRed;
            event.green = fogGreen;
            event.blue = fogBlue;
        } else if (blockInside == Blocks.field_150353_l || blockInside == Blocks.field_150356_k) {
            event.red = 0.6f;
            event.green = 0.1f;
            event.blue = 0.0f;
            this.fogAdjustTime = -1L;
        } else {
            this.fogAdjustTime = -1L;
        }
    }
}

