/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.inventory.item;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.MEMonitorHandler;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.IConfigManager;
import appeng.util.ConfigManager;
import appeng.util.Platform;
import com.glodblock.github.common.storage.FluidCellInventory;
import com.glodblock.github.inventory.item.IFluidPortableCell;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class PortableFluidCellInventory
extends MEMonitorHandler<IAEFluidStack>
implements IFluidPortableCell {
    private final ItemStack target;
    private final IAEItemPowerStorage ips;
    private final int inventorySlot;

    public PortableFluidCellInventory(ItemStack is, int slot) {
        super(Objects.requireNonNull(FluidCellInventory.getCell(is, null)));
        this.ips = (IAEItemPowerStorage)is.func_77973_b();
        this.target = is;
        this.inventorySlot = slot;
    }

    public int getInventorySlot() {
        return this.inventorySlot;
    }

    public ItemStack getItemStack() {
        return this.target;
    }

    public double extractAEPower(double amt, Actionable mode, PowerMultiplier usePowerMultiplier) {
        amt = usePowerMultiplier.multiply(amt);
        if (mode == Actionable.SIMULATE) {
            return usePowerMultiplier.divide(Math.min(amt, this.ips.getAECurrentPower(this.target)));
        }
        return usePowerMultiplier.divide(this.ips.extractAEPower(this.target, amt));
    }

    public IMEMonitor<IAEItemStack> getItemInventory() {
        return null;
    }

    public IMEMonitor<IAEFluidStack> getFluidInventory() {
        return this;
    }

    public IConfigManager getConfigManager() {
        ConfigManager out = new ConfigManager((manager, settingName, newValue) -> {
            NBTTagCompound data = Platform.openNbtData((ItemStack)this.target);
            manager.writeToNBT(data);
        });
        out.registerSetting(Settings.SORT_BY, (Enum)SortOrder.NAME);
        out.registerSetting(Settings.VIEW_MODE, (Enum)ViewItems.ALL);
        out.registerSetting(Settings.SORT_DIRECTION, (Enum)SortDir.ASCENDING);
        out.readFromNBT((NBTTagCompound)Platform.openNbtData((ItemStack)this.target).func_74737_b());
        return out;
    }
}

