/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.inventory;

import appeng.api.storage.data.IAEFluidStack;
import appeng.core.AELog;
import appeng.util.Platform;
import appeng.util.item.AEFluidStack;
import com.glodblock.github.inventory.IAEFluidInventory;
import com.glodblock.github.inventory.IAEFluidTank;
import com.glodblock.github.util.Util;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;

public class AEFluidInventory
implements IAEFluidTank {
    private final IAEFluidStack[] fluids;
    private final IAEFluidInventory handler;
    private final int capacity;
    private final long capacityLong;
    public int lastIndex;

    public AEFluidInventory(IAEFluidInventory handler, int slots, int capcity) {
        this.fluids = new IAEFluidStack[slots];
        this.handler = handler;
        this.capacity = capcity;
        this.capacityLong = capcity;
    }

    public AEFluidInventory(IAEFluidInventory handler, int slots, long capcity) {
        this.fluids = new IAEFluidStack[slots];
        this.handler = handler;
        this.capacity = Integer.MAX_VALUE;
        this.capacityLong = capcity;
    }

    public AEFluidInventory(IAEFluidInventory handler, int slots) {
        this(handler, slots, Integer.MAX_VALUE);
    }

    @Override
    public void setFluidInSlot(int slot, IAEFluidStack fluid) {
        if (slot >= 0 && slot < this.getSlots()) {
            if (fluid != null && this.fluids[slot] != null && fluid.getFluidStack().isFluidEqual(this.fluids[slot].getFluidStack())) {
                if (fluid.getStackSize() != this.fluids[slot].getStackSize()) {
                    this.fluids[slot].setStackSize(Math.min(fluid.getStackSize(), (long)this.capacity));
                    this.onContentChanged(slot);
                }
            } else {
                if (fluid == null) {
                    this.fluids[slot] = null;
                } else {
                    this.fluids[slot] = fluid.copy();
                    this.fluids[slot].setStackSize(Math.min(fluid.getStackSize(), (long)this.capacity));
                }
                this.onContentChanged(slot);
            }
        }
    }

    private void onContentChanged(int slot) {
        if (this.handler != null && Platform.isServer()) {
            this.handler.onFluidInventoryChanged(this, slot);
        }
    }

    @Override
    public IAEFluidStack getFluidInSlot(int slot) {
        if (slot >= 0 && slot < this.getSlots()) {
            return this.fluids[slot];
        }
        return null;
    }

    public FluidStack getFluidStackInSlot(int slot) {
        if (this.getFluidInSlot(slot) != null) {
            return this.getFluidInSlot(slot).getFluidStack();
        }
        return null;
    }

    @Override
    public int getSlots() {
        return this.fluids.length;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        FluidTankInfo[] props = new FluidTankInfo[this.getSlots()];
        for (int i = 0; i < this.getSlots(); ++i) {
            props[i] = new FluidTankInfo((IFluidTank)new FluidTankPropertiesWrapper(i));
        }
        return props;
    }

    public int fill(int slot, FluidStack resource, boolean doFill) {
        if (resource == null || resource.amount <= 0) {
            return 0;
        }
        IAEFluidStack fluid = this.fluids[slot];
        if (fluid != null && !fluid.getFluidStack().isFluidEqual(resource)) {
            return 0;
        }
        int amountToStore = this.capacity;
        if (fluid != null) {
            amountToStore = (int)((long)amountToStore - fluid.getStackSize());
        }
        amountToStore = Math.min(amountToStore, resource.amount);
        if (doFill) {
            if (fluid == null) {
                this.setFluidInSlot(slot, (IAEFluidStack)AEFluidStack.create((Object)resource));
            } else {
                fluid.setStackSize(fluid.getStackSize() + (long)amountToStore);
                this.onContentChanged(slot);
            }
        }
        return amountToStore;
    }

    public long fill(int slot, IAEFluidStack resource, boolean doFill) {
        if (resource == null || resource.getStackSize() <= 0L) {
            return 0L;
        }
        IAEFluidStack fluid = this.fluids[slot];
        if (fluid != null && fluid.getFluid() != resource.getFluid()) {
            return 0L;
        }
        long amountToStore = this.capacityLong;
        if (fluid != null) {
            amountToStore -= fluid.getStackSize();
        }
        amountToStore = Math.min(amountToStore, resource.getStackSize());
        if (doFill) {
            if (fluid == null) {
                this.setFluidInSlot(slot, resource);
            } else {
                fluid.setStackSize(fluid.getStackSize() + amountToStore);
                this.onContentChanged(slot);
            }
        }
        return amountToStore;
    }

    public FluidStack drain(int slot, FluidStack resource, boolean doDrain) {
        IAEFluidStack fluid = this.fluids[slot];
        if (fluid == null || !fluid.getFluidStack().isFluidEqual(resource)) {
            return null;
        }
        return this.drain(slot, resource.amount, doDrain);
    }

    public FluidStack drain(int slot, int maxDrain, boolean doDrain) {
        IAEFluidStack fluid = this.fluids[slot];
        if (fluid == null || maxDrain <= 0) {
            return null;
        }
        int drained = maxDrain;
        if (fluid.getStackSize() < (long)drained) {
            drained = (int)fluid.getStackSize();
        }
        FluidStack stack = new FluidStack(fluid.getFluid(), drained);
        if (doDrain) {
            fluid.setStackSize(fluid.getStackSize() - (long)drained);
            if (fluid.getStackSize() <= 0L) {
                this.fluids[slot] = null;
            }
            this.onContentChanged(slot);
        }
        return stack;
    }

    public IAEFluidStack drain(int slot, long maxDrain, boolean doDrain) {
        IAEFluidStack fluid = this.fluids[slot];
        if (fluid == null || maxDrain <= 0L) {
            return null;
        }
        long drained = maxDrain;
        if (fluid.getStackSize() < drained) {
            drained = fluid.getStackSize();
        }
        IAEFluidStack stack = (IAEFluidStack)fluid.copy().setStackSize(drained);
        if (doDrain) {
            fluid.setStackSize(fluid.getStackSize() - drained);
            if (fluid.getStackSize() <= 0L) {
                this.fluids[slot] = null;
            }
            this.onContentChanged(slot);
        }
        return stack;
    }

    public int fill(ForgeDirection from, FluidStack fluid, boolean doFill) {
        if (fluid == null || fluid.amount <= 0) {
            return 0;
        }
        FluidStack insert = fluid.copy();
        int totalFillAmount = 0;
        for (int slot = 0; slot < this.getSlots(); ++slot) {
            int fillAmount = this.fill(slot, insert, doFill);
            totalFillAmount += fillAmount;
            insert.amount -= fillAmount;
            if (insert.amount <= 0) break;
        }
        return totalFillAmount;
    }

    public FluidStack drain(ForgeDirection from, FluidStack fluid, boolean doDrain) {
        if (fluid == null || fluid.amount <= 0) {
            return null;
        }
        FluidStack resource = fluid.copy();
        FluidStack totalDrained = null;
        for (int slot = 0; slot < this.getSlots(); ++slot) {
            FluidStack drain;
            if (!fluid.isFluidEqual(this.getFluidStackInSlot(slot)) || (drain = this.drain(slot, resource, doDrain)) == null) continue;
            if (totalDrained == null) {
                totalDrained = drain;
            } else {
                totalDrained.amount += drain.amount;
            }
            resource.amount -= drain.amount;
            if (resource.amount <= 0) break;
        }
        return totalDrained;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (maxDrain == 0) {
            return null;
        }
        FluidStack totalDrained = null;
        int toDrain = maxDrain;
        for (int slot = this.lastIndex; slot < this.getSlots(); ++slot) {
            if (this.getFluidInSlot(slot) == null) {
                if (slot != this.getSlots() - 1) continue;
                this.lastIndex = 0;
                continue;
            }
            if (totalDrained == null) {
                totalDrained = this.drain(slot, toDrain, doDrain);
                if (totalDrained != null) {
                    this.lastIndex = slot;
                    toDrain -= totalDrained.amount;
                }
            } else {
                FluidStack copy = totalDrained.copy();
                copy.amount = toDrain;
                FluidStack drain = this.drain(slot, copy, doDrain);
                if (drain != null) {
                    totalDrained.amount += drain.amount;
                    toDrain -= drain.amount;
                }
            }
            if (toDrain <= 0) break;
        }
        return totalDrained;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.fill(from, new FluidStack(fluid, 1), false) == 1;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.drain(from, new FluidStack(fluid, 1), false) != null;
    }

    public void writeToNBT(NBTTagCompound data, String name) {
        NBTTagCompound c = new NBTTagCompound();
        this.writeToNBT(c);
        data.func_74782_a(name, (NBTBase)c);
    }

    public void writeToBuf(ByteBuf data) throws IOException {
        int fluidMask = 0;
        for (int i = 0; i < this.fluids.length; ++i) {
            if (this.fluids[i] == null) continue;
            fluidMask |= 1 << i;
        }
        data.writeByte(fluidMask);
        for (IAEFluidStack fluid : this.fluids) {
            if (fluid == null) continue;
            fluid.writeToPacket(data);
        }
    }

    public boolean readFromBuf(ByteBuf data) throws IOException {
        boolean changed = false;
        byte fluidMask = data.readByte();
        for (int i = 0; i < this.fluids.length; ++i) {
            if ((fluidMask & 1 << i) != 0) {
                IAEFluidStack origFluid;
                IAEFluidStack fluid = AEFluidStack.loadFluidStackFromPacket((ByteBuf)data);
                if (fluid == null || fluid.equals(origFluid = this.fluids[i]) && fluid.getStackSize() == origFluid.getStackSize()) continue;
                this.fluids[i] = fluid;
                changed = true;
                continue;
            }
            if (this.fluids[i] == null) continue;
            this.fluids[i] = null;
            changed = true;
        }
        return changed;
    }

    private void writeToNBT(NBTTagCompound target) {
        for (int x = 0; x < this.fluids.length; ++x) {
            try {
                NBTTagCompound c = new NBTTagCompound();
                if (this.fluids[x] != null) {
                    this.fluids[x].writeToNBT(c);
                }
                target.func_74782_a("#" + x, (NBTBase)c);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void readFromNBT(NBTTagCompound data, String name) {
        NBTTagCompound c = data.func_74775_l(name);
        if (c != null) {
            this.readFromNBT(c);
        }
    }

    private void readFromNBT(NBTTagCompound target) {
        for (int x = 0; x < this.fluids.length; ++x) {
            try {
                NBTTagCompound c = target.func_74775_l("#" + x);
                if (c == null) continue;
                this.fluids[x] = Util.loadFluidStackFromNBT(c);
                continue;
            }
            catch (Exception e) {
                this.fluids[x] = null;
                AELog.debug((Throwable)e);
            }
        }
    }

    private class FluidTankPropertiesWrapper
    implements IFluidTank {
        private final int slot;

        public FluidTankPropertiesWrapper(int slot) {
            this.slot = slot;
        }

        public FluidStack getFluid() {
            return AEFluidInventory.this.fluids[this.slot] == null ? null : AEFluidInventory.this.fluids[this.slot].getFluidStack();
        }

        public int getFluidAmount() {
            return this.getFluid() == null ? 0 : this.getFluid().amount;
        }

        public int getCapacity() {
            return AEFluidInventory.this.capacity;
        }

        public FluidTankInfo getInfo() {
            return null;
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (resource == null || this.getFluid() != null && !resource.isFluidEqual(this.getFluid())) {
                return 0;
            }
            int acc = 0;
            if (this.getFluid() == null) {
                acc = Math.min(resource.amount, this.getCapacity());
            }
            if (this.getFluid() != null) {
                acc = Math.max(resource.amount, this.getCapacity() - this.getFluid().amount);
            }
            if (doFill) {
                if (this.getFluid() == null) {
                    AEFluidInventory.this.setFluidInSlot(this.slot, (IAEFluidStack)AEFluidStack.create((Object)new FluidStack(resource.getFluid(), acc)));
                } else {
                    this.getFluid().amount += acc;
                }
            }
            return acc;
        }

        public FluidStack drain(int maxDrain, boolean doDrain) {
            int amt;
            if (this.getFluid() == null) {
                return null;
            }
            FluidStack remove = new FluidStack(this.getFluid().getFluid(), 1);
            remove.amount = amt = Math.min(maxDrain, this.getFluid().amount);
            if (doDrain) {
                if (amt == this.getFluid().amount) {
                    AEFluidInventory.this.setFluidInSlot(this.slot, null);
                } else {
                    this.getFluid().amount -= amt;
                }
            }
            return remove;
        }
    }
}

