/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.common.tile;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.implementations.IPowerChannelState;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingJob;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.crafting.ICraftingRequester;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.events.MENetworkBootingStatusChange;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.core.AELog;
import appeng.me.GridAccessException;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.tile.grid.AENetworkTile;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.SettingsFrom;
import appeng.util.item.AEItemStack;
import com.glodblock.github.api.registries.ILevelViewable;
import com.glodblock.github.api.registries.LevelItemInfo;
import com.glodblock.github.api.registries.LevelState;
import com.glodblock.github.common.Config;
import com.glodblock.github.common.item.ItemFluidDrop;
import com.glodblock.github.crossmod.thaumcraft.ThaumicEnergisticsCrafting;
import com.glodblock.github.inventory.AeItemStackHandler;
import com.glodblock.github.inventory.AeStackInventory;
import com.glodblock.github.util.ModAndClassUtil;
import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.stream.Stream;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileLevelMaintainer
extends AENetworkTile
implements IAEAppEngInventory,
IGridTickable,
ICraftingRequester,
IPowerChannelState,
ILevelViewable {
    public static final int REQ_COUNT = 5;
    public static final String NBT_REQUESTS = "Requests";
    public static final String NBT_STACK = "stack";
    public static final String NBT_QUANTITY = "quantity";
    public static final String NBT_BATCH = "batch";
    public static final String NBT_ENABLE = "enable";
    public static final String NBT_STATE = "state";
    public static final String NBT_LINK = "link";
    public final RequestInfo[] requests = new RequestInfo[5];
    private final LevelMaintainerInventory inventory = new LevelMaintainerInventory(this.requests, this);
    private int firstRequest = 0;
    private final BaseActionSource source;
    private final IInventory inv = new AeItemStackHandler(this.inventory);
    private boolean isPowered = false;

    public TileLevelMaintainer() {
        this.getProxy().setIdlePowerUsage(1.0);
        this.getProxy().setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
        this.source = new MachineSource((IActionHost)this);
    }

    public AeStackInventory<IAEItemStack> getRequestSlots() {
        return this.inventory;
    }

    public ImmutableSet<ICraftingLink> getRequestedJobs() {
        return ImmutableSet.copyOf(Arrays.stream(this.requests).filter(Objects::nonNull).map(info -> ((RequestInfo)info).link).filter(Objects::nonNull).iterator());
    }

    public IAEItemStack injectCraftedItems(ICraftingLink link, IAEItemStack items, Actionable mode) {
        int idx = this.getRequestIndexByLink(link);
        try {
            double power;
            IEnergyGrid energy;
            if (this.getProxy().isActive() && (energy = this.getProxy().getEnergy()).extractAEPower(power = Math.ceil(ItemFluidDrop.isFluidStack(items) ? (double)items.getStackSize() / 1000.0 : (double)items.getStackSize()), mode, PowerMultiplier.CONFIG) > power - 0.01) {
                if (ItemFluidDrop.isFluidStack(items)) {
                    IAEFluidStack notInjectedItems = (IAEFluidStack)this.getProxy().getStorage().getFluidInventory().injectItems((IAEStack)ItemFluidDrop.getAeFluidStack(items), mode, this.source);
                    if (notInjectedItems != null) {
                        items.setStackSize(notInjectedItems.getStackSize());
                        if (idx != -1) {
                            this.updateState(idx, LevelState.Export);
                        }
                        return items;
                    }
                    return null;
                }
                return (IAEItemStack)this.getProxy().getStorage().getItemInventory().injectItems((IAEStack)items, mode, this.source);
            }
        }
        catch (GridAccessException e) {
            AELog.debug((Throwable)e);
        }
        return items;
    }

    public void jobStateChange(ICraftingLink link) {
        for (int i = 0; i < 5; ++i) {
            ICraftingLink prevLink;
            if (this.requests[i] == null || link == null || (prevLink = this.requests[i].link) == null || !prevLink.getCraftingID().equals(link.getCraftingID())) continue;
            this.updateLink(i, null);
        }
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(Config.levelMaintainerMinTicks, Config.levelMaintainerMaxTicks, false, true);
    }

    public TickRateModulation tickingRequest(IGridNode node, int TicksSinceLastCall) {
        return this.canDoBusWork() ? this.doWork() : TickRateModulation.IDLE;
    }

    private TickRateModulation doWork() {
        block22: {
            if (!this.getProxy().isActive() || !this.canDoBusWork()) {
                return TickRateModulation.IDLE;
            }
            try {
                ICraftingGrid craftingGrid = this.getProxy().getCrafting();
                IGrid grid = this.getProxy().getGrid();
                IItemList invItems = this.getProxy().getStorage().getItemInventory().getStorageList();
                IItemList invFluid = this.getProxy().getStorage().getFluidInventory().getStorageList();
                boolean allBusy = true;
                for (ICraftingCPU cpu : craftingGrid.getCpus()) {
                    if (cpu.isBusy()) continue;
                    allBusy = false;
                    break;
                }
                ICraftingJob jobToSubmit = null;
                int jobToSubmitIdx = -1;
                IAEItemStack itemToBegin = null;
                int itemToBeginIdx = -1;
                for (int j = 0; j < 5; ++j) {
                    boolean shouldCraft;
                    long stackSize;
                    int i = (this.firstRequest + j) % 5;
                    if (this.requests[i] == null) continue;
                    long quantity = this.requests[i].quantity;
                    long batchSize = this.requests[i].batchSize;
                    boolean isEnable = this.requests[i].enable;
                    if (!isEnable || quantity == 0L || batchSize == 0L) {
                        this.updateState(i, LevelState.None);
                        continue;
                    }
                    IAEItemStack craftItem = this.requests[i].itemStack.copy();
                    craftItem.setStackSize(batchSize);
                    if (ModAndClassUtil.ThE && ThaumicEnergisticsCrafting.isAspectStack(craftItem.getItemStack())) {
                        craftItem = ThaumicEnergisticsCrafting.convertAspectStack(craftItem);
                    }
                    IAEItemStack aeItem = (IAEItemStack)invItems.findPrecise((IAEStack)craftItem);
                    if (craftItem.getItem() instanceof ItemFluidDrop) {
                        IAEFluidStack ifs = (IAEFluidStack)invFluid.findPrecise((IAEStack)ItemFluidDrop.getAeFluidStack(craftItem));
                        stackSize = ifs == null ? 0L : ifs.getStackSize();
                    } else {
                        long l = stackSize = aeItem == null ? 0L : aeItem.getStackSize();
                    }
                    if (ModAndClassUtil.ThE && aeItem != null && ThaumicEnergisticsCrafting.isAspectStack(aeItem.getItemStack())) {
                        stackSize = ThaumicEnergisticsCrafting.getEssentiaAmount(aeItem, grid);
                    }
                    boolean isDone = this.isDone(i);
                    boolean isCraftable = aeItem != null && aeItem.isCraftable();
                    boolean bl = shouldCraft = isCraftable && stackSize < quantity;
                    if (isDone) {
                        if (this.requests[i].state != LevelState.Idle) {
                            this.updateState(i, LevelState.Idle);
                        }
                        if (this.requests[i].link != null) {
                            this.updateLink(i, null);
                        }
                        if (!isCraftable) {
                            this.updateState(i, LevelState.NotFound);
                        }
                    }
                    if (allBusy || !isDone || !shouldCraft || craftingGrid.canEmitFor(craftItem) || craftingGrid.isRequesting(craftItem)) continue;
                    Future jobTask = this.requests[i].job;
                    if (jobTask == null) {
                        if (itemToBegin != null) continue;
                        itemToBegin = craftItem;
                        itemToBeginIdx = i;
                        continue;
                    }
                    if (!jobTask.isDone()) continue;
                    this.updateState(i, LevelState.Craft);
                    try {
                        ICraftingJob job = (ICraftingJob)jobTask.get();
                        if (job != null) {
                            if (jobToSubmit != null) continue;
                            jobToSubmit = job;
                            jobToSubmitIdx = i;
                            continue;
                        }
                        this.updateState(i, LevelState.Error);
                        continue;
                    }
                    catch (Exception ignored) {
                        this.updateState(i, LevelState.Error);
                    }
                }
                if (jobToSubmit != null) {
                    ICraftingLink link = craftingGrid.submitJob(jobToSubmit, (ICraftingRequester)this, null, false, this.source);
                    this.requests[jobToSubmitIdx].job = null;
                    if (link != null) {
                        this.updateState(jobToSubmitIdx, LevelState.Craft);
                        this.updateLink(jobToSubmitIdx, link);
                    } else {
                        this.updateState(jobToSubmitIdx, LevelState.CantCraft);
                    }
                    break block22;
                }
                if (itemToBegin != null) {
                    this.requests[itemToBeginIdx].job = craftingGrid.beginCraftingJob(this.func_145831_w(), grid, this.source, itemToBegin, null);
                    this.updateState(itemToBeginIdx, LevelState.Craft);
                    this.firstRequest = (this.firstRequest + 1) % 5;
                    break block22;
                }
                return TickRateModulation.IDLE;
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        return TickRateModulation.SAME;
    }

    public void saveChanges() {
        super.saveChanges();
    }

    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        try {
            this.getProxy().getTick().alertDevice(this.getProxy().getNode());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    protected boolean canDoBusWork() {
        return this.getProxy().isActive();
    }

    public boolean isPowered() {
        return this.isPowered;
    }

    public boolean isActive() {
        return this.isPowered;
    }

    public IInventory getInventory() {
        return this.inv;
    }

    public IInventory getInventoryByName(String name) {
        if (Objects.equals(name, "config")) {
            return new AeItemStackHandler(this.inventory);
        }
        return null;
    }

    @Override
    public LevelItemInfo[] getLevelItemInfoList() {
        return (LevelItemInfo[])Arrays.stream(this.requests).map(request -> {
            if (request == null) {
                return null;
            }
            return new LevelItemInfo(((RequestInfo)request).itemStack.getItemStack(), request.getQuantity(), request.getBatchSize(), request.getState());
        }).toArray(LevelItemInfo[]::new);
    }

    public void updateQuantity(int idx, long size) {
        if (this.requests[idx] == null) {
            return;
        }
        this.requests[idx].quantity = size > 0L ? size : 0L;
        this.checkState(idx);
        this.saveChanges();
    }

    public void updateBatchSize(int idx, long size) {
        if (this.requests[idx] == null) {
            return;
        }
        this.requests[idx].batchSize = size > 0L ? size : 0L;
        this.checkState(idx);
        this.saveChanges();
    }

    public void updateStatus(int idx, boolean enable) {
        if (this.requests[idx] == null) {
            return;
        }
        this.requests[idx].enable = enable;
        this.checkState(idx);
        this.saveChanges();
    }

    private void updateState(int idx, @NotNull LevelState state) {
        if (this.requests[idx] == null) {
            return;
        }
        this.requests[idx].state = state;
        this.saveChanges();
    }

    public void updateStack(int idx, @Nullable ItemStack stack) {
        if (stack == null) {
            this.requests[idx] = null;
        } else {
            stack = this.removeRecursion(stack);
            this.requests[idx] = new RequestInfo(stack, this);
        }
        this.saveChanges();
    }

    private void updateLink(int idx, @Nullable ICraftingLink link) {
        if (this.requests[idx] == null) {
            return;
        }
        this.requests[idx].link = link;
        this.saveChanges();
    }

    private void checkState(int idx) {
        if (!this.requests[idx].enable || this.requests[idx].quantity == 0L || this.requests[idx].batchSize == 0L) {
            this.updateState(idx, LevelState.None);
        } else if (!this.isDone(idx)) {
            this.updateState(idx, LevelState.Craft);
        } else {
            this.updateState(idx, LevelState.Idle);
        }
    }

    public boolean isDone(int i) {
        if (this.requests[i] == null) {
            return true;
        }
        ICraftingLink link = this.requests[i].link;
        return link == null || link.isDone() || link.isCanceled();
    }

    private int getRequestIndexByLink(ICraftingLink targetLink) {
        for (int i = 0; i < 5; ++i) {
            ICraftingLink link;
            if (this.requests[i] == null || targetLink == null || (link = this.requests[i].link) == null || !link.getCraftingID().equals(targetLink.getCraftingID())) continue;
            return i;
        }
        return -1;
    }

    @TileEvent(value=TileEventType.WORLD_NBT_WRITE)
    public void writeToNBTEvent(NBTTagCompound data) {
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < 5; ++i) {
            if (this.requests[i] != null) {
                tagList.func_74742_a((NBTBase)this.requests[i].writeToNBT(true));
                continue;
            }
            tagList.func_74742_a((NBTBase)new NBTTagCompound());
        }
        data.func_74782_a(NBT_REQUESTS, (NBTBase)tagList);
    }

    @TileEvent(value=TileEventType.WORLD_NBT_READ)
    public void readFromNBTEvent(NBTTagCompound data) {
        if (data.func_74764_b(NBT_REQUESTS)) {
            NBTTagList tagList = data.func_150295_c(NBT_REQUESTS, 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound tag = tagList.func_150305_b(i);
                if (tag == null || !tag.func_74764_b(NBT_STACK)) {
                    this.requests[i] = null;
                    continue;
                }
                if (this.requests[i] == null) {
                    try {
                        this.requests[i] = new RequestInfo(tag, this);
                    }
                    catch (Exception ignored) {
                        this.requests[i] = null;
                    }
                    continue;
                }
                this.requests[i].loadFromNBT(tag);
            }
        } else if (data.func_74764_b("RequestStacks")) {
            NBTTagList stacksTag = data.func_74775_l("RequestStacks").func_150295_c("Contents", 10);
            IAEItemStack[] stacks = new IAEItemStack[5];
            for (int i = 0; i < 5; ++i) {
                ItemStack itemstack;
                NBTTagCompound stackTag = stacksTag.func_150305_b(i);
                if (stackTag == null) continue;
                stacks[i] = AEItemStack.loadItemStackFromNBT((NBTTagCompound)stackTag);
                if (stacks[i] == null || !(itemstack = stacks[i].getItemStack()).func_77942_o()) continue;
                NBTTagCompound itemTag = itemstack.func_77978_p();
                ItemStack craftStack = ItemStack.func_77949_a((NBTTagCompound)itemTag.func_74775_l("Stack"));
                if ((craftStack = this.removeRecursion(craftStack)) == null) continue;
                this.requests[i] = new RequestInfo(craftStack, this);
                if (itemTag.func_74764_b("Enable")) {
                    this.requests[i].enable = itemTag.func_74767_n("Enable");
                }
                if (itemTag.func_74764_b("Quantity")) {
                    this.requests[i].quantity = itemTag.func_74763_f("Quantity");
                }
                if (!itemTag.func_74764_b("Batch")) continue;
                this.requests[i].batchSize = itemTag.func_74763_f("Batch");
            }
        } else {
            int i;
            long[] batches = new long[5];
            long[] quantyties = new long[5];
            ItemStack[] stacks = new ItemStack[5];
            NBTTagList batchTag = data.func_74775_l("Batch").func_150295_c("Contents", 10);
            for (int i2 = 0; i2 < 5; ++i2) {
                NBTTagCompound stackTag = batchTag.func_150305_b(i2);
                IAEItemStack stack = AEItemStack.loadItemStackFromNBT((NBTTagCompound)stackTag);
                batches[i2] = stack != null ? stack.getStackSize() : 0L;
            }
            NBTTagList quantityTag = data.func_74775_l("Count").func_150295_c("Contents", 10);
            for (int i3 = 0; i3 < 5; ++i3) {
                NBTTagCompound stackTag = quantityTag.func_150305_b(i3);
                IAEItemStack stack = AEItemStack.loadItemStackFromNBT((NBTTagCompound)stackTag);
                quantyties[i3] = stack != null ? stack.getStackSize() : 0L;
            }
            NBTTagList inventoryTag = data.func_74775_l("Count").func_150295_c("Contents", 10);
            for (i = 0; i < 5; ++i) {
                NBTTagCompound stackTag = inventoryTag.func_150305_b(i);
                IAEItemStack stack = AEItemStack.loadItemStackFromNBT((NBTTagCompound)stackTag);
                stacks[i] = stack != null ? stack.getItemStack() : null;
            }
            for (i = 0; i < 5; ++i) {
                if (stacks[i] == null) continue;
                this.requests[i] = new RequestInfo(stacks[i], this);
                this.requests[i].batchSize = batches[i];
                this.requests[i].quantity = quantyties[i];
            }
        }
    }

    private ItemStack removeRecursion(ItemStack itemStack) {
        if (itemStack == null || !itemStack.func_77942_o()) {
            return itemStack;
        }
        NBTTagCompound tag = itemStack.func_77978_p();
        if (tag.func_74764_b("Stack") && tag.func_74764_b("Quantity")) {
            return this.removeRecursion(ItemStack.func_77949_a((NBTTagCompound)itemStack.func_77978_p().func_74775_l("Stack")));
        }
        return itemStack;
    }

    @TileEvent(value=TileEventType.NETWORK_READ)
    public boolean readFromStream(ByteBuf data) {
        boolean oldPower = this.isPowered;
        this.isPowered = data.readBoolean();
        return this.isPowered != oldPower;
    }

    @TileEvent(value=TileEventType.NETWORK_WRITE)
    public void writeToStream(ByteBuf data) {
        data.writeBoolean(this.isActive());
    }

    public void uploadSettings(SettingsFrom from, NBTTagCompound compound) {
        super.uploadSettings(from, compound);
        NBTTagList tagList = compound.func_150295_c(NBT_REQUESTS, 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            if (tag == null || !tag.func_74764_b(NBT_STACK)) {
                this.requests[i] = null;
                continue;
            }
            try {
                this.requests[i] = new RequestInfo(tag, this);
                this.requests[i].state = LevelState.None;
                continue;
            }
            catch (Exception ignored) {
                this.requests[i] = null;
            }
        }
        this.saveChanges();
    }

    public NBTTagCompound downloadSettings(SettingsFrom from) {
        NBTTagCompound compound = super.downloadSettings(from);
        compound = compound == null ? new NBTTagCompound() : compound;
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < 5; ++i) {
            if (this.requests[i] != null) {
                tagList.func_74742_a((NBTBase)this.requests[i].writeToNBT(false));
                continue;
            }
            tagList.func_74742_a((NBTBase)new NBTTagCompound());
        }
        compound.func_74782_a(NBT_REQUESTS, (NBTBase)tagList);
        return compound;
    }

    @MENetworkEventSubscribe
    public void stateChange(MENetworkPowerStatusChange p) {
        this.updatePowerState();
    }

    @MENetworkEventSubscribe
    public final void bootingRender(MENetworkBootingStatusChange c) {
        this.updatePowerState();
    }

    private void updatePowerState() {
        boolean newState = false;
        try {
            newState = this.getProxy().isActive() && this.getProxy().getEnergy().extractAEPower(1.0, Actionable.SIMULATE, PowerMultiplier.CONFIG) > 1.0E-4;
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        if (newState != this.isPowered) {
            this.isPowered = newState;
            this.markForUpdate();
        }
    }

    @Override
    @NotNull
    public TileEntity getTile() {
        return this;
    }

    @Override
    public ForgeDirection getSide() {
        return ForgeDirection.UNKNOWN;
    }

    @Override
    public int rowSize() {
        return 5;
    }

    public static class RequestInfo {
        private final TileLevelMaintainer tile;
        @NotNull
        private IAEItemStack itemStack;
        private long quantity;
        private long batchSize;
        private boolean enable;
        private LevelState state;
        @Nullable
        private Future<ICraftingJob> job;
        @Nullable
        private ICraftingLink link;

        public RequestInfo(@NotNull ItemStack stack, TileLevelMaintainer tile) {
            this.tile = tile;
            this.itemStack = AEItemStack.create((ItemStack)stack);
            this.quantity = 0L;
            this.batchSize = 0L;
            this.enable = false;
            this.state = LevelState.None;
            this.link = null;
            this.job = null;
        }

        public RequestInfo(NBTTagCompound tag, TileLevelMaintainer tile) throws IllegalArgumentException {
            this.tile = tile;
            this.itemStack = AEItemStack.loadItemStackFromNBT((NBTTagCompound)tag.func_74775_l(TileLevelMaintainer.NBT_STACK));
            if (this.itemStack == null) {
                throw new IllegalArgumentException("ItemStack cannot be null!");
            }
            this.quantity = tag.func_74763_f(TileLevelMaintainer.NBT_QUANTITY);
            this.batchSize = tag.func_74763_f(TileLevelMaintainer.NBT_BATCH);
            this.enable = tag.func_74767_n(TileLevelMaintainer.NBT_ENABLE);
            this.state = LevelState.values()[tag.func_74762_e(TileLevelMaintainer.NBT_STATE)];
            if (tag.func_74764_b(TileLevelMaintainer.NBT_LINK)) {
                try {
                    this.link = AEApi.instance().storage().loadCraftingLink(tag.func_74775_l(TileLevelMaintainer.NBT_LINK), (ICraftingRequester)this.tile);
                }
                catch (Exception ignored) {
                    this.link = null;
                }
            }
            this.job = null;
        }

        public void loadFromNBT(NBTTagCompound tag) {
            this.itemStack = AEItemStack.loadItemStackFromNBT((NBTTagCompound)tag.func_74775_l(TileLevelMaintainer.NBT_STACK));
            this.quantity = tag.func_74763_f(TileLevelMaintainer.NBT_QUANTITY);
            this.batchSize = tag.func_74763_f(TileLevelMaintainer.NBT_BATCH);
            this.enable = tag.func_74767_n(TileLevelMaintainer.NBT_ENABLE);
            this.state = LevelState.values()[tag.func_74762_e(TileLevelMaintainer.NBT_STATE)];
            if (tag.func_74764_b(TileLevelMaintainer.NBT_LINK)) {
                try {
                    this.link = AEApi.instance().storage().loadCraftingLink(tag.func_74775_l(TileLevelMaintainer.NBT_LINK), (ICraftingRequester)this.tile);
                }
                catch (Exception ignored) {
                    this.link = null;
                }
            }
        }

        public NBTTagCompound writeToNBT(boolean includeLink) {
            NBTTagCompound tag = new NBTTagCompound();
            NBTTagCompound stackTag = new NBTTagCompound();
            this.itemStack.writeToNBT(stackTag);
            tag.func_74782_a(TileLevelMaintainer.NBT_STACK, (NBTBase)stackTag);
            tag.func_74772_a(TileLevelMaintainer.NBT_QUANTITY, this.quantity);
            tag.func_74772_a(TileLevelMaintainer.NBT_BATCH, this.batchSize);
            tag.func_74757_a(TileLevelMaintainer.NBT_ENABLE, this.enable);
            tag.func_74768_a(TileLevelMaintainer.NBT_STATE, this.state.ordinal());
            if (this.link != null && includeLink) {
                NBTTagCompound linkTag = new NBTTagCompound();
                this.link.writeToNBT(linkTag);
                tag.func_74782_a(TileLevelMaintainer.NBT_LINK, (NBTBase)linkTag);
            }
            return tag;
        }

        public IAEItemStack getAEItemStack() {
            return this.itemStack;
        }

        public long getQuantity() {
            return this.quantity;
        }

        public long getBatchSize() {
            return this.batchSize;
        }

        public boolean isEnable() {
            return this.enable;
        }

        public LevelState getState() {
            return this.state;
        }
    }

    private static class LevelMaintainerInventory
    implements AeStackInventory<IAEItemStack> {
        private final RequestInfo[] requests;
        private final TileLevelMaintainer tile;

        private LevelMaintainerInventory(RequestInfo[] requests, TileLevelMaintainer tile) {
            this.requests = requests;
            this.tile = tile;
        }

        @Override
        @NotNull
        public Iterator<IAEItemStack> iterator() {
            return Arrays.stream(this.requests).map(info -> info != null ? ((RequestInfo)info).itemStack : null).iterator();
        }

        @Override
        public int getSlotCount() {
            return this.requests.length;
        }

        @Override
        @Nullable
        public IAEItemStack getStack(int slot) {
            return this.requests[slot] != null ? this.requests[slot].itemStack : null;
        }

        @Override
        public void setStack(int slot, @Nullable IAEItemStack stack) {
            if (stack == null) {
                this.tile.updateStack(slot, null);
            } else {
                this.tile.updateStack(slot, stack.getItemStack());
            }
        }

        @Override
        public Stream<IAEItemStack> stream() {
            return Arrays.stream(this.requests).map(info -> info != null ? ((RequestInfo)info).itemStack : null);
        }
    }
}

