/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.common.parts;

import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.InsertionMode;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.RedstoneMode;
import appeng.api.config.SchedulingMode;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.config.YesNo;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.crafting.ICraftingRequester;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IBoxProvider;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.client.texture.CableBusTextures;
import appeng.core.AELog;
import appeng.helpers.MultiCraftingTracker;
import appeng.me.GridAccessException;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.item.AEFluidStack;
import com.glodblock.github.client.textures.FCPartsTexture;
import com.glodblock.github.common.item.ItemFluidDrop;
import com.glodblock.github.common.item.ItemFluidPacket;
import com.glodblock.github.common.parts.base.FCSharedFluidBus;
import com.google.common.collect.ImmutableSet;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.IFluidHandler;

public class PartFluidExportBus
extends FCSharedFluidBus
implements ICraftingRequester {
    private final BaseActionSource source;
    private final MultiCraftingTracker craftingTracker = new MultiCraftingTracker((ICraftingRequester)this, 9);
    private int nextSlot = 0;
    private long fluidToSend = 1000L;
    private boolean didSomething;

    public PartFluidExportBus(ItemStack is) {
        super(is);
        this.getConfigManager().registerSetting(Settings.REDSTONE_CONTROLLED, (Enum)RedstoneMode.IGNORE);
        this.getConfigManager().registerSetting(Settings.FUZZY_MODE, (Enum)FuzzyMode.IGNORE_ALL);
        this.getConfigManager().registerSetting(Settings.CRAFT_ONLY, (Enum)YesNo.NO);
        this.getConfigManager().registerSetting(Settings.SCHEDULING_MODE, (Enum)SchedulingMode.DEFAULT);
        this.source = new MachineSource((IActionHost)this);
    }

    @Override
    public IIcon getFaceIcon() {
        return FCPartsTexture.PartFluidExportBus.getIcon();
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(5, 40, this.isSleeping(), false);
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        return this.canDoBusWork() ? this.doBusWork() : TickRateModulation.IDLE;
    }

    @Override
    protected boolean canDoBusWork() {
        return this.getProxy().isActive();
    }

    private int getStartingSlot(SchedulingMode schedulingMode, int x) {
        if (schedulingMode == SchedulingMode.RANDOM) {
            return Platform.getRandom().nextInt(this.availableSlots());
        }
        if (schedulingMode == SchedulingMode.ROUNDROBIN) {
            return (this.nextSlot + x) % this.availableSlots();
        }
        return x;
    }

    private int availableSlots() {
        return Math.min(1 + this.getInstalledUpgrades(Upgrades.CAPACITY) * 4, this.getInv().func_70302_i_());
    }

    private IInventory getInv() {
        return this.getInventoryByName("config");
    }

    @Override
    protected TickRateModulation doBusWork() {
        InventoryAdaptor destination;
        if (!this.canDoBusWork()) {
            return TickRateModulation.IDLE;
        }
        this.didSomething = false;
        this.fluidToSend = this.calculateAmountToSend();
        TileEntity te = this.getConnectedTE();
        if (te instanceof IFluidHandler && (destination = this.getHandler(te)) != null) {
            try {
                int i;
                ICraftingGrid cg = this.getProxy().getCrafting();
                IFluidHandler fh = (IFluidHandler)te;
                IMEMonitor inv = this.getProxy().getStorage().getFluidInventory();
                for (i = 0; i < this.availableSlots() && this.fluidToSend > 0L; ++i) {
                    int slotToExport = this.getStartingSlot(this.getSchedulingMode(), i);
                    AEFluidStack fluid = AEFluidStack.create((Object)ItemFluidPacket.getFluidStack(this.getInv().func_70301_a(slotToExport)));
                    if (fluid == null) continue;
                    fluid.setStackSize((long)this.calculateAmountToSend());
                    if (this.craftOnly()) {
                        this.didSomething = this.craftingTracker.handleCrafting(i, fluid.getStackSize(), ItemFluidDrop.newAeStack((IAEFluidStack)fluid), destination, this.getTile().func_145831_w(), this.getProxy().getGrid(), cg, this.source);
                        continue;
                    }
                    IAEFluidStack toPush = fluid.copy();
                    int amtToInsert = fh.fill(this.getSide().getOpposite(), toPush.getFluidStack(), false);
                    toPush.setStackSize((long)amtToInsert);
                    IAEFluidStack real = (IAEFluidStack)inv.extractItems((IAEStack)toPush, Actionable.MODULATE, this.source);
                    if (real != null) {
                        int realInserted = fh.fill(this.getSide().getOpposite(), real.getFluidStack(), true);
                        if ((long)realInserted < real.getStackSize()) {
                            fluid.setStackSize(real.getStackSize() - (long)realInserted);
                            inv.injectItems((IAEStack)fluid, Actionable.MODULATE, this.source);
                        }
                        this.fluidToSend -= (long)realInserted;
                        this.didSomething = true;
                        continue;
                    }
                    if (!this.isCraftingEnabled()) continue;
                    this.didSomething = this.craftingTracker.handleCrafting(i, fluid.getStackSize(), ItemFluidDrop.newAeStack((IAEFluidStack)fluid), destination, this.getTile().func_145831_w(), this.getProxy().getGrid(), cg, this.source);
                }
                this.updateSchedulingMode(this.getSchedulingMode(), i);
                return this.didSomething ? TickRateModulation.FASTER : TickRateModulation.SLOWER;
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        return TickRateModulation.SLEEP;
    }

    private void updateSchedulingMode(SchedulingMode schedulingMode, int x) {
        if (schedulingMode == SchedulingMode.ROUNDROBIN) {
            this.nextSlot = (this.nextSlot + x) % this.availableSlots();
        }
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(4.0, 4.0, 12.0, 12.0, 12.0, 14.0);
        bch.addBox(5.0, 5.0, 14.0, 11.0, 11.0, 15.0);
        bch.addBox(6.0, 6.0, 15.0, 10.0, 10.0, 16.0);
        bch.addBox(6.0, 6.0, 11.0, 10.0, 10.0, 12.0);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper rh, RenderBlocks renderer) {
        rh.setTexture(CableBusTextures.PartExportSides.getIcon(), CableBusTextures.PartExportSides.getIcon(), CableBusTextures.PartMonitorBack.getIcon(), this.getFaceIcon(), CableBusTextures.PartExportSides.getIcon(), CableBusTextures.PartExportSides.getIcon());
        rh.setBounds(4.0f, 4.0f, 12.0f, 12.0f, 12.0f, 14.0f);
        rh.renderInventoryBox(renderer);
        rh.setBounds(5.0f, 5.0f, 14.0f, 11.0f, 11.0f, 15.0f);
        rh.renderInventoryBox(renderer);
        rh.setBounds(6.0f, 6.0f, 15.0f, 10.0f, 10.0f, 16.0f);
        rh.renderInventoryBox(renderer);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int x, int y, int z, IPartRenderHelper rh, RenderBlocks renderer) {
        this.setRenderCache(rh.useSimplifiedRendering(x, y, z, (IBoxProvider)this, this.getRenderCache()));
        rh.setTexture(CableBusTextures.PartExportSides.getIcon(), CableBusTextures.PartExportSides.getIcon(), CableBusTextures.PartMonitorBack.getIcon(), this.getFaceIcon(), CableBusTextures.PartExportSides.getIcon(), CableBusTextures.PartExportSides.getIcon());
        rh.setBounds(4.0f, 4.0f, 12.0f, 12.0f, 12.0f, 14.0f);
        rh.renderBlock(x, y, z, renderer);
        rh.setBounds(5.0f, 5.0f, 14.0f, 11.0f, 11.0f, 15.0f);
        rh.renderBlock(x, y, z, renderer);
        rh.setBounds(6.0f, 6.0f, 15.0f, 10.0f, 10.0f, 16.0f);
        rh.renderBlock(x, y, z, renderer);
        rh.setTexture(CableBusTextures.PartMonitorSidesStatus.getIcon(), CableBusTextures.PartMonitorSidesStatus.getIcon(), CableBusTextures.PartMonitorBack.getIcon(), this.getFaceIcon(), CableBusTextures.PartMonitorSidesStatus.getIcon(), CableBusTextures.PartMonitorSidesStatus.getIcon());
        rh.setBounds(6.0f, 6.0f, 11.0f, 10.0f, 10.0f, 12.0f);
        rh.renderBlock(x, y, z, renderer);
        this.renderLights(x, y, z, rh, renderer);
    }

    public RedstoneMode getRSMode() {
        return (RedstoneMode)this.getConfigManager().getSetting(Settings.REDSTONE_CONTROLLED);
    }

    public SchedulingMode getSchedulingMode() {
        return (SchedulingMode)this.getConfigManager().getSetting(Settings.SCHEDULING_MODE);
    }

    private boolean craftOnly() {
        return this.getConfigManager().getSetting(Settings.CRAFT_ONLY) == YesNo.YES;
    }

    private boolean isCraftingEnabled() {
        return this.getInstalledUpgrades(Upgrades.CRAFTING) > 0;
    }

    public ImmutableSet<ICraftingLink> getRequestedJobs() {
        return this.craftingTracker.getRequestedJobs();
    }

    protected InventoryAdaptor getHandler(TileEntity target) {
        return target != null ? InventoryAdaptor.getAdaptor((Object)target, (ForgeDirection)this.getSide().getOpposite()) : null;
    }

    public IAEItemStack injectCraftedItems(ICraftingLink link, IAEItemStack items, Actionable mode) {
        InventoryAdaptor d = this.getHandler(this.getConnectedTE());
        try {
            double power;
            IEnergyGrid energy;
            if (d != null && this.getProxy().isActive() && (energy = this.getProxy().getEnergy()).extractAEPower(power = Math.ceil((double)items.getStackSize() / 1000.0), mode, PowerMultiplier.CONFIG) > power - 0.01) {
                IAEItemStack remaining = mode == Actionable.SIMULATE ? Platform.stackConvert((IAEStack)d.simulateAddStack(Platform.convertStack((IAEItemStack)items), InsertionMode.DEFAULT)) : Platform.stackConvert((IAEStack)d.addStack(Platform.convertStack((IAEItemStack)items), InsertionMode.DEFAULT));
                return remaining;
            }
        }
        catch (GridAccessException e) {
            AELog.debug((Throwable)e);
        }
        return items;
    }

    public void jobStateChange(ICraftingLink link) {
        this.craftingTracker.jobStateChange(link);
    }
}

