/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.common.item;

import com.glodblock.github.common.item.BaseItemBlockContainer;
import com.glodblock.github.common.tile.TileCertusQuartzTank;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class ItemCertusQuartzTank
extends BaseItemBlockContainer
implements IFluidContainerItem {
    private final int capacity = 32000;

    public ItemCertusQuartzTank(Block block) {
        super(block);
    }

    public String func_77653_i(ItemStack stack) {
        FluidStack fluid = this.getFluid(stack);
        if (fluid == null) {
            return StatCollector.func_74838_a((String)"tile.certus_quartz_tank_empty.name");
        }
        return StatCollector.func_74837_a((String)"tile.certus_quartz_tank.name", (Object[])new Object[]{fluid.getLocalizedName()});
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        if (container.field_77994_a != 1 || container.field_77990_d == null || !container.field_77990_d.func_74764_b("tileEntity") || container.field_77990_d.func_74775_l("tileEntity").func_74764_b("Empty")) {
            return null;
        }
        FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.field_77990_d.func_74775_l("tileEntity"));
        if (stack == null) {
            return null;
        }
        int currentAmount = stack.amount;
        stack.amount = Math.min(stack.amount, maxDrain);
        if (doDrain) {
            if (currentAmount == stack.amount) {
                container.field_77990_d.func_82580_o("tileEntity");
                if (container.field_77990_d.func_82582_d()) {
                    container.field_77990_d = null;
                }
                return stack;
            }
            NBTTagCompound fluidTag = container.field_77990_d.func_74775_l("tileEntity");
            fluidTag.func_74768_a("Amount", currentAmount - stack.amount);
            container.field_77990_d.func_74782_a("tileEntity", (NBTBase)fluidTag);
        }
        return stack;
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        if (resource == null || container.field_77994_a != 1) {
            return 0;
        }
        if (!doFill) {
            if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("tileEntity")) {
                return Math.min(this.capacity, resource.amount);
            }
            FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.field_77990_d.func_74775_l("tileEntity"));
            if (stack == null) {
                return Math.min(this.capacity, resource.amount);
            }
            if (!stack.isFluidEqual(resource)) {
                return 0;
            }
            return Math.min(this.capacity - stack.amount, resource.amount);
        }
        if (container.field_77990_d == null) {
            container.field_77990_d = new NBTTagCompound();
        }
        if (!container.field_77990_d.func_74764_b("tileEntity") || container.field_77990_d.func_74775_l("tileEntity").func_74764_b("Empty")) {
            NBTTagCompound fluidTag = resource.writeToNBT(new NBTTagCompound());
            if (this.capacity < resource.amount) {
                fluidTag.func_74768_a("Amount", this.capacity);
                container.field_77990_d.func_74782_a("tileEntity", (NBTBase)fluidTag);
                return this.capacity;
            }
            container.field_77990_d.func_74782_a("tileEntity", (NBTBase)fluidTag);
            return resource.amount;
        }
        NBTTagCompound fluidTag = container.field_77990_d.func_74775_l("tileEntity");
        FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidTag);
        if (!stack.isFluidEqual(resource)) {
            return 0;
        }
        int filled = this.capacity - stack.amount;
        if (resource.amount < filled) {
            stack.amount += resource.amount;
            filled = resource.amount;
        } else {
            stack.amount = this.capacity;
        }
        container.field_77990_d.func_74782_a("tileEntity", (NBTBase)stack.writeToNBT(fluidTag));
        return filled;
    }

    public int getCapacity(ItemStack container) {
        return this.capacity;
    }

    public FluidStack getFluid(ItemStack container) {
        if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("tileEntity")) {
            return null;
        }
        return FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.field_77990_d.func_74775_l("tileEntity"));
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        if (!super.placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ, metadata)) {
            return false;
        }
        if (stack != null) {
            ((TileCertusQuartzTank)world.func_147438_o(x, y, z)).readFromItemNBT(stack.func_77978_p());
        }
        return true;
    }
}

