/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.common.block;

import appeng.api.implementations.items.IAEWrench;
import com.glodblock.github.common.block.BaseBlockContainer;
import com.glodblock.github.common.item.ItemCertusQuartzTank;
import com.glodblock.github.common.tabs.FluidCraftingTabs;
import com.glodblock.github.common.tile.TileCertusQuartzTank;
import com.glodblock.github.loader.IRegister;
import com.glodblock.github.loader.ItemAndBlockHolder;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidContainerItem;

public class BlockCertusQuartzTank
extends BaseBlockContainer
implements IRegister<BlockCertusQuartzTank> {
    IIcon breakIcon;
    IIcon topIcon;
    IIcon bottomIcon;
    IIcon sideIcon;
    IIcon sideMiddleIcon;
    IIcon sideTopIcon;
    IIcon sideBottomIcon;

    public BlockCertusQuartzTank() {
        super(Material.field_151592_s);
        this.func_149663_c("certus_quartz_tank");
        this.func_149752_b(10.0f);
        this.func_149711_c(2.0f);
        this.func_149676_a(0.0625f, 0.0f, 0.0625f, 0.9375f, 1.0f, 0.9375f);
    }

    public boolean canRenderInPass(int pass) {
        return true;
    }

    public TileEntity func_149915_a(World var1, int var2) {
        return new TileCertusQuartzTank();
    }

    public ItemStack getDropWithNBT(World world, int x, int y, int z) {
        NBTTagCompound tileEntity = new NBTTagCompound();
        TileEntity worldTE = world.func_147438_o(x, y, z);
        if (worldTE instanceof TileCertusQuartzTank) {
            ItemStack dropStack = new ItemStack((Block)ItemAndBlockHolder.CERTUS_QUARTZ_TANK, 1);
            ((TileCertusQuartzTank)worldTE).writeToNBTWithoutCoords(tileEntity);
            if (!tileEntity.func_74764_b("Empty")) {
                dropStack.func_77982_d(new NBTTagCompound());
                dropStack.field_77990_d.func_74782_a("tileEntity", (NBTBase)tileEntity);
            }
            return dropStack;
        }
        return null;
    }

    public IIcon func_149691_a(int side, int meta) {
        IIcon iIcon;
        switch (meta) {
            case 1: {
                iIcon = this.sideTopIcon;
                break;
            }
            case 2: {
                iIcon = this.sideBottomIcon;
                break;
            }
            case 3: {
                iIcon = this.sideMiddleIcon;
                break;
            }
            default: {
                iIcon = side == 0 ? this.bottomIcon : (side == 1 ? this.topIcon : this.sideIcon);
            }
        }
        return iIcon;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        return this.getDropWithNBT(world, x, y, z);
    }

    public boolean func_149662_c() {
        return false;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileCertusQuartzTank) {
            TileCertusQuartzTank tank = (TileCertusQuartzTank)tile;
            return tank.getFluidLightLevel();
        }
        return super.getLightValue(world, x, y, z);
    }

    public boolean func_149727_a(World worldObj, int x, int y, int z, EntityPlayer player, int side, float offsetX, float offsetY, float offsetZ) {
        IAEWrench wrench;
        Item item;
        ItemStack itemInHand = player.field_71071_by.func_70448_g();
        if (itemInHand == null || itemInHand.func_77973_b() == null) {
            return false;
        }
        if (itemInHand.func_77973_b() instanceof ItemBlock) {
            return false;
        }
        if (player.func_70093_af() && (item = itemInHand.func_77973_b()) instanceof IAEWrench && (wrench = (IAEWrench)item).canWrench(itemInHand, player, x, y, z)) {
            this.func_149642_a(worldObj, x, y, z, this.getDropWithNBT(worldObj, x, y, z));
            worldObj.func_147468_f(x, y, z);
            return true;
        }
        TileCertusQuartzTank tank = (TileCertusQuartzTank)worldObj.func_147438_o(x, y, z);
        boolean isCreativeMode = player.field_71075_bZ.field_75098_d;
        if (FluidContainerRegistry.isFilledContainer((ItemStack)itemInHand)) {
            FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemInHand);
            if (fluid == null) {
                return false;
            }
            int amountFilled = tank.fill(ForgeDirection.UNKNOWN, fluid, true);
            if (amountFilled > 0 && !isCreativeMode) {
                ItemStack empty = FluidContainerRegistry.drainFluidContainer((ItemStack)itemInHand);
                this.replaceItemInInventory(worldObj, player, itemInHand, empty);
            }
            return true;
        }
        if (FluidContainerRegistry.isEmptyContainer((ItemStack)itemInHand)) {
            FluidStack available = tank.getTankInfo((boolean)true)[0].fluid;
            ItemStack filled = FluidContainerRegistry.fillFluidContainer((FluidStack)available, (ItemStack)itemInHand);
            FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)filled);
            if (fluid == null) {
                return false;
            }
            tank.drain(ForgeDirection.UNKNOWN, fluid.amount, true);
            if (!isCreativeMode) {
                this.replaceItemInInventory(worldObj, player, itemInHand, filled);
            }
            return true;
        }
        if (itemInHand.func_77973_b() instanceof IFluidContainerItem) {
            ItemStack singleContainerItem = itemInHand.func_77946_l();
            singleContainerItem.field_77994_a = 1;
            IFluidContainerItem fluidContainer = (IFluidContainerItem)singleContainerItem.func_77973_b();
            assert (fluidContainer != null);
            FluidStack fluid = fluidContainer.getFluid(itemInHand);
            if (fluid != null && fluid.amount > 0) {
                int filled = tank.fill(ForgeDirection.UNKNOWN, fluid, true);
                if (filled > 0 && !isCreativeMode) {
                    fluidContainer.drain(singleContainerItem, filled, true);
                    this.replaceItemInInventory(worldObj, player, itemInHand, singleContainerItem);
                }
            } else {
                int containerCapacity = fluidContainer.getCapacity(itemInHand);
                FluidStack drained = tank.drain(ForgeDirection.UNKNOWN, containerCapacity, true);
                if (drained != null && drained.amount > 0 && !isCreativeMode) {
                    fluidContainer.fill(singleContainerItem, drained, true);
                    this.replaceItemInInventory(worldObj, player, itemInHand, singleContainerItem);
                }
            }
            return true;
        }
        return false;
    }

    private void replaceItemInInventory(World world, EntityPlayer player, ItemStack item, ItemStack replacement) {
        if (item.field_77994_a > 1) {
            --item.field_77994_a;
            if (!player.field_71071_by.func_70441_a(replacement) && !world.field_72995_K) {
                player.func_70099_a(replacement, 0.0f);
            }
        } else {
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, replacement);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        if (stack != null && stack.func_77942_o() && FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p().func_74775_l("tileEntity")) != null) {
            list.add(FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p().func_74775_l((String)"tileEntity")).amount + "mB");
        }
    }

    public void func_149651_a(IIconRegister iconregister) {
        String folder = "ae2fc:certus_quartz_tank/";
        this.breakIcon = iconregister.func_94245_a(folder + "cube");
        this.topIcon = iconregister.func_94245_a(folder + "top");
        this.bottomIcon = iconregister.func_94245_a(folder + "bottom");
        this.sideIcon = iconregister.func_94245_a(folder + "side");
        this.sideMiddleIcon = iconregister.func_94245_a(folder + "side_mid");
        this.sideTopIcon = iconregister.func_94245_a(folder + "side_top");
        this.sideBottomIcon = iconregister.func_94245_a(folder + "side_bottom");
    }

    public boolean func_149686_d() {
        return false;
    }

    @Override
    public BlockCertusQuartzTank register() {
        GameRegistry.registerBlock((Block)this, ItemCertusQuartzTank.class, (String)"certus_quartz_tank");
        GameRegistry.registerTileEntity(TileCertusQuartzTank.class, (String)"certus_quartz_tank");
        this.func_149647_a(FluidCraftingTabs.INSTANCE);
        return this;
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World worldIn, int x, int y, int z, int side) {
        TileEntity tileEntity = worldIn.func_147438_o(x, y, z);
        if (tileEntity instanceof TileCertusQuartzTank) {
            TileCertusQuartzTank tileCertusQuartzTank = (TileCertusQuartzTank)tileEntity;
            FluidTankInfo info = tileCertusQuartzTank.getTankInfo(false)[0];
            if (info.fluid != null) {
                int nonEmptyBump = info.fluid.amount > 0 ? 1 : 0;
                return (int)(14.0 * (double)info.fluid.amount / (double)info.capacity) + nonEmptyBump;
            }
        }
        return 0;
    }
}

