/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.client.render.tank;

import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class RenderEntityBlock
extends Render {
    public static RenderEntityBlock INSTANCE = new RenderEntityBlock();
    protected RenderBlocks renderBlocks;

    private RenderEntityBlock() {
        this.renderBlocks = this.field_147909_c;
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void func_76986_a(Entity entity, double x, double y, double z, float f, float f1) {
    }

    public void renderBlock(RenderInfo info) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        this.renderBlocks.func_147782_a(info.minX, info.minY, info.minZ, info.maxX, info.maxY, info.maxZ);
        if (info.light != -1) {
            tessellator.func_78380_c(info.light << 20 | info.light << 4);
        } else if (info.brightness != -1) {
            tessellator.func_78380_c(info.brightness << 4);
        }
        if (info.renderSide[0]) {
            tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
            this.renderBlocks.func_147768_a(info.baseBlock, 0.0, 0.0, 0.0, info.getBlockTextureFromSide(0));
        }
        if (info.renderSide[1]) {
            tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
            this.renderBlocks.func_147806_b(info.baseBlock, 0.0, 0.0, 0.0, info.getBlockTextureFromSide(1));
        }
        if (info.renderSide[2]) {
            tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
            this.renderBlocks.func_147761_c(info.baseBlock, 0.0, 0.0, 0.0, info.getBlockTextureFromSide(2));
        }
        if (info.renderSide[3]) {
            tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
            this.renderBlocks.func_147734_d(info.baseBlock, 0.0, 0.0, 0.0, info.getBlockTextureFromSide(3));
        }
        if (info.renderSide[4]) {
            tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
            this.renderBlocks.func_147798_e(info.baseBlock, 0.0, 0.0, 0.0, info.getBlockTextureFromSide(4));
        }
        if (info.renderSide[5]) {
            tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
            this.renderBlocks.func_147764_f(info.baseBlock, 0.0, 0.0, 0.0, info.getBlockTextureFromSide(5));
        }
        tessellator.func_78381_a();
    }

    public static class RenderInfo {
        public double minX = 0.0;
        public double minY = 0.0;
        public double minZ = 0.0;
        public double maxX = 1.0;
        public double maxY = 1.0;
        public double maxZ = 1.0;
        public Block baseBlock = Blocks.field_150354_m;
        public IIcon texture = null;
        public IIcon[] textureArray = null;
        public boolean[] renderSide = new boolean[]{true, true, true, true, true, true};
        public int light = -1;
        public int brightness = -1;

        public RenderInfo() {
        }

        public RenderInfo(Block template, IIcon[] texture) {
            this();
            this.baseBlock = template;
            this.textureArray = texture;
        }

        public RenderInfo(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
            this();
            this.setBounds(minX, minY, minZ, maxX, maxY, maxZ);
        }

        public void setSkyBlockLight(World world, int x, int y, int z, int light) {
            this.brightness = world.func_72925_a(EnumSkyBlock.Sky, x, y, z) << 16 | light;
        }

        public float getBlockBrightness(IBlockAccess iblockaccess, int i, int j, int k) {
            return this.baseBlock.func_149677_c(iblockaccess, i, j, k);
        }

        public final void setBounds(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
            this.minX = minX;
            this.minY = minY;
            this.minZ = minZ;
            this.maxX = maxX;
            this.maxY = maxY;
            this.maxZ = maxZ;
        }

        public final void setRenderSingleSide(int side) {
            Arrays.fill(this.renderSide, false);
            this.renderSide[side] = true;
        }

        public final void setRenderAllSides() {
            Arrays.fill(this.renderSide, true);
        }

        public void rotate() {
            double temp = this.minX;
            this.minX = this.minZ;
            this.minZ = temp;
            temp = this.maxX;
            this.maxX = this.maxZ;
            this.maxZ = temp;
        }

        public void reverseX() {
            double temp = this.minX;
            this.minX = 1.0 - this.maxX;
            this.maxX = 1.0 - temp;
        }

        public void reverseZ() {
            double temp = this.minZ;
            this.minZ = 1.0 - this.maxZ;
            this.maxZ = 1.0 - temp;
        }

        public IIcon getBlockTextureFromSide(int i) {
            if (this.texture != null) {
                return this.texture;
            }
            int index = i;
            if (this.textureArray == null || this.textureArray.length == 0) {
                return this.baseBlock.func_149733_h(index);
            }
            if (index >= this.textureArray.length) {
                index = 0;
            }
            return this.textureArray[index];
        }
    }
}

