/*
 * Decompiled with CFR 0.152.
 */
package mods.octarinecore.client.resource;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import mods.octarinecore.client.render.HSB;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0015\u0010\u0004\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0086\u0002\u001a\u001f\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007H\u0086\u0002\u001a\u0017\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\n2\u0006\u0010\r\u001a\u00020\u0005H\u0086\u0002\u001a\f\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\t\u001a\u0010\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u0011*\u00020\t\u001a\u001d\u0010\b\u001a\u00020\u0012*\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0012H\u0086\u0002\u001a%\u0010\u0015\u001a\u00020\u0016*\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0012H\u0086\u0002\u001a\u000e\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u0007\"\u0011\u0010\u0000\u001a\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u0015\u0010\u0018\u001a\u00020\u0019*\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\"\u0017\u0010\u001c\u001a\u0004\u0018\u00010\u0012*\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006\""}, d2={"resourceManager", "Lnet/minecraft/client/resources/SimpleReloadableResourceManager;", "getResourceManager", "()Lnet/minecraft/client/resources/SimpleReloadableResourceManager;", "plus", "Lnet/minecraft/util/ResourceLocation;", "str", "", "get", "Lnet/minecraft/client/resources/IResource;", "Lnet/minecraft/client/resources/IResourceManager;", "domain", "path", "location", "loadImage", "Ljava/awt/image/BufferedImage;", "getLines", "", "", "x", "y", "set", "", "value", "asStream", "Ljava/io/InputStream;", "getAsStream", "(Ljava/awt/image/BufferedImage;)Ljava/io/InputStream;", "averageColor", "Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;", "getAverageColor", "(Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;)Ljava/lang/Integer;", "textureLocation", "iconName", "BetterFoliage-LegacyEdition"})
@JvmName(name="Utils")
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\nmods/octarinecore/client/resource/Utils\n+ 2 ReadWrite.kt\nkotlin/io/TextStreamsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,112:1\n57#2:113\n1#3:114\n1317#4,2:115\n*S KotlinDebug\n*F\n+ 1 Utils.kt\nmods/octarinecore/client/resource/Utils\n*L\n42#1:113\n42#1:114\n42#1:115,2\n*E\n"})
public final class Utils {
    @NotNull
    public static final SimpleReloadableResourceManager getResourceManager() {
        IResourceManager iResourceManager = Minecraft.func_71410_x().func_110442_L();
        Intrinsics.checkNotNull((Object)iResourceManager, (String)"null cannot be cast to non-null type net.minecraft.client.resources.SimpleReloadableResourceManager");
        return (SimpleReloadableResourceManager)iResourceManager;
    }

    @NotNull
    public static final ResourceLocation plus(@NotNull ResourceLocation $this$plus, @NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return new ResourceLocation($this$plus.func_110624_b(), $this$plus.func_110623_a() + str);
    }

    @Nullable
    public static final IResource get(@NotNull IResourceManager $this$get, @NotNull String domain, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)$this$get, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return Utils.get($this$get, new ResourceLocation(domain, path));
    }

    @Nullable
    public static final IResource get(@NotNull IResourceManager $this$get, @NotNull ResourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)$this$get, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return mods.octarinecore.Utils.tryDefault(null, () -> Utils.get$lambda$0($this$get, location));
    }

    @Nullable
    public static final BufferedImage loadImage(@NotNull IResource $this$loadImage) {
        Intrinsics.checkNotNullParameter((Object)$this$loadImage, (String)"<this>");
        return mods.octarinecore.Utils.tryDefault(null, () -> Utils.loadImage$lambda$1($this$loadImage));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final List<String> getLines(@NotNull IResource $this$getLines) {
        Intrinsics.checkNotNullParameter((Object)$this$getLines, (String)"<this>");
        ArrayList<String> result = new ArrayList<String>();
        InputStream inputStream = $this$getLines.func_110527_b();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        InputStream inputStream2 = inputStream;
        Charset charset = Charsets.UTF_8;
        Closeable closeable = new InputStreamReader(inputStream2, charset);
        int n = 8192;
        Reader $this$useLines$iv = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n);
        boolean $i$f$useLines = false;
        closeable = $this$useLines$iv;
        n = 8192;
        closeable = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n);
        Throwable throwable = null;
        try {
            BufferedReader it$iv = (BufferedReader)closeable;
            boolean bl = false;
            Sequence it = TextStreamsKt.lineSequence((BufferedReader)it$iv);
            boolean bl2 = false;
            Sequence $this$forEach$iv = it;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it2 = (String)element$iv;
                boolean bl3 = false;
                result.add(it2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return result;
    }

    public static final int get(@NotNull BufferedImage $this$get, int x, int y) {
        Intrinsics.checkNotNullParameter((Object)$this$get, (String)"<this>");
        return $this$get.getRGB(x, y);
    }

    public static final void set(@NotNull BufferedImage $this$set, int x, int y, int value) {
        Intrinsics.checkNotNullParameter((Object)$this$set, (String)"<this>");
        $this$set.setRGB(x, y, value);
    }

    @NotNull
    public static final InputStream getAsStream(@NotNull BufferedImage $this$asStream) {
        Intrinsics.checkNotNullParameter((Object)$this$asStream, (String)"<this>");
        ByteArrayOutputStream it = new ByteArrayOutputStream();
        boolean bl = false;
        ImageIO.write((RenderedImage)$this$asStream, "PNG", it);
        byte[] byArray = it.toByteArray();
        return new ByteArrayInputStream(byArray);
    }

    @Nullable
    public static final Integer getAverageColor(@NotNull TextureAtlasSprite $this$averageColor) {
        Intrinsics.checkNotNullParameter((Object)$this$averageColor, (String)"<this>");
        ResourceLocation locationNoDirs = new ResourceLocation($this$averageColor.func_94215_i());
        String string = locationNoDirs.func_110624_b();
        String string2 = "textures/blocks/%s.png";
        Object[] objectArray = new Object[]{locationNoDirs.func_110623_a()};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        ResourceLocation locationWithDirs = new ResourceLocation(string, string3);
        Object object = Utils.get((IResourceManager)Utils.getResourceManager(), locationWithDirs);
        if (object == null || (object = Utils.loadImage((IResource)object)) == null) {
            return null;
        }
        Object image = object;
        int numOpaque = 0;
        double sumHueX = 0.0;
        double sumHueY = 0.0;
        float sumSaturation = 0.0f;
        float sumBrightness = 0.0f;
        int n = ((BufferedImage)image).getWidth();
        for (int x = 0; x < n; ++x) {
            int n2 = ((BufferedImage)image).getHeight();
            for (int y = 0; y < n2; ++y) {
                int pixel = Utils.get((BufferedImage)image, x, y);
                int alpha = pixel >> 24 & 0xFF;
                HSB hsb = HSB.Companion.fromColor(pixel);
                if (alpha != 255) continue;
                ++numOpaque;
                sumHueX += Math.cos(((double)hsb.getHue() - 0.5) * (Math.PI * 2));
                sumHueY += Math.sin(((double)hsb.getHue() - 0.5) * (Math.PI * 2));
                sumSaturation += hsb.getSaturation();
                sumBrightness += hsb.getBrightness();
            }
        }
        float avgHue = (float)(Math.atan2(sumHueY, sumHueX) / (Math.PI * 2) + 0.5);
        return new HSB(avgHue, sumSaturation / (float)numOpaque, sumBrightness / (float)numOpaque).getAsColor();
    }

    @NotNull
    public static final ResourceLocation textureLocation(@NotNull String iconName) {
        Intrinsics.checkNotNullParameter((Object)iconName, (String)"iconName");
        ResourceLocation it = new ResourceLocation(iconName);
        boolean bl = false;
        String string = it.func_110623_a();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getResourcePath(...)");
        return StringsKt.startsWith$default((String)string, (String)"mcpatcher", (boolean)false, (int)2, null) ? it : new ResourceLocation(it.func_110624_b(), "textures/blocks/" + it.func_110623_a());
    }

    private static final IResource get$lambda$0(IResourceManager $this_get, ResourceLocation $location) {
        return $this_get.func_110536_a($location);
    }

    private static final BufferedImage loadImage$lambda$1(IResource $this_loadImage) {
        return ImageIO.read($this_loadImage.func_110527_b());
    }
}

