/*
 * Decompiled with CFR 0.152.
 */
package mods.octarinecore.client.render;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mods.octarinecore.client.render.Double3;
import mods.octarinecore.client.render.GeometryKt;
import mods.octarinecore.client.render.Quad;
import mods.octarinecore.client.render.UV;
import mods.octarinecore.client.render.Vertex;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0017\b\u0016\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0007J\n\u0010\f\u001a\u00020\r*\u00020\u0006J\u0010\u0010\u000e\u001a\u00020\u000f*\b\u0012\u0004\u0012\u00020\u00060\u0010J\u001a\u0010\u0011\u001a\u00020\u000f2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0013J\u001a\u0010\u0014\u001a\u00020\u000f2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\u0013J6\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u0018J.\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u0018J\u000e\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\"J\b\u0010#\u001a\u00020\u0000H\u0016R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006$"}, d2={"Lmods/octarinecore/client/render/Model;", "", "<init>", "()V", "other", "", "Lmods/octarinecore/client/render/Quad;", "(Ljava/util/List;)V", "quads", "", "getQuads", "()Ljava/util/List;", "add", "", "addAll", "", "", "transformQ", "trans", "Lkotlin/Function1;", "transformV", "Lmods/octarinecore/client/render/Vertex;", "verticalRectangle", "x1", "", "z1", "x2", "z2", "yBottom", "yTop", "horizontalRectangle", "y", "faceQuad", "face", "Lnet/minecraftforge/common/util/ForgeDirection;", "clone", "BetterFoliage-LegacyEdition"})
@SourceDebugExtension(value={"SMAP\nModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Model.kt\nmods/octarinecore/client/render/Model\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Utils.kt\nmods/octarinecore/Utils\n+ 4 Model.kt\nmods/octarinecore/client/render/Quad\n*L\n1#1,174:1\n1863#2,2:175\n1872#2,2:178\n1874#2:182\n1872#2,2:184\n1874#2:192\n21#3:177\n22#3,2:180\n21#3:183\n22#3:186\n23#3:191\n55#4,4:187\n*S KotlinDebug\n*F\n+ 1 Model.kt\nmods/octarinecore/client/render/Model\n*L\n112#1:175,2\n114#1:178,2\n114#1:182\n115#1:184,2\n115#1:192\n114#1:177\n114#1:180,2\n115#1:183\n115#1:186\n115#1:191\n115#1:187,4\n*E\n"})
public final class Model
implements Cloneable {
    @NotNull
    private final List<Quad> quads;

    public Model() {
        this.quads = new ArrayList();
    }

    public Model(@NotNull List<Quad> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        this();
        this.quads.addAll((Collection<Quad>)other);
    }

    @NotNull
    public final List<Quad> getQuads() {
        return this.quads;
    }

    public final boolean add(@NotNull Quad $this$add) {
        Intrinsics.checkNotNullParameter((Object)$this$add, (String)"<this>");
        return this.quads.add($this$add);
    }

    public final void addAll(@NotNull Iterable<Quad> $this$addAll) {
        Intrinsics.checkNotNullParameter($this$addAll, (String)"<this>");
        Iterable<Quad> $this$forEach$iv = $this$addAll;
        boolean $i$f$forEach = false;
        Iterator<Quad> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Quad element$iv;
            Quad it = element$iv = iterator.next();
            boolean bl = false;
            this.quads.add(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void transformQ(@NotNull Function1<? super Quad, Quad> trans) {
        Intrinsics.checkNotNullParameter(trans, (String)"trans");
        List<Quad> $this$replace$iv = this.quads;
        boolean $i$f$replace = false;
        Iterable $this$forEachIndexed$iv$iv = $this$replace$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$forEachIndexed$iv$iv) {
            void value$iv;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv;
            int idx$iv = n;
            boolean bl = false;
            $this$replace$iv.set(idx$iv, (Quad)trans.invoke((Object)value$iv));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void transformV(@NotNull Function1<? super Vertex, Vertex> trans) {
        Intrinsics.checkNotNullParameter(trans, (String)"trans");
        List<Quad> $this$replace$iv = this.quads;
        boolean $i$f$replace = false;
        Iterable $this$forEachIndexed$iv$iv = $this$replace$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$forEachIndexed$iv$iv) {
            Vertex vertex;
            void it;
            void value$iv;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv;
            int idx$iv = n;
            boolean bl = false;
            Quad quad = (Quad)value$iv;
            int n2 = idx$iv;
            List<Quad> list = $this$replace$iv;
            boolean bl2 = false;
            void this_$iv = it;
            boolean $i$f$transformV = false;
            void this_$iv$iv = this_$iv;
            boolean $i$f$transformVI = false;
            boolean bl3 = false;
            Vertex vertex$iv = this_$iv$iv.getV1();
            boolean bl4 = false;
            Vertex vertex2 = (Vertex)trans.invoke((Object)vertex$iv);
            int idx$iv2 = 1;
            vertex$iv = this_$iv$iv.getV2();
            Vertex vertex3 = vertex2;
            bl4 = false;
            idx$iv2 = 2;
            vertex$iv = this_$iv$iv.getV3();
            Vertex vertex4 = (Vertex)trans.invoke((Object)vertex$iv);
            bl4 = false;
            Vertex vertex5 = (Vertex)trans.invoke((Object)vertex$iv);
            idx$iv2 = 3;
            vertex$iv = this_$iv$iv.getV4();
            bl4 = false;
            Vertex vertex6 = vertex = (Vertex)trans.invoke((Object)vertex$iv);
            Vertex vertex7 = vertex5;
            Vertex vertex8 = vertex4;
            Vertex vertex9 = vertex3;
            Quad quad2 = new Quad(vertex9, vertex8, vertex7, vertex6);
            list.set(n2, quad2);
        }
    }

    @NotNull
    public final Quad verticalRectangle(double x1, double z1, double x2, double z2, double yBottom, double yTop) {
        return new Quad(new Vertex(new Double3(x1, yBottom, z1), UV.Companion.getBottomLeft(), null, null, 12, null), new Vertex(new Double3(x2, yBottom, z2), UV.Companion.getBottomRight(), null, null, 12, null), new Vertex(new Double3(x2, yTop, z2), UV.Companion.getTopRight(), null, null, 12, null), new Vertex(new Double3(x1, yTop, z1), UV.Companion.getTopLeft(), null, null, 12, null));
    }

    @NotNull
    public final Quad horizontalRectangle(double x1, double z1, double x2, double z2, double y) {
        double xMin = Math.min(x1, x2);
        double xMax = Math.max(x1, x2);
        double zMin = Math.min(z1, z2);
        double zMax = Math.max(z1, z2);
        return new Quad(new Vertex(new Double3(xMin, y, zMin), UV.Companion.getTopLeft(), null, null, 12, null), new Vertex(new Double3(xMin, y, zMax), UV.Companion.getBottomLeft(), null, null, 12, null), new Vertex(new Double3(xMax, y, zMax), UV.Companion.getBottomRight(), null, null, 12, null), new Vertex(new Double3(xMax, y, zMin), UV.Companion.getTopRight(), null, null, 12, null));
    }

    @NotNull
    public final Quad faceQuad(@NotNull ForgeDirection face) {
        Intrinsics.checkNotNullParameter((Object)face, (String)"face");
        Double3 base = GeometryKt.getVec(face).times(0.5);
        Double3 top = GeometryKt.getVec((ForgeDirection)GeometryKt.getFaceCorners().get(face.ordinal()).getTopLeft().getFirst()).times(0.5);
        Double3 left = GeometryKt.getVec((ForgeDirection)GeometryKt.getFaceCorners().get(face.ordinal()).getTopLeft().getSecond()).times(0.5);
        return new Quad(new Vertex(base.plus(top).plus(left), UV.Companion.getTopLeft(), null, null, 12, null), new Vertex(base.minus(top).plus(left), UV.Companion.getBottomLeft(), null, null, 12, null), new Vertex(base.minus(top).minus(left), UV.Companion.getBottomRight(), null, null, 12, null), new Vertex(base.plus(top).minus(left), UV.Companion.getTopRight(), null, null, 12, null));
    }

    @NotNull
    public Model clone() {
        List list;
        List $this$clone_u24lambda_u242 = list = CollectionsKt.createListBuilder((int)this.quads.size());
        boolean bl = false;
        for (Quad quad : this.quads) {
            $this$clone_u24lambda_u242.add(Quad.copy$default(quad, null, null, null, null, 15, null));
        }
        List quadsCopy = CollectionsKt.build((List)list);
        return new Model(quadsCopy);
    }
}

