/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.client.texture;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mods.betterfoliage.client.Client;
import mods.betterfoliage.client.config.BlockMatcher;
import mods.betterfoliage.client.config.Config;
import mods.betterfoliage.client.integration.OptifineCTM;
import mods.betterfoliage.client.texture.GrassInfo;
import mods.octarinecore.client.render.HSB;
import mods.octarinecore.client.resource.Utils;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.IIcon;
import net.minecraft.util.RegistryNamespaced;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.Level;
import org.jetbrains.annotations.NotNull;

@SideOnly(value=Side.CLIENT)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0016\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lmods/betterfoliage/client/texture/GrassRegistry;", "", "<init>", "()V", "grass", "", "Lnet/minecraft/util/IIcon;", "Lmods/betterfoliage/client/texture/GrassInfo;", "getGrass", "()Ljava/util/Map;", "handleTextureReload", "", "event", "Lnet/minecraftforge/client/event/TextureStitchEvent$Pre;", "registerGrass", "atlas", "Lnet/minecraft/client/renderer/texture/TextureMap;", "icon", "Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;", "BetterFoliage-LegacyEdition"})
@SourceDebugExtension(value={"SMAP\nGrassRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrassRegistry.kt\nmods/betterfoliage/client/texture/GrassRegistry\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,97:1\n1863#2:98\n1863#2,2:99\n1864#2:101\n1863#2,2:102\n*S KotlinDebug\n*F\n+ 1 GrassRegistry.kt\nmods/betterfoliage/client/texture/GrassRegistry\n*L\n52#1:98\n78#1:99,2\n52#1:101\n63#1:102,2\n*E\n"})
public final class GrassRegistry {
    @NotNull
    public static final GrassRegistry INSTANCE = new GrassRegistry();
    @NotNull
    private static final Map<IIcon, GrassInfo> grass = new HashMap();

    private GrassRegistry() {
    }

    @NotNull
    public final Map<IIcon, GrassInfo> getGrass() {
        return grass;
    }

    @SubscribeEvent
    public final void handleTextureReload(@NotNull TextureStitchEvent.Pre event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.map.func_130086_a() != 0) {
            return;
        }
        grass.clear();
        Client.INSTANCE.log(Level.INFO, "Inspecting grass textures");
        RegistryNamespaced registryNamespaced = Block.field_149771_c;
        Intrinsics.checkNotNullExpressionValue((Object)registryNamespaced, (String)"blockRegistry");
        Iterable $this$forEach$iv = (Iterable)registryNamespaced;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object block = element$iv = iterator.next();
            boolean bl = false;
            BlockMatcher blockMatcher = Config.blocks.INSTANCE.getGrass();
            Intrinsics.checkNotNull(block, (String)"null cannot be cast to non-null type net.minecraft.block.Block");
            if (!blockMatcher.matchesClass((Block)block)) continue;
            ((Block)block).func_149651_a(arg_0 -> GrassRegistry.handleTextureReload$lambda$5$lambda$2(event, arg_0));
            if (!OptifineCTM.INSTANCE.isAvailable()) continue;
            Collection<IIcon> ctmIcons = OptifineCTM.INSTANCE.getAllCTM((Block)block);
            boolean bl2 = false;
            if (!(!ctmIcons.isEmpty())) continue;
            Client.INSTANCE.log(Level.INFO, "Found " + ctmIcons.size() + " CTM variants for block " + Block.func_149682_b((Block)((Block)block)));
            Iterable $this$forEach$iv2 = ctmIcons;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                IIcon it = (IIcon)element$iv2;
                boolean bl3 = false;
                TextureMap textureMap = event.map;
                Intrinsics.checkNotNullExpressionValue((Object)textureMap, (String)"map");
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type net.minecraft.client.renderer.texture.TextureAtlasSprite");
                INSTANCE.registerGrass(textureMap, (TextureAtlasSprite)it);
            }
        }
    }

    public final void registerGrass(@NotNull TextureMap atlas, @NotNull TextureAtlasSprite icon) {
        Intrinsics.checkNotNullParameter((Object)atlas, (String)"atlas");
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        Integer n = Utils.getAverageColor(icon);
        HSB hsb = HSB.Companion.fromColor(n != null ? n : 0);
        Integer overrideColor = (double)hsb.getSaturation() > Config.shortGrass.INSTANCE.getSaturationThreshold() ? Integer.valueOf(HSB.copy$default(hsb, 0.0f, 0.0f, 0.8f, 3, null).getAsColor()) : null;
        grass.put((IIcon)icon, new GrassInfo(icon, overrideColor));
    }

    private static final IIcon handleTextureReload$lambda$5$lambda$2(TextureStitchEvent.Pre $event, String location) {
        TextureAtlasSprite original = $event.map.getTextureExtry(location);
        Client.INSTANCE.log(Level.DEBUG, "Found grass texture: " + location);
        TextureMap textureMap = $event.map;
        Intrinsics.checkNotNullExpressionValue((Object)textureMap, (String)"map");
        Intrinsics.checkNotNull((Object)original);
        INSTANCE.registerGrass(textureMap, original);
        if (OptifineCTM.INSTANCE.isAvailable()) {
            Collection<IIcon> ctmIcons = OptifineCTM.INSTANCE.getAllCTM((IIcon)original);
            boolean bl = false;
            if (!ctmIcons.isEmpty()) {
                Client.INSTANCE.log(Level.INFO, "Found " + ctmIcons.size() + " CTM variants for texture " + original.func_94215_i());
                Iterable $this$forEach$iv = ctmIcons;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    IIcon it = (IIcon)element$iv;
                    boolean bl2 = false;
                    TextureMap textureMap2 = $event.map;
                    Intrinsics.checkNotNullExpressionValue((Object)textureMap2, (String)"map");
                    Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type net.minecraft.client.renderer.texture.TextureAtlasSprite");
                    INSTANCE.registerGrass(textureMap2, (TextureAtlasSprite)it);
                }
            }
        }
        return (IIcon)original;
    }

    static {
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
    }
}

