/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.client.render;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function6;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import mods.octarinecore.client.render.Double3;
import mods.octarinecore.client.render.GeometryKt;
import mods.octarinecore.client.render.Int3;
import mods.octarinecore.client.render.Model;
import mods.octarinecore.client.render.Quad;
import mods.octarinecore.client.render.RenderVertex;
import mods.octarinecore.client.render.Rotation;
import mods.octarinecore.client.render.ShadingContext;
import mods.octarinecore.client.render.Vertex;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000j\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a,\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00190&*\u00020\u00192\u0006\u0010'\u001a\u00020(2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00190*\u001a\u0018\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00190&*\u00020\u00192\u0006\u0010'\u001a\u00020(\u001a\u000e\u0010+\u001a\u00020\t2\u0006\u0010,\u001a\u00020\u0018\u001a.\u0010/\u001a\u00020\u001b*\u0002002\u0006\u00101\u001a\u0002002\u0006\u00102\u001a\u0002002\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\"0*\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\"\u0011\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0003\"\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0019\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010\"\u0019\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u0013\u0010\u0010\"@\u0010\u0014\u001a1\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u0015\u00a2\u0006\u0002\b\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"@\u0010\u001f\u001a1\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u0015\u00a2\u0006\u0002\b\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001e\"\u0015\u0010!\u001a\u00020\"*\u00020#8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010$\"\u0019\u0010-\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b.\u0010\u0010\u00a8\u00064"}, d2={"up1", "Lmods/octarinecore/client/render/Int3;", "getUp1", "()Lmods/octarinecore/client/render/Int3;", "up2", "getUp2", "down1", "getDown1", "snowOffset", "Lmods/octarinecore/client/render/Double3;", "getSnowOffset", "()Lmods/octarinecore/client/render/Double3;", "normalLeavesRot", "", "Lmods/octarinecore/client/render/Rotation;", "getNormalLeavesRot", "()[Lmods/octarinecore/client/render/Rotation;", "[Lmods/octarinecore/client/render/Rotation;", "denseLeavesRot", "getDenseLeavesRot", "whitewash", "Lkotlin/Function6;", "Lmods/octarinecore/client/render/RenderVertex;", "Lmods/octarinecore/client/render/ShadingContext;", "", "Lmods/octarinecore/client/render/Quad;", "Lmods/octarinecore/client/render/Vertex;", "", "Lkotlin/ExtensionFunctionType;", "getWhitewash", "()Lkotlin/jvm/functions/Function6;", "greywash", "getGreywash", "isSnow", "", "Lnet/minecraft/block/Block;", "(Lnet/minecraft/block/Block;)Z", "toCross", "", "rotAxis", "Lnet/minecraftforge/common/util/ForgeDirection;", "trans", "Lkotlin/Function1;", "xzDisk", "modelIdx", "rotationFromUp", "getRotationFromUp", "mix", "Lmods/octarinecore/client/render/Model;", "first", "second", "predicate", "BetterFoliage-LegacyEdition"})
@JvmName(name="Utils")
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\nmods/betterfoliage/client/render/Utils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ModelRenderer.kt\nmods/octarinecore/client/render/RenderVertex\n*L\n1#1,69:1\n1#2:70\n1557#3:71\n1628#3,3:72\n1872#3,3:75\n155#4,5:78\n155#4,5:83\n*S KotlinDebug\n*F\n+ 1 Utils.kt\nmods/betterfoliage/client/render/Utils\n*L\n39#1:71\n39#1:72,3\n58#1:75,3\n30#1:78,5\n33#1:83,5\n*E\n"})
public final class Utils {
    @NotNull
    private static final Int3 up1 = new Int3((Pair<Integer, ? extends ForgeDirection>)TuplesKt.to((Object)1, (Object)ForgeDirection.UP));
    @NotNull
    private static final Int3 up2 = new Int3((Pair<Integer, ? extends ForgeDirection>)TuplesKt.to((Object)2, (Object)ForgeDirection.UP));
    @NotNull
    private static final Int3 down1 = new Int3((Pair<Integer, ? extends ForgeDirection>)TuplesKt.to((Object)1, (Object)ForgeDirection.DOWN));
    @NotNull
    private static final Double3 snowOffset = GeometryKt.times(ForgeDirection.UP, 0.0625);
    @NotNull
    private static final Rotation[] normalLeavesRot;
    @NotNull
    private static final Rotation[] denseLeavesRot;
    @NotNull
    private static final Function6<RenderVertex, ShadingContext, Integer, Quad, Integer, Vertex, Unit> whitewash;
    @NotNull
    private static final Function6<RenderVertex, ShadingContext, Integer, Quad, Integer, Vertex, Unit> greywash;
    @NotNull
    private static final Rotation[] rotationFromUp;

    @NotNull
    public static final Int3 getUp1() {
        return up1;
    }

    @NotNull
    public static final Int3 getUp2() {
        return up2;
    }

    @NotNull
    public static final Int3 getDown1() {
        return down1;
    }

    @NotNull
    public static final Double3 getSnowOffset() {
        return snowOffset;
    }

    @NotNull
    public static final Rotation[] getNormalLeavesRot() {
        return normalLeavesRot;
    }

    @NotNull
    public static final Rotation[] getDenseLeavesRot() {
        return denseLeavesRot;
    }

    @NotNull
    public static final Function6<RenderVertex, ShadingContext, Integer, Quad, Integer, Vertex, Unit> getWhitewash() {
        return whitewash;
    }

    @NotNull
    public static final Function6<RenderVertex, ShadingContext, Integer, Quad, Integer, Vertex, Unit> getGreywash() {
        return greywash;
    }

    public static final boolean isSnow(@NotNull Block $this$isSnow) {
        Intrinsics.checkNotNullParameter((Object)$this$isSnow, (String)"<this>");
        Material it = $this$isSnow.func_149688_o();
        boolean bl = false;
        return Intrinsics.areEqual((Object)it, (Object)Material.field_151597_y) || Intrinsics.areEqual((Object)it, (Object)Material.field_151596_z);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Quad> toCross(@NotNull Quad $this$toCross, @NotNull ForgeDirection rotAxis, @NotNull Function1<? super Quad, Quad> trans) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$toCross, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)rotAxis, (String)"rotAxis");
        Intrinsics.checkNotNullParameter(trans, (String)"trans");
        Iterable $this$map$iv = (Iterable)new IntRange(0, 3);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void rotIdx;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Quad)trans.invoke((Object)$this$toCross.rotate(Rotation.Companion.getRot90()[rotAxis.ordinal()].times((int)rotIdx)).mirrorUV(rotIdx > true, false)));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final List<Quad> toCross(@NotNull Quad $this$toCross, @NotNull ForgeDirection rotAxis) {
        Intrinsics.checkNotNullParameter((Object)$this$toCross, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)rotAxis, (String)"rotAxis");
        return Utils.toCross($this$toCross, rotAxis, (Function1<? super Quad, Quad>)((Function1)Utils::toCross$lambda$4));
    }

    @NotNull
    public static final Double3 xzDisk(int modelIdx) {
        double it = Math.PI * 2 * (double)modelIdx / 64.0;
        boolean bl = false;
        return new Double3(Math.cos(it), 0.0, Math.sin(it));
    }

    @NotNull
    public static final Rotation[] getRotationFromUp() {
        return rotationFromUp;
    }

    /*
     * WARNING - void declaration
     */
    public static final void mix(@NotNull Model $this$mix, @NotNull Model first, @NotNull Model second, @NotNull Function1<? super Integer, Boolean> predicate) {
        Intrinsics.checkNotNullParameter((Object)$this$mix, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        Iterable $this$forEachIndexed$iv = first.getQuads();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void quad;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Quad quad2 = (Quad)item$iv;
            int qi = n;
            boolean bl = false;
            Quad otherQuad = second.getQuads().get(qi);
            $this$mix.add(new Quad((Boolean)predicate.invoke((Object)0) != false ? Vertex.copy$default(otherQuad.getV1(), null, null, null, null, 15, null) : Vertex.copy$default(quad.getV1(), null, null, null, null, 15, null), (Boolean)predicate.invoke((Object)1) != false ? Vertex.copy$default(otherQuad.getV2(), null, null, null, null, 15, null) : Vertex.copy$default(quad.getV2(), null, null, null, null, 15, null), (Boolean)predicate.invoke((Object)2) != false ? Vertex.copy$default(otherQuad.getV3(), null, null, null, null, 15, null) : Vertex.copy$default(quad.getV3(), null, null, null, null, 15, null), (Boolean)predicate.invoke((Object)3) != false ? Vertex.copy$default(otherQuad.getV4(), null, null, null, null, 15, null) : Vertex.copy$default(quad.getV4(), null, null, null, null, 15, null)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit whitewash$lambda$0(RenderVertex renderVertex, ShadingContext ctx, int qi, Quad q, int vi, Vertex v) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)renderVertex, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        RenderVertex renderVertex2 = renderVertex;
        float level$iv = 1.4f;
        boolean $i$f$setGrey = false;
        float grey$iv = Math.min((this_$iv.getRed() + this_$iv.getGreen() + this_$iv.getBlue()) * 0.333f * level$iv, 1.0f);
        this_$iv.setRed(grey$iv);
        this_$iv.setGreen(grey$iv);
        this_$iv.setBlue(grey$iv);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit greywash$lambda$1(RenderVertex renderVertex, ShadingContext ctx, int qi, Quad q, int vi, Vertex v) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)renderVertex, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        RenderVertex renderVertex2 = renderVertex;
        float level$iv = 1.0f;
        boolean $i$f$setGrey = false;
        float grey$iv = Math.min((this_$iv.getRed() + this_$iv.getGreen() + this_$iv.getBlue()) * 0.333f * level$iv, 1.0f);
        this_$iv.setRed(grey$iv);
        this_$iv.setGreen(grey$iv);
        this_$iv.setBlue(grey$iv);
        return Unit.INSTANCE;
    }

    private static final Quad toCross$lambda$4(Quad it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }

    static {
        Rotation[] rotationArray = new Rotation[]{Rotation.Companion.getIdentity()};
        normalLeavesRot = rotationArray;
        rotationArray = new Rotation[]{Rotation.Companion.getIdentity(), Rotation.Companion.getRot90()[ForgeDirection.EAST.ordinal()], Rotation.Companion.getRot90()[ForgeDirection.SOUTH.ordinal()]};
        denseLeavesRot = rotationArray;
        whitewash = Utils::whitewash$lambda$0;
        greywash = Utils::greywash$lambda$1;
        rotationArray = new Rotation[]{Rotation.Companion.getRot90()[ForgeDirection.EAST.ordinal()].times(2), Rotation.Companion.getIdentity(), Rotation.Companion.getRot90()[ForgeDirection.WEST.ordinal()], Rotation.Companion.getRot90()[ForgeDirection.EAST.ordinal()], Rotation.Companion.getRot90()[ForgeDirection.SOUTH.ordinal()], Rotation.Companion.getRot90()[ForgeDirection.NORTH.ordinal()]};
        rotationFromUp = rotationArray;
    }
}

