/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.client.integration;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import mods.betterfoliage.client.Client;
import mods.betterfoliage.client.integration.Mod;
import mods.octarinecore.client.render.BlockContext;
import mods.octarinecore.client.render.Double3;
import mods.octarinecore.client.render.GeometryKt;
import mods.octarinecore.client.render.Model;
import mods.octarinecore.client.render.ModelData;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import tconstruct.world.blocks.OreberryBush;

@SideOnly(value=Side.CLIENT)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R)\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b8FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\r\u0010\u000e\u0012\u0004\b\n\u0010\u0003\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lmods/betterfoliage/client/integration/TinkersIntegration;", "", "<init>", "()V", "BUSH_GROWTH_STAGES", "", "BUSH_METAS_PER_STAGE", "tinkersLeavesModel", "", "Lmods/octarinecore/client/render/Model;", "getTinkersLeavesModel$annotations", "getTinkersLeavesModel", "()[Lmods/octarinecore/client/render/Model;", "tinkersLeavesModel$delegate", "Lkotlin/Lazy;", "isTinkersBush", "", "block", "Lnet/minecraft/block/Block;", "getTinkersBushData", "Lmods/octarinecore/client/render/ModelData;", "ctx", "Lmods/octarinecore/client/render/BlockContext;", "getBushGrowth", "BetterFoliage-LegacyEdition"})
public final class TinkersIntegration {
    @NotNull
    public static final TinkersIntegration INSTANCE = new TinkersIntegration();
    private static final int BUSH_GROWTH_STAGES = 3;
    private static final int BUSH_METAS_PER_STAGE = 4;
    @NotNull
    private static final Lazy tinkersLeavesModel$delegate = LazyKt.lazy(TinkersIntegration::tinkersLeavesModel_delegate$lambda$0);

    private TinkersIntegration() {
    }

    @NotNull
    public static final Model[] getTinkersLeavesModel() {
        Lazy lazy = tinkersLeavesModel$delegate;
        return (Model[])lazy.getValue();
    }

    @JvmStatic
    public static /* synthetic */ void getTinkersLeavesModel$annotations() {
    }

    public final boolean isTinkersBush(@NotNull Block block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        return Mod.TCON.isLoaded() && block instanceof OreberryBush;
    }

    @NotNull
    public final ModelData getTinkersBushData(@NotNull BlockContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        AxisAlignedBB aabb = ctx.getBlock().func_149668_a((World)world, ctx.getX(), ctx.getY(), ctx.getZ());
        int stage = this.getBushGrowth(ctx);
        Intrinsics.checkNotNull((Object)aabb);
        Double3 scale = GeometryKt.getScale(aabb);
        if (stage == 2) {
            return new ModelData(scale, GeometryKt.getCenter(aabb), Client.INSTANCE.getLeafRenderer().getLeavesModel().getModel());
        }
        Model model = TinkersIntegration.getTinkersLeavesModel()[stage];
        if (model == null) {
            model = Client.INSTANCE.getLeafRenderer().getLeavesModel().getModel().clone();
            int n = ((Collection)model.getQuads()).size();
            for (int i = 0; i < n; ++i) {
                model.getQuads().set(i, model.getQuads().get(i).scale(scale));
            }
            TinkersIntegration.getTinkersLeavesModel()[stage] = model;
        }
        return new ModelData(scale, GeometryKt.getCenter(aabb), model);
    }

    private final int getBushGrowth(BlockContext ctx) {
        return Math.min(ctx.getMeta() / 4, 2);
    }

    private static final Model[] tinkersLeavesModel_delegate$lambda$0() {
        return new Model[2];
    }
}

