/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.client.integration;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregapi.block.multitileentity.MultiTileEntityBlock;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mods.betterfoliage.client.Client;
import mods.betterfoliage.client.integration.Mod;
import mods.betterfoliage.client.texture.LeafRegistry;
import mods.betterfoliage.mixins.interfaces.gt6.ITreeHoleMTE;
import mods.octarinecore.client.render.BlockContext;
import mods.octarinecore.client.render.Int3;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.logging.log4j.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SideOnly(value=Side.CLIENT)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J \u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u00a8\u0006\u0012"}, d2={"Lmods/betterfoliage/client/integration/GT6Integration;", "", "<init>", "()V", "registerLeafTextures", "", "event", "Lnet/minecraftforge/client/event/TextureStitchEvent$Pre;", "allowSpecialGT6LogRender", "", "ctx", "Lmods/octarinecore/client/render/BlockContext;", "getGT6LogMTEIcon", "Lnet/minecraft/util/IIcon;", "face", "Lnet/minecraftforge/common/util/ForgeDirection;", "offset", "Lmods/octarinecore/client/render/Int3;", "BetterFoliage-LegacyEdition"})
@SourceDebugExtension(value={"SMAP\nGT6Integration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GT6Integration.kt\nmods/betterfoliage/client/integration/GT6Integration\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,46:1\n1863#2:47\n1863#2,2:48\n1864#2:50\n*S KotlinDebug\n*F\n+ 1 GT6Integration.kt\nmods/betterfoliage/client/integration/GT6Integration\n*L\n21#1:47\n22#1:48,2\n21#1:50\n*E\n"})
public final class GT6Integration {
    @NotNull
    public static final GT6Integration INSTANCE = new GT6Integration();

    private GT6Integration() {
    }

    public final void registerLeafTextures(@NotNull TextureStitchEvent.Pre event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!Mod.GT6.isLoaded()) {
            return;
        }
        Object[] objectArray = new String[]{"BLUEMAHOE", "BLUESPRUCE", "BLUESPRUCE_XMAS", "CINNAMON", "COCONUT", "HAZEL", "MAPLE", "MAPLE_BROWN", "MAPLE_ORANGE", "MAPLE_RED", "MAPLE_YELLOW", "RAINBOWOOD", "RUBBER", "WILLOW"};
        Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String leafType = (String)element$iv;
            boolean bl = false;
            Object[] objectArray2 = new String[]{"", "OPAQUE_"};
            Iterable $this$forEach$iv2 = CollectionsKt.listOf((Object[])objectArray2);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String renderTypePrefix = (String)element$iv2;
                boolean bl2 = false;
                String location = Mod.GT6.getModID() + ":iconsets/LEAVES_" + renderTypePrefix + leafType;
                TextureAtlasSprite original = event.map.getTextureExtry(location);
                if (original == null) continue;
                Client.INSTANCE.log(Level.INFO, "Registering " + Mod.GT6.getModName() + " leaf texture: " + location);
                TextureMap textureMap = event.map;
                Intrinsics.checkNotNullExpressionValue((Object)textureMap, (String)"map");
                LeafRegistry.INSTANCE.registerLeaf(textureMap, original);
            }
        }
    }

    @JvmStatic
    public static final boolean allowSpecialGT6LogRender(@NotNull BlockContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        return !Mod.GT6.isLoaded() || !(ctx.getBlock() instanceof MultiTileEntityBlock) || ctx.getTileEntity() instanceof ITreeHoleMTE;
    }

    @Nullable
    public final IIcon getGT6LogMTEIcon(@NotNull BlockContext ctx, @NotNull ForgeDirection face, @NotNull Int3 offset) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)face, (String)"face");
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        if (!Mod.GT6.isLoaded()) {
            return null;
        }
        if (!(ctx.block(offset) instanceof MultiTileEntityBlock)) {
            return null;
        }
        TileEntity treeHole = ctx.tileEntity(offset);
        if (!(treeHole instanceof ITreeHoleMTE)) {
            return null;
        }
        return ((ITreeHoleMTE)treeHole).betterFoliage$getTextureForSide(face);
    }
}

