/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mods.mfr.machines;

import cofh.lib.util.WeightedRandomItemStack;
import java.util.ArrayList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.item.WeightedItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandom;
import powercrystals.minefactoryreloaded.MFRRegistry;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.mfr.MiningLaser")
@ModOnly(value={"MineFactoryReloaded"})
public class MiningLaser {
    @ZenMethod
    public static void addOre(WeightedItemStack ore) {
        MineTweakerAPI.apply(new AddOreAction(ore));
    }

    @ZenMethod
    public static void removeOre(IIngredient ore) {
        MineTweakerAPI.apply(new RemoveOreAction(ore));
    }

    @ZenMethod
    public static void addPreferredOre(int color, IIngredient ore) {
        MineTweakerAPI.apply(new AddPreferredOreAction(color, ore));
    }

    @ZenMethod
    public static void removePreferredOre(int color, IIngredient ore) {
        MineTweakerAPI.apply(new RemovePreferredOreAction(color, ore));
    }

    private static class RemovePreferredOreAction
    implements IUndoableAction {
        private final int color;
        private final IIngredient ore;
        private final List<ItemStack> toRemove;

        public RemovePreferredOreAction(int color, IIngredient ore) {
            this.color = color;
            this.ore = ore;
            this.toRemove = new ArrayList<ItemStack>();
            for (ItemStack item : MFRRegistry.getLaserPreferredOres((int)color)) {
                if (!ore.matches(MineTweakerMC.getIItemStack(item))) continue;
                this.toRemove.add(item);
            }
        }

        @Override
        public void apply() {
            MFRRegistry.getLaserPreferredOres((int)this.color).removeAll(this.toRemove);
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            MFRRegistry.getLaserPreferredOres((int)this.color).addAll(this.toRemove);
        }

        @Override
        public String describe() {
            return "Removing preferred ore " + this.ore + " for color " + this.color;
        }

        @Override
        public String describeUndo() {
            return "Adding preferred ore " + this.ore + " for color " + this.color;
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddPreferredOreAction
    implements IUndoableAction {
        private final int color;
        private final IIngredient ore;

        public AddPreferredOreAction(int color, IIngredient ore) {
            this.color = color;
            this.ore = ore;
        }

        @Override
        public void apply() {
            for (IItemStack item : this.ore.getItems()) {
                MFRRegistry.addLaserPreferredOre((int)this.color, (ItemStack)MineTweakerMC.getItemStack(item));
            }
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            for (IItemStack item : this.ore.getItems()) {
                ItemStack stack = MineTweakerMC.getItemStack(item);
                MFRRegistry.getLaserPreferredOres((int)this.color).remove(stack);
            }
        }

        @Override
        public String describe() {
            return "Adding laser preferred ore " + this.ore + " to color " + this.color;
        }

        @Override
        public String describeUndo() {
            return "Removing laser preferred ore " + this.ore + " from color " + this.color;
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    private static class RemoveOreAction
    implements IUndoableAction {
        private final IIngredient ingredient;
        private final List<WeightedRandomItemStack> removed;

        public RemoveOreAction(IIngredient ingredient) {
            this.ingredient = ingredient;
            this.removed = new ArrayList<WeightedRandomItemStack>();
            for (WeightedRandom.Item iStack : MFRRegistry.getLaserOres()) {
                WeightedRandomItemStack stack;
                if (!(iStack instanceof WeightedRandomItemStack) || !ingredient.matches(MineTweakerMC.getIItemStack((stack = (WeightedRandomItemStack)iStack).getStack()))) continue;
                this.removed.add(stack);
            }
        }

        @Override
        public void apply() {
            MFRRegistry.getLaserOres().removeAll(this.removed);
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            MFRRegistry.getLaserOres().addAll(this.removed);
        }

        @Override
        public String describe() {
            return "Removing laser ore " + this.ingredient.toString();
        }

        @Override
        public String describeUndo() {
            return "Restoring laser ore " + this.ingredient.toString();
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddOreAction
    implements IUndoableAction {
        private final WeightedRandomItemStack item;

        public AddOreAction(WeightedItemStack item) {
            this.item = new WeightedRandomItemStack(MineTweakerMC.getItemStack(item.getStack()), (int)item.getChance());
        }

        @Override
        public void apply() {
            MFRRegistry.getLaserOres().add(this.item);
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            MFRRegistry.getLaserOres().remove(this.item);
        }

        @Override
        public String describe() {
            return "Adding laser ore " + this.item.getStack().func_82833_r();
        }

        @Override
        public String describeUndo() {
            return "Removing laser ore " + this.item.getStack().func_82833_r();
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }
}

