/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.bbcode.node;

import java.util.Iterator;
import java.util.LinkedList;
import net.malisis.core.util.bbcode.node.BBStyleNode;
import net.malisis.core.util.bbcode.node.BBTextNode;
import net.malisis.core.util.bbcode.render.BBRenderElement;

public abstract class BBNode
implements Iterable<BBNode> {
    protected String tag;
    protected BBNode parent;
    protected LinkedList<BBNode> children = new LinkedList();
    protected String attribute;
    protected boolean standAlone = false;
    protected int charIndex;

    public BBNode(String tag, String attribute) {
        this.tag = tag;
        this.attribute = attribute;
    }

    public BBNode(String tag) {
        this(tag, "");
    }

    public String getTag() {
        return this.tag;
    }

    public void setParent(BBNode parent) {
        this.parent = parent;
    }

    public BBNode getParent() {
        return this.parent;
    }

    @Override
    public Iterator<BBNode> iterator() {
        return this.children.iterator();
    }

    public void insert(BBNode node) {
        this.insert(node, this.children.size());
    }

    public void insertAfter(BBNode node, BBNode after) {
        this.insert(node, this.children.indexOf(after) + 1);
    }

    public void insertBefore(BBNode node, BBNode before) {
        this.insert(node, this.children.indexOf(before));
    }

    public void insert(BBNode node, int position) {
        if (this.isStandAlone()) {
            throw new IllegalArgumentException("Can't add nodes to " + this.getClass().getSimpleName());
        }
        this.children.add(position, node);
        node.parent = this;
    }

    public void remove(BBNode node) {
        if (this.isStandAlone()) {
            throw new IllegalArgumentException("Can't remove nodes from " + this.getClass().getSimpleName());
        }
        this.children.remove(node);
        node.parent = null;
    }

    public String getAttribute() {
        if (this.attribute != "") {
            return "=" + this.attribute;
        }
        return "";
    }

    public boolean isStandAlone() {
        return this.standAlone;
    }

    public boolean hasTextNode() {
        for (BBNode n : this) {
            if (!n.hasTextNode()) continue;
            return true;
        }
        return false;
    }

    public BBStyleNode getChildStyleNode(String tag) {
        for (BBNode n : this) {
            if (!(n instanceof BBStyleNode) || !n.tag.equals(tag)) continue;
            return (BBStyleNode)n;
        }
        return null;
    }

    public abstract BBNode copy();

    public void clean() {
        if (this.getParent() != null && !this.isStandAlone() && !this.hasTextNode()) {
            this.getParent().remove(this);
            return;
        }
        for (BBNode node : this) {
            node.clean();
        }
        Iterator<BBNode> it = this.iterator();
        BBNode lastNode = null;
        while (it.hasNext()) {
            BBNode node = it.next();
            if (lastNode instanceof BBTextNode && node instanceof BBTextNode) {
                ((BBTextNode)lastNode).append(((BBTextNode)node).getText());
                it.remove();
                continue;
            }
            lastNode = node;
        }
    }

    public void apply(BBRenderElement element) {
    }

    public String toRawString() {
        StringBuilder str = new StringBuilder();
        for (BBNode n : this) {
            str.append(n.toRawString());
        }
        return str.toString();
    }

    public String toBBString() {
        StringBuilder str = new StringBuilder();
        str.append("[" + this.tag);
        str.append(this.getAttribute());
        str.append("]");
        if (this.standAlone) {
            return str.toString();
        }
        for (BBNode n : this) {
            str.append(n.toBBString());
        }
        str.append("[/" + this.tag + "]");
        return str.toString();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " : [" + this.tag + this.getAttribute() + "]";
    }
}

