/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util;

import java.util.HashMap;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;

public class ShaderSystem {
    private HashMap<String, Integer> varLocations = new HashMap();
    private int program = GL20.glCreateProgram();
    private int lastProgram = 0;
    private boolean initialized;
    private boolean active;

    public void init() {
        GL20.glLinkProgram((int)this.program);
        GL20.glValidateProgram((int)this.program);
        this.initialized = true;
        this.active = GL20.glGetProgrami((int)this.program, (int)35714) == 1;
    }

    public void activate() {
        if (!this.initialized) {
            this.init();
        }
        if (this.active) {
            this.lastProgram = GL11.glGetInteger((int)35725);
            GL20.glUseProgram((int)this.program);
        }
    }

    public void deactivate() {
        if (!this.initialized) {
            this.init();
        }
        if (this.active) {
            GL20.glUseProgram((int)this.lastProgram);
        }
    }

    public void addShader(String source, int type) {
        if (!this.initialized) {
            try {
                GL20.glAttachShader((int)this.program, (int)ShaderSystem.createShader(source, type));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setUniform1i(String var, int value) {
        if (this.active) {
            GL20.glUniform1i((int)this.getUniformLocation(var), (int)value);
        }
    }

    public void setUniform2f(String var, float v1, float v2) {
        if (this.active) {
            GL20.glUniform2f((int)this.getUniformLocation(var), (float)v1, (float)v2);
        }
    }

    public int getUniformLocation(String var) {
        if (!this.varLocations.containsKey(var)) {
            this.varLocations.put(var, GL20.glGetUniformLocation((int)this.program, (CharSequence)var));
        }
        return this.varLocations.get(var);
    }

    private static int createShader(String source, int shaderType) throws Exception {
        int shader = 0;
        try {
            shader = GL20.glCreateShader((int)shaderType);
            if (shader == 0) {
                return 0;
            }
            GL20.glShaderSource((int)shader, (CharSequence)source);
            GL20.glCompileShader((int)shader);
            return shader;
        }
        catch (Exception exc) {
            GL20.glDeleteShader((int)shader);
            throw exc;
        }
    }
}

