/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer;

import java.util.LinkedList;
import java.util.List;
import net.malisis.core.renderer.Parameter;
import net.malisis.core.renderer.animation.transformation.ITransformable;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class RenderParameters
implements ITransformable.Color,
ITransformable.Alpha,
ITransformable.Brightness {
    protected List<Parameter> listParams = new LinkedList<Parameter>();
    public Parameter<Boolean> renderAllFaces = new Parameter<Boolean>(false);
    public Parameter<Boolean> useBlockBounds = new Parameter<Boolean>(true);
    public Parameter<AxisAlignedBB> renderBounds = new Parameter<Object>(null);
    public Parameter<Boolean> vertexPositionRelativeToRenderBounds = new Parameter<Boolean>(true);
    public Parameter<Boolean> useCustomTexture = new Parameter<Boolean>(false);
    public Parameter<Boolean> applyTexture = new Parameter<Boolean>(true);
    public Parameter<IIcon> icon = new Parameter<Object>(null);
    public Parameter<Boolean> useWorldSensitiveIcon = new Parameter<Boolean>(true);
    public Parameter<Boolean> useTexture = new Parameter<Boolean>(true);
    public Parameter<Boolean> interpolateUV = new Parameter<Boolean>(true);
    public Parameter<Boolean> calculateAOColor = new Parameter<Boolean>(true);
    public Parameter<Boolean> calculateBrightness = new Parameter<Boolean>(true);
    public Parameter<Boolean> usePerVertexColor = new Parameter<Boolean>(false);
    public Parameter<Boolean> usePerVertexAlpha = new Parameter<Boolean>(false);
    public Parameter<Boolean> usePerVertexBrightness = new Parameter<Boolean>(false);
    public Parameter<Boolean> useEnvironmentBrightness = new Parameter<Boolean>(true);
    public Parameter<Boolean> useNormals = new Parameter<Boolean>(false);
    public Parameter<Integer> colorMultiplier = new Parameter<Object>(null);
    public Parameter<Float> colorFactor = new Parameter<Float>(Float.valueOf(1.0f));
    public Parameter<Integer> brightness = new Parameter<Integer>(0xF00000);
    public Parameter<Integer> alpha = new Parameter<Integer>(255);
    public Parameter<ForgeDirection> direction = new Parameter<Object>(null);
    public Parameter<ForgeDirection> textureSide = new Parameter<Object>(null);
    public Parameter<int[][][]> aoMatrix = new Parameter<Object>(null);
    public Parameter<Boolean> flipU = new Parameter<Boolean>(false);
    public Parameter<Boolean> flipV = new Parameter<Boolean>(false);

    public RenderParameters() {
        this.listParams.add(this.renderAllFaces);
        this.listParams.add(this.useBlockBounds);
        this.listParams.add(this.renderBounds);
        this.listParams.add(this.vertexPositionRelativeToRenderBounds);
        this.listParams.add(this.useCustomTexture);
        this.listParams.add(this.applyTexture);
        this.listParams.add(this.icon);
        this.listParams.add(this.useWorldSensitiveIcon);
        this.listParams.add(this.useTexture);
        this.listParams.add(this.interpolateUV);
        this.listParams.add(this.calculateAOColor);
        this.listParams.add(this.calculateBrightness);
        this.listParams.add(this.usePerVertexColor);
        this.listParams.add(this.usePerVertexAlpha);
        this.listParams.add(this.usePerVertexBrightness);
        this.listParams.add(this.useEnvironmentBrightness);
        this.listParams.add(this.useNormals);
        this.listParams.add(this.colorMultiplier);
        this.listParams.add(this.colorFactor);
        this.listParams.add(this.brightness);
        this.listParams.add(this.alpha);
        this.listParams.add(this.direction);
        this.listParams.add(this.textureSide);
        this.listParams.add(this.aoMatrix);
        this.listParams.add(this.flipU);
        this.listParams.add(this.flipV);
    }

    public RenderParameters(RenderParameters params) {
        this();
        this.merge(params);
    }

    private Parameter getParameter(int index) {
        if (index < 0 || index >= this.listParams.size()) {
            return null;
        }
        return this.listParams.get(index);
    }

    public void reset() {
        for (Parameter param : this.listParams) {
            param.reset();
        }
    }

    public void merge(RenderParameters params) {
        if (params == null) {
            return;
        }
        for (int i = 0; i < this.listParams.size(); ++i) {
            this.getParameter(i).merge(params.getParameter(i));
        }
    }

    @Override
    public void setAlpha(int alpha) {
        this.alpha.set(alpha);
    }

    @Override
    public void setColor(int color) {
        this.colorMultiplier.set(color);
    }

    @Override
    public void setBrightness(int brightness) {
        this.brightness.set(brightness);
    }
}

