/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.configuration;

import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.malisis.core.client.gui.Anchor;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.component.container.UIContainer;
import net.malisis.core.client.gui.component.container.UIPanel;
import net.malisis.core.client.gui.component.container.UIWindow;
import net.malisis.core.client.gui.component.decoration.UILabel;
import net.malisis.core.client.gui.component.interaction.UIButton;
import net.malisis.core.client.gui.event.component.StateChangeEvent;
import net.malisis.core.configuration.Settings;
import net.malisis.core.configuration.setting.Setting;
import org.apache.commons.lang3.StringUtils;

public class ConfigurationGui
extends MalisisGui {
    private Settings settings;
    protected ArrayList<UIPanel> pannels = new ArrayList();
    protected HashMap<UIComponent, Setting> componentSettings = new HashMap();
    protected int windowWidth = 400;
    protected int windowHeight = 120;
    protected UILabel comment;
    protected UIButton btnCancel;
    protected UIButton btnSave;

    public ConfigurationGui(Settings settings) {
        this.settings = settings;
    }

    @Override
    public void construct() {
        Set<String> categories = this.settings.getCategories();
        if (categories.size() > 1) {
            // empty if block
        }
        UIWindow window = new UIWindow(this, "config.title", this.windowWidth, this.windowHeight);
        for (String category : categories) {
            this.windowHeight = Math.max(this.windowHeight, this.settings.getSettings(category).size() * 14 + 40);
            window.add(this.createSettingContainer(category));
        }
        window.setSize(this.windowWidth, this.windowHeight);
        this.comment = new UILabel((MalisisGui)this, true);
        this.comment.getFontRenderOptions().color = 0xFFFFFF;
        this.comment.getFontRenderOptions().shadow = true;
        UIPanel panelComment = (UIPanel)new UIPanel(this, 140, this.windowHeight - 35).setPosition(0, 0, Anchor.RIGHT);
        panelComment.setBackgroundColor(0xCCCCCC);
        panelComment.add(this.comment);
        this.btnCancel = (UIButton)((UIButton)new UIButton((MalisisGui)this, "gui.cancel").setPosition(-32, 0, Anchor.BOTTOM | Anchor.CENTER)).register((Object)this);
        this.btnSave = (UIButton)((UIButton)new UIButton((MalisisGui)this, "gui.done").setPosition(32, 0, Anchor.BOTTOM | Anchor.CENTER)).register((Object)this);
        window.add(panelComment);
        window.add(this.btnCancel);
        window.add(this.btnSave);
        this.addToScreen(window);
    }

    private UIContainer createSettingContainer(String category) {
        List<Setting> categorySettings = this.settings.getSettings(category);
        UIContainer container = (UIContainer)new UIContainer(this, this.windowWidth - 105, this.windowHeight - 35).setPosition(5, 12);
        int y = 0;
        for (Setting setting : categorySettings) {
            UIComponent component = setting.getComponent(this);
            component.setPosition(0, y);
            component.register((Object)this);
            container.add(component);
            this.componentSettings.put(component, setting);
            y += component.getHeight() + 2;
        }
        return container;
    }

    @Subscribe
    public void onMouseOver(StateChangeEvent.HoveredStateChange event) {
        if (event.getState()) {
            Setting setting = this.componentSettings.get(event.getComponent());
            if (setting != null) {
                String str = StringUtils.join((Object[])setting.getComments(), (String)"\r");
                this.comment.setText(str);
            }
        } else {
            this.comment.setText("");
        }
    }

    @Subscribe
    public void onButtonClick(UIButton.ClickEvent event) {
        if (event.getComponent() == this.btnCancel) {
            this.close();
        } else {
            Set<String> categories = this.settings.getCategories();
            for (String category : categories) {
                List<Setting> categorySettings = this.settings.getSettings(category);
                for (Setting setting : categorySettings) {
                    setting.set(setting.getValueFromComponent());
                }
            }
            this.settings.save();
            this.close();
        }
    }
}

