/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.network.message;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import team.chisel.Chisel;
import team.chisel.network.message.base.MessageCoords;

public class MessageSlotUpdate
extends MessageCoords {
    private int slot;
    private ItemStack stack;

    public MessageSlotUpdate() {
    }

    public MessageSlotUpdate(TileEntity te, int slot, ItemStack stack) {
        super(te);
        this.slot = slot;
        this.stack = stack;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.slot);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.stack);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.slot = buf.readInt();
        this.stack = ByteBufUtils.readItemStack((ByteBuf)buf);
    }

    public static class Handler
    implements IMessageHandler<MessageSlotUpdate, IMessage> {
        public IMessage onMessage(MessageSlotUpdate message, MessageContext ctx) {
            TileEntity te = Chisel.proxy.getClientWorld().func_147438_o(message.x, message.y, message.z);
            if (te != null && te instanceof IInventory) {
                ((IInventory)te).func_70299_a(message.slot, message.stack);
            }
            return null;
        }
    }
}

