/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.item.chisel;

import com.cricketcraft.chisel.api.IChiselItem;
import com.cricketcraft.chisel.api.Statistics;
import com.cricketcraft.chisel.api.carving.ICarvingVariation;
import com.cricketcraft.chisel.api.carving.IChiselMode;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import team.chisel.network.PacketHandler;
import team.chisel.network.message.MessageChiselSound;

public enum ChiselMode implements IChiselMode
{
    SINGLE{

        @Override
        public void chiselAll(EntityPlayer player, World world, int x, int y, int z, ForgeDirection side, ICarvingVariation variation) {
            ChiselMode.setVariation(player, world, x, y, z, world.func_147439_a(x, y, z), world.func_72805_g(x, y, z), variation);
        }
    }
    ,
    PANEL{

        @Override
        public void chiselAll(EntityPlayer player, World world, int x, int y, int z, ForgeDirection side, ICarvingVariation variation) {
            Block block = world.func_147439_a(x, y, z);
            int meta = world.func_72805_g(x, y, z);
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dy = -1; dy <= 1; ++dy) {
                    if (side == ForgeDirection.UP || side == ForgeDirection.DOWN) {
                        ChiselMode.setVariation(player, world, x + dx, y, z + dy, block, meta, variation);
                        continue;
                    }
                    if (side == ForgeDirection.EAST || side == ForgeDirection.WEST) {
                        ChiselMode.setVariation(player, world, x, y + dy, z + dx, block, meta, variation);
                        continue;
                    }
                    ChiselMode.setVariation(player, world, x + dx, y + dy, z, block, meta, variation);
                }
            }
        }
    }
    ,
    COLUMN{

        @Override
        public void chiselAll(EntityPlayer player, World world, int x, int y, int z, ForgeDirection side, ICarvingVariation variation) {
            Block block = world.func_147439_a(x, y, z);
            int meta = world.func_72805_g(x, y, z);
            int facing = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            for (int i = -1; i <= 1; ++i) {
                if (side != ForgeDirection.DOWN && side != ForgeDirection.UP) {
                    ChiselMode.setVariation(player, world, x, y + i, z, block, meta, variation);
                    continue;
                }
                if (facing == 0 || facing == 2) {
                    ChiselMode.setVariation(player, world, x, y, z + i, block, meta, variation);
                    continue;
                }
                ChiselMode.setVariation(player, world, x + i, y, z, block, meta, variation);
            }
        }
    }
    ,
    ROW{

        @Override
        public void chiselAll(EntityPlayer player, World world, int x, int y, int z, ForgeDirection side, ICarvingVariation variation) {
            Block block = world.func_147439_a(x, y, z);
            int meta = world.func_72805_g(x, y, z);
            int facing = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            for (int i = -1; i <= 1; ++i) {
                if (side != ForgeDirection.DOWN && side != ForgeDirection.UP) {
                    if (side == ForgeDirection.EAST || side == ForgeDirection.WEST) {
                        ChiselMode.setVariation(player, world, x, y, z + i, block, meta, variation);
                        continue;
                    }
                    ChiselMode.setVariation(player, world, x + i, y, z, block, meta, variation);
                    continue;
                }
                if (facing == 0 || facing == 2) {
                    ChiselMode.setVariation(player, world, x + i, y, z, block, meta, variation);
                    continue;
                }
                ChiselMode.setVariation(player, world, x, y, z + i, block, meta, variation);
            }
        }
    };


    private static void setVariation(EntityPlayer player, World world, int x, int y, int z, Block origBlock, int origMeta, ICarvingVariation v) {
        Block block = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        ItemStack held = player.func_71045_bC();
        if (block == v.getBlock() && meta == v.getBlockMeta()) {
            return;
        }
        if (origBlock != block || origMeta != meta) {
            return;
        }
        if (held != null && held.func_77973_b() instanceof IChiselItem) {
            if (origBlock == v.getBlock()) {
                world.func_72921_c(x, y, z, v.getBlockMeta(), 3);
            } else {
                world.func_147465_d(x, y, z, v.getBlock(), v.getBlockMeta(), 3);
            }
            player.func_71064_a(Statistics.blocksChiseled, 1);
            boolean breakChisel = false;
            if (((IChiselItem)player.func_71045_bC().func_77973_b()).onChisel(world, player.func_71045_bC(), v)) {
                player.func_71045_bC().func_77972_a(1, (EntityLivingBase)player);
                if (player.func_71045_bC().field_77994_a <= 0) {
                    player.func_70062_b(0, null);
                    breakChisel = true;
                }
            }
            PacketHandler.INSTANCE.sendTo((IMessage)new MessageChiselSound(x, y, z, v, breakChisel), (EntityPlayerMP)player);
        }
    }

    public static ChiselMode next(IChiselMode currentMode) {
        if (currentMode instanceof ChiselMode) {
            ChiselMode[] values = ChiselMode.values();
            return values[(((ChiselMode)currentMode).ordinal() + 1) % values.length];
        }
        return SINGLE;
    }
}

