/*
 * Decompiled with CFR 0.152.
 */
package com.cricketcraft.chisel.api.carving;

import com.cricketcraft.chisel.api.carving.ICarvingGroup;
import com.cricketcraft.chisel.api.carving.ICarvingRegistry;
import com.cricketcraft.chisel.api.carving.ICarvingVariation;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

public class CarvingUtils {
    public static ICarvingRegistry chisel;

    public static int compare(ICarvingVariation v1, ICarvingVariation v2) {
        return v1.getOrder() - v2.getOrder();
    }

    public static ItemStack getStack(ICarvingVariation variation) {
        return new ItemStack(variation.getBlock(), 1, variation.getItemMeta());
    }

    public static ICarvingRegistry getChiselRegistry() {
        return chisel;
    }

    public static ICarvingVariation getDefaultVariationFor(Block block, int metadata, int order) {
        return new SimpleCarvingVariation(block, metadata, order);
    }

    public static ICarvingGroup getDefaultGroupFor(String name) {
        return new SimpleCarvingGroup(name);
    }

    public static class SimpleCarvingGroup
    implements ICarvingGroup {
        private String name;
        private String sound;
        private String oreName;
        private List<ICarvingVariation> variations = Lists.newArrayList();

        public SimpleCarvingGroup(String name) {
            this.name = name;
        }

        @Override
        public List<ICarvingVariation> getVariations() {
            return Lists.newArrayList(this.variations);
        }

        @Override
        public void addVariation(ICarvingVariation variation) {
            this.variations.add(variation);
            Collections.sort(this.variations, new Comparator<ICarvingVariation>(){

                @Override
                public int compare(ICarvingVariation o1, ICarvingVariation o2) {
                    return CarvingUtils.compare(o1, o2);
                }
            });
        }

        @Override
        public boolean removeVariation(ICarvingVariation variation) {
            ICarvingVariation toRemove = null;
            for (ICarvingVariation v : this.variations) {
                if (v.getBlock() != variation.getBlock() || v.getBlockMeta() != variation.getBlockMeta()) continue;
                toRemove = v;
            }
            return toRemove == null ? false : this.variations.remove(toRemove);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getSound() {
            return this.sound;
        }

        @Override
        public void setSound(String sound) {
            this.sound = sound;
        }

        @Override
        public String getOreName() {
            return this.oreName;
        }

        @Override
        public void setOreName(String oreName) {
            this.oreName = oreName;
        }
    }

    public static class SimpleCarvingVariation
    implements ICarvingVariation {
        private int order;
        private Block block;
        private int meta;
        private int damage;

        public SimpleCarvingVariation(Block block, int metadata, int order) {
            this.order = order;
            this.block = block;
            this.meta = metadata;
            this.damage = metadata;
        }

        @Override
        public Block getBlock() {
            return this.block;
        }

        @Override
        public int getBlockMeta() {
            return this.meta;
        }

        @Override
        public int getItemMeta() {
            return this.damage;
        }

        @Override
        public int getOrder() {
            return this.order;
        }
    }
}

