/*
 * Decompiled with CFR 0.152.
 */
package toast.specialAI.util;

import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;

public class EntitySet {
    private final EntryEntity[] ENTRIES;

    public EntitySet(String line) {
        String[] list;
        ArrayList<EntryEntity> entryList = new ArrayList<EntryEntity>();
        block0: for (String item : list = line.split(",")) {
            Class entityClass;
            boolean extendable = true;
            if (item.startsWith("~")) {
                item = item.substring(1);
                extendable = false;
            }
            if ((entityClass = (Class)EntityList.field_75625_b.get(item)) == null) continue;
            EntryEntity entry = new EntryEntity(entityClass, extendable);
            Iterator iterator = entryList.iterator();
            while (iterator.hasNext()) {
                EntryEntity currentEntry = (EntryEntity)iterator.next();
                if (currentEntry.contains(entry)) continue block0;
                if (!entry.contains(currentEntry)) continue;
                iterator.remove();
            }
            entryList.add(entry);
        }
        this.ENTRIES = entryList.toArray(new EntryEntity[0]);
    }

    public boolean contains(Entity entity) {
        EntryEntity entry = new EntryEntity(entity.getClass(), false);
        for (EntryEntity currentEntry : this.ENTRIES) {
            if (!currentEntry.contains(entry)) continue;
            return true;
        }
        return false;
    }

    private static class EntryEntity {
        public final Class CLASS;
        public final boolean EXTEND;

        public EntryEntity(Class entityClass, boolean extend) {
            this.CLASS = entityClass;
            this.EXTEND = extend;
        }

        public boolean contains(EntryEntity entry) {
            if (this.CLASS == entry.CLASS) {
                return !entry.EXTEND;
            }
            if (this.EXTEND) {
                return this.CLASS.isAssignableFrom(entry.CLASS);
            }
            return false;
        }
    }
}

