/*
 * Decompiled with CFR 0.152.
 */
package toast.specialAI.ai.special;

import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S12PacketEntityVelocity;
import toast.specialAI.EffectHelper;
import toast.specialAI.ai.special.ISpecialAI;

public class EntityAIThrowPlayer
extends EntityAIBase
implements ISpecialAI {
    private int WEIGHT;
    protected EntityLiving theEntity;
    private EntityLiving throwTarget;
    private byte attackTime;
    private int giveUpDelay;

    public EntityAIThrowPlayer() {
    }

    private EntityAIThrowPlayer(EntityLiving entity) {
        this.theEntity = entity;
        this.func_75248_a(3);
    }

    @Override
    public String getName() {
        return "throw_player";
    }

    @Override
    public int getWeight() {
        return this.WEIGHT;
    }

    @Override
    public void setWeight(int weight) {
        this.WEIGHT = weight;
    }

    @Override
    public void addTo(EntityLiving entity, NBTTagCompound aiTag) {
        entity.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIThrowPlayer(entity));
    }

    @Override
    public void save(NBTTagCompound aiTag) {
        aiTag.func_74774_a(this.getName(), (byte)1);
    }

    @Override
    public boolean isSaved(NBTTagCompound aiTag) {
        return aiTag.func_74771_c(this.getName()) > 0;
    }

    @Override
    public void initialize(EntityLiving entity) {
        ItemStack helmet = new ItemStack((Item)Items.field_151024_Q);
        helmet.func_151001_c("Helmet of Strength");
        EffectHelper.addModifier(helmet, SharedMonsterAttributes.field_111264_e, 1.0, 0);
        Items.field_151024_Q.func_82813_b(helmet, 0xFF0000);
        entity.func_70062_b(4, helmet);
        entity.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111121_a(new AttributeModifier(UUID.randomUUID(), "Thrower knockback resistance", 1.0, 0));
        entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(new AttributeModifier(UUID.randomUUID(), "Thrower speed boost", 0.3, 1));
    }

    public boolean func_75250_a() {
        if (this.attackTime > 0) {
            this.attackTime = (byte)(this.attackTime - 1);
            return false;
        }
        return this.theEntity.func_70638_az() != null && this.theEntity.func_70638_az().field_70122_E && this.theEntity.field_70154_o == null && this.theEntity.func_70681_au().nextInt(20) == 0 && this.findThrowTarget();
    }

    public void func_75249_e() {
        this.theEntity.func_70661_as().func_75497_a((Entity)this.theEntity.func_70638_az(), 1.5);
    }

    public boolean func_75253_b() {
        return this.theEntity.func_70638_az() != null && this.theEntity.field_70154_o == null && this.throwTarget != null && this.throwTarget.func_70089_S();
    }

    public boolean func_75252_g() {
        return false;
    }

    public void func_75246_d() {
        if (this.theEntity.field_70153_n == null) {
            EntityLivingBase target = this.theEntity.func_70638_az();
            this.theEntity.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
            double range = this.theEntity.field_70130_N * 2.0f * this.theEntity.field_70130_N * 2.0f + target.field_70130_N;
            if (this.theEntity.func_70092_e(target.field_70165_t, target.field_70121_D.field_72338_b, target.field_70161_v) <= range) {
                target.func_70078_a((Entity)this.theEntity);
                this.theEntity.func_70661_as().func_75497_a((Entity)this.throwTarget, 1.2);
                this.theEntity.func_71038_i();
                this.attackTime = (byte)10;
            } else if (this.theEntity.func_70661_as().func_75500_f()) {
                this.theEntity.func_70661_as().func_75497_a((Entity)target, 1.5);
            }
        } else {
            this.theEntity.func_70671_ap().func_75651_a((Entity)this.throwTarget, 30.0f, 30.0f);
            if (this.attackTime > 0) {
                this.attackTime = (byte)(this.attackTime - 1);
            } else if (this.theEntity.func_70681_au().nextInt(10) == 0 && this.theEntity.func_70068_e((Entity)this.throwTarget) <= 100.0) {
                double dX = this.throwTarget.field_70165_t - this.theEntity.field_70165_t;
                double dZ = this.throwTarget.field_70161_v - this.theEntity.field_70161_v;
                double dH = Math.sqrt(dX * dX + dZ * dZ);
                Entity entity = this.theEntity.field_70153_n;
                entity.func_70078_a((Entity)null);
                entity.field_70159_w = dX / dH + this.theEntity.field_70159_w * 0.2;
                entity.field_70179_y = dZ / dH + this.theEntity.field_70179_y * 0.2;
                entity.field_70181_x = 0.4;
                entity.field_70122_E = false;
                entity.field_70143_R = 0.0f;
                if (entity instanceof EntityPlayerMP) {
                    try {
                        ((EntityPlayerMP)entity).field_71135_a.func_147359_a((Packet)new S12PacketEntityVelocity(entity));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                this.theEntity.func_70661_as().func_75499_g();
                this.theEntity.func_71038_i();
                this.attackTime = (byte)80;
            } else if (this.theEntity.func_70661_as().func_75500_f()) {
                this.theEntity.func_70661_as().func_75497_a((Entity)this.throwTarget, 1.2);
            }
        }
        if (++this.giveUpDelay > 400) {
            this.theEntity.func_70661_as().func_75499_g();
            this.throwTarget = null;
        }
    }

    public void func_75251_c() {
        if (this.theEntity.field_70153_n != null) {
            this.theEntity.field_70153_n.func_70078_a((Entity)null);
        }
        this.theEntity.func_70661_as().func_75499_g();
        this.giveUpDelay = 0;
        this.throwTarget = null;
    }

    private boolean findThrowTarget() {
        EntityLivingBase target = this.theEntity.func_70638_az();
        List list = this.theEntity.field_70170_p.func_72839_b((Entity)this.theEntity, target.field_70121_D.func_72314_b(16.0, 8.0, 16.0));
        int mostNearby = -1;
        for (Object obj : list) {
            EntityLiving entity;
            if (!(obj instanceof EntityLiving) || target != (entity = (EntityLiving)obj).func_70638_az()) continue;
            if (entity.func_70068_e((Entity)target) <= 9.0) {
                this.throwTarget = null;
                return false;
            }
            int nearby = entity.field_70170_p.func_72839_b((Entity)entity, entity.field_70121_D.func_72314_b(4.0, 1.0, 4.0)).size();
            if (nearby <= mostNearby) continue;
            mostNearby = nearby;
            this.throwTarget = entity;
        }
        return this.throwTarget != null;
    }
}

