/*
 * Decompiled with CFR 0.152.
 */
package toast.specialAI.ai.special;

import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import toast.specialAI.ai.special.ISpecialAI;

public class EntityAIBarrage
extends EntityAIBase
implements ISpecialAI {
    private static final byte STATE_END = 0;
    private static final byte STATE_START = 1;
    private static final byte STATE_SHOOT = 2;
    private int WEIGHT;
    protected EntityLiving theEntity;
    private float arrowDamage;
    private byte state;
    private byte attackTime;
    private double x;
    private double y;
    private double z;

    public EntityAIBarrage() {
    }

    private EntityAIBarrage(EntityLiving entity, float arrowDamage) {
        this.theEntity = entity;
        this.arrowDamage = arrowDamage;
        this.func_75248_a(7);
    }

    @Override
    public String getName() {
        return "barrage";
    }

    @Override
    public int getWeight() {
        return this.WEIGHT;
    }

    @Override
    public void setWeight(int weight) {
        this.WEIGHT = weight;
    }

    @Override
    public void addTo(EntityLiving entity, NBTTagCompound aiTag) {
        entity.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIBarrage(entity, aiTag.func_74760_g(this.getName())));
    }

    @Override
    public void save(NBTTagCompound aiTag) {
        aiTag.func_74776_a(this.getName(), 3.0f);
    }

    @Override
    public boolean isSaved(NBTTagCompound aiTag) {
        return aiTag.func_74760_g(this.getName()) > 0.0f;
    }

    @Override
    public void initialize(EntityLiving entity) {
        entity.func_70062_b(4, new ItemStack(Blocks.field_150367_z));
        float healthDiff = entity.func_110138_aP() - entity.func_110143_aJ();
        entity.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(new AttributeModifier(UUID.randomUUID(), "Barrager health boost", 20.0, 0));
        entity.func_70606_j(entity.func_110138_aP() - healthDiff);
    }

    public boolean func_75250_a() {
        block5: {
            block4: {
                if (!this.theEntity.field_70122_E || this.theEntity.field_70154_o != null) break block4;
                byte by = this.attackTime;
                this.attackTime = (byte)(by - 1);
                if (by <= 0 && this.theEntity.func_70681_au().nextInt(10) == 0) break block5;
            }
            return false;
        }
        EntityLivingBase target = this.theEntity.func_70638_az();
        if (target != null) {
            double distance = this.theEntity.func_70068_e((Entity)target);
            return distance <= 256.0 && distance >= 25.0 && this.theEntity.func_70635_at().func_75522_a((Entity)target);
        }
        return false;
    }

    public boolean func_75253_b() {
        return this.state != 0;
    }

    public boolean func_75252_g() {
        return false;
    }

    public void func_75249_e() {
        this.theEntity.func_70661_as().func_75499_g();
        this.attackTime = (byte)30;
        this.state = 1;
        this.theEntity.func_71038_i();
        this.theEntity.field_70170_p.func_72956_a((Entity)this.theEntity, "random.click", 1.0f, 1.0f / (this.theEntity.func_70681_au().nextFloat() * 0.4f + 0.8f));
    }

    public void func_75246_d() {
        EntityLivingBase target = this.theEntity.func_70638_az();
        this.attackTime = (byte)(this.attackTime - 1);
        if (this.state == 1) {
            if (target == null || !target.func_70089_S()) {
                this.state = 0;
                return;
            }
            this.theEntity.func_70671_ap().func_75651_a((Entity)target, 100.0f, 100.0f);
            if (this.attackTime <= 0) {
                this.x = target.field_70165_t - this.theEntity.field_70165_t;
                this.z = target.field_70161_v - this.theEntity.field_70161_v;
                this.y = target.field_70121_D.field_72338_b + (double)(target.field_70131_O / 3.0f) - this.theEntity.field_70163_u - (double)this.theEntity.func_70047_e() + Math.sqrt(this.x * this.x + this.z * this.z) * 0.2;
                this.attackTime = (byte)60;
                this.state = (byte)2;
            }
        } else if (this.state == 2) {
            this.theEntity.func_70671_ap().func_75650_a(this.theEntity.field_70165_t + this.x, this.theEntity.field_70163_u + (double)this.theEntity.func_70047_e(), this.theEntity.field_70161_v + this.z, 100.0f, 100.0f);
            if (this.attackTime % 5 == 0) {
                EntityArrow arrow = new EntityArrow(this.theEntity.field_70170_p, this.theEntity.field_70165_t, this.theEntity.field_70163_u + (double)this.theEntity.func_70047_e(), this.theEntity.field_70161_v);
                arrow.field_70250_c = this.theEntity;
                arrow.func_70239_b((double)this.arrowDamage + this.theEntity.func_70681_au().nextGaussian() * 0.5 + (double)this.theEntity.field_70170_p.field_73013_u.func_151525_a() * 0.22);
                arrow.func_70186_c(this.x, this.y, this.z, 1.8f, 20.0f);
                if (this.theEntity.func_70027_ad()) {
                    arrow.func_70015_d(100);
                }
                this.theEntity.field_70170_p.func_72956_a((Entity)this.theEntity, "random.bow", 1.0f, 1.0f / (this.theEntity.func_70681_au().nextFloat() * 0.4f + 0.8f));
                this.theEntity.field_70170_p.func_72838_d((Entity)arrow);
            } else if (this.attackTime <= 0) {
                this.state = 0;
            }
        }
    }

    public void func_75251_c() {
        this.attackTime = (byte)60;
    }
}

