/*
 * Decompiled with CFR 0.152.
 */
package toast.specialAI.ai.grief;

import java.util.HashSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFire;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockOre;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.WorldServer;
import toast.specialAI.Properties;
import toast.specialAI._SpecialAI;
import toast.specialAI.ai.AIHandler;
import toast.specialAI.ai.grief.EntityFakePlayer;
import toast.specialAI.util.BlockHelper;
import toast.specialAI.util.TargetBlock;

public class EntityAIGriefBlocks
extends EntityAIBase {
    private static final int SCAN_RANGE = Math.max(0, Properties.getInt("passive_griefing", "grief_scan_range")) + 1;
    private static final int SCAN_RANGE_VERTICAL = Math.max(0, Properties.getInt("passive_griefing", "grief_scan_range_vertical")) + 1;
    private static final boolean GRIEF_NEEDS_TOOL = Properties.getBoolean("passive_griefing", "requires_tools");
    private static final boolean GRIEF_TARGETS_LIGHTS = Properties.getBoolean("passive_griefing", "break_lights");
    private static final HashSet<TargetBlock> GRIEF_TARGET_BLOCKS = BlockHelper.newBlockSet(Properties.getString("passive_griefing", "target_blocks"));
    private static final HashSet<TargetBlock> GRIEF_BLACKLIST = BlockHelper.newBlockSet(Properties.getString("passive_griefing", "target_blacklist"));
    private static final HashSet<TargetBlock> FIDDLE_TARGET_BLOCKS = BlockHelper.newBlockSet(Properties.getString("passive_griefing", "target_fiddling_blocks"));
    private static final HashSet<TargetBlock> FIDDLE_BLACKLIST = BlockHelper.newBlockSet(Properties.getString("passive_griefing", "target_fiddling_blacklist"));
    private static final int SCAN_COUNT = Properties.getInt("passive_griefing", "scan_count");
    private static final boolean BREAK_SOUND = Properties.getBoolean("passive_griefing", "break_sound");
    private static final boolean LEAVE_DROPS = Properties.getBoolean("passive_griefing", "leave_drops");
    private static final boolean MAD_CREEPERS = Properties.getBoolean("passive_griefing", "mad_creepers");
    private static final float REACH = (float)(Properties.getDouble("passive_griefing", "grief_range") * Properties.getDouble("passive_griefing", "grief_range"));
    protected EntityLiving theEntity;
    protected Random random;
    private int scanRange;
    private int scanRangeY;
    private final boolean griefing;
    private boolean griefNeedsTool;
    private boolean griefTargetsLights;
    private HashSet<TargetBlock> griefTargetBlocks;
    private HashSet<TargetBlock> griefBlacklist;
    private final boolean fiddling;
    private HashSet<TargetBlock> fiddleTargetBlocks;
    private HashSet<TargetBlock> fiddleBlacklist;
    private Activity activity = Activity.NONE;
    private boolean canSee;
    private int sightCounter;
    private int giveUpDelay;
    private int fiddleDelay;
    private int blockX;
    private int blockY;
    private int blockZ;
    private Block targetBlock;
    private int hitCounter;
    private float blockDamage;

    public EntityAIGriefBlocks(EntityLiving entity, boolean griefing, boolean fiddling, NBTTagCompound tag) {
        this.theEntity = entity;
        this.random = entity.func_70681_au();
        this.griefing = griefing;
        this.fiddling = fiddling;
        this.func_75248_a(3);
        this.scanRange = tag.func_74764_b("GriefScanRange") ? (int)tag.func_74771_c("GriefScanRange") : SCAN_RANGE;
        this.scanRangeY = tag.func_74764_b("GriefScanRangeVertical") ? (int)tag.func_74771_c("GriefScanRangeVertical") : SCAN_RANGE_VERTICAL;
        if (griefing) {
            this.griefNeedsTool = tag.func_74764_b("GriefNeedsTool") ? tag.func_74767_n("GriefNeedsTool") : GRIEF_NEEDS_TOOL;
            this.griefTargetsLights = tag.func_74764_b("GriefLights") ? tag.func_74767_n("GriefLights") : GRIEF_TARGETS_LIGHTS;
            this.griefTargetBlocks = tag.func_74764_b("GriefBlocks") ? BlockHelper.newBlockSet(tag.func_74779_i("GriefBlocks")) : GRIEF_TARGET_BLOCKS;
            this.griefBlacklist = tag.func_74764_b("GriefBlacklist") ? BlockHelper.newBlockSet(tag.func_74779_i("GriefBlacklist")) : GRIEF_BLACKLIST;
        }
        if (fiddling) {
            this.fiddleTargetBlocks = tag.func_74764_b("FiddleBlocks") ? BlockHelper.newBlockSet(tag.func_74779_i("FiddleBlocks")) : FIDDLE_TARGET_BLOCKS;
            this.fiddleBlacklist = tag.func_74764_b("FiddleBlacklist") ? BlockHelper.newBlockSet(tag.func_74779_i("FiddleBlacklist")) : FIDDLE_BLACKLIST;
        }
    }

    public boolean func_75250_a() {
        if (this.theEntity.field_70154_o == null && this.theEntity.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) {
            --this.fiddleDelay;
            int X = (int)Math.floor(this.theEntity.field_70165_t);
            int Y = (int)Math.floor(this.theEntity.field_70163_u);
            int Z = (int)Math.floor(this.theEntity.field_70161_v);
            for (int i = 0; i < SCAN_COUNT && AIHandler.canScan(); ++i) {
                int z;
                int y;
                int x = X + this.random.nextInt(this.scanRange) - this.random.nextInt(this.scanRange);
                if (!this.tryTargetBlock(x, y = Y + this.random.nextInt(this.scanRangeY) - this.random.nextInt(this.scanRangeY), z = Z + this.random.nextInt(this.scanRange) - this.random.nextInt(this.scanRange))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean func_75253_b() {
        switch (this.activity) {
            case GRIEFING: {
                return this.continueExecutingGriefing();
            }
            case FIDDLING: {
                return this.continueExecutingFiddling();
            }
        }
        return false;
    }

    private boolean continueExecutingGriefing() {
        return this.theEntity.field_70154_o == null && (this.blockDamage > 0.0f || this.giveUpDelay < 400) && this.theEntity.field_70170_p.func_147439_a(this.blockX, this.blockY, this.blockZ) == this.targetBlock;
    }

    private boolean continueExecutingFiddling() {
        return this.theEntity.field_70154_o == null && this.giveUpDelay < 400 && this.theEntity.field_70170_p.func_147439_a(this.blockX, this.blockY, this.blockZ) == this.targetBlock;
    }

    public boolean func_75252_g() {
        return Activity.GRIEFING.equals((Object)this.activity) && (!MAD_CREEPERS || !(this.theEntity instanceof EntityCreeper) || this.blockDamage == 0.0f);
    }

    public void func_75249_e() {
        this.canSee = false;
        this.blockDamage = 0.0f;
        this.hitCounter = 0;
        this.theEntity.func_70661_as().func_75492_a((double)this.blockX, (double)this.blockY, (double)this.blockZ, 1.0);
    }

    public void func_75251_c() {
        this.blockDamage = 0.0f;
        this.giveUpDelay = 0;
        this.targetBlock = null;
        if (!this.theEntity.func_70661_as().func_75500_f()) {
            this.theEntity.func_70661_as().func_75499_g();
        }
        switch (this.activity) {
            case GRIEFING: {
                this.resetTaskGriefing();
                break;
            }
            case FIDDLING: {
                this.resetTaskFiddling();
                break;
            }
        }
        this.activity = Activity.NONE;
    }

    private void resetTaskGriefing() {
        if (MAD_CREEPERS && this.theEntity instanceof EntityCreeper) {
            ((EntityCreeper)this.theEntity).func_70829_a(-1);
        } else {
            this.theEntity.field_70170_p.func_147443_d(this.theEntity.func_145782_y(), this.blockX, this.blockY, this.blockZ, -1);
        }
    }

    private void resetTaskFiddling() {
        this.fiddleDelay = 10;
    }

    public void func_75246_d() {
        switch (this.activity) {
            case GRIEFING: {
                this.updateTaskGriefing();
                break;
            }
            case FIDDLING: {
                this.updateTaskFiddling();
                break;
            }
        }
    }

    private void updateTaskGriefing() {
        this.theEntity.func_70671_ap().func_75650_a((double)this.blockX, (double)this.blockY, (double)this.blockZ, 30.0f, 30.0f);
        if (this.canSee) {
            if (!this.theEntity.func_70661_as().func_75500_f()) {
                this.theEntity.func_70661_as().func_75499_g();
            }
            if (MAD_CREEPERS && this.theEntity instanceof EntityCreeper) {
                ((EntityCreeper)this.theEntity).func_70829_a(1);
                this.blockDamage = 1.0f;
            } else {
                if (this.hitCounter == 0) {
                    this.theEntity.func_71038_i();
                    this.theEntity.field_70170_p.func_72956_a((Entity)this.theEntity, this.targetBlock.field_149762_H.func_150495_a(), this.targetBlock.field_149762_H.func_150497_c(), this.targetBlock.field_149762_H.func_150494_d() * 0.8f);
                }
                if (++this.hitCounter >= 5) {
                    this.hitCounter = 0;
                }
                this.blockDamage += BlockHelper.getDamageAmount(this.targetBlock, this.theEntity, this.theEntity.field_70170_p, this.blockX, this.blockY, this.blockZ);
                if (this.blockDamage >= 1.0f) {
                    if (this.targetBlock == Blocks.field_150458_ak) {
                        this.theEntity.field_70170_p.func_147465_d(this.blockX, this.blockY, this.blockZ, Blocks.field_150346_d, 0, 3);
                    } else {
                        if (LEAVE_DROPS) {
                            Block block = this.theEntity.field_70170_p.func_147439_a(this.blockX, this.blockY, this.blockZ);
                            int meta = this.theEntity.field_70170_p.func_72805_g(this.blockX, this.blockY, this.blockZ);
                            block.func_149697_b(this.theEntity.field_70170_p, this.blockX, this.blockY, this.blockZ, meta, 0);
                        }
                        this.theEntity.field_70170_p.func_147468_f(this.blockX, this.blockY, this.blockZ);
                        if (BREAK_SOUND) {
                            this.theEntity.field_70170_p.func_72926_e(1012, this.blockX, this.blockY, this.blockZ, 0);
                        }
                        this.theEntity.field_70170_p.func_72926_e(2001, this.blockX, this.blockY, this.blockZ, Block.func_149682_b((Block)this.targetBlock));
                        this.theEntity.func_71038_i();
                    }
                    this.blockDamage = 0.0f;
                    this.resetTaskGriefing();
                    this.activity = Activity.NONE;
                }
                this.theEntity.field_70170_p.func_147443_d(this.theEntity.func_145782_y(), this.blockX, this.blockY, this.blockZ, (int)(this.blockDamage * 10.0f) - 1);
            }
        } else {
            if (this.sightCounter-- <= 0) {
                this.sightCounter = 10 + this.random.nextInt(5);
                if (this.checkSight()) {
                    this.sightCounter += 3;
                }
            }
            if (++this.giveUpDelay > 400) {
                this.theEntity.func_70661_as().func_75499_g();
                this.resetTaskGriefing();
                this.activity = Activity.NONE;
            } else if (this.theEntity.func_70661_as().func_75500_f() && this.giveUpDelay % 12 == 0) {
                this.theEntity.func_70661_as().func_75492_a((double)this.blockX, (double)this.blockY, (double)this.blockZ, 1.0);
            }
        }
    }

    private void updateTaskFiddling() {
        this.theEntity.func_70671_ap().func_75650_a((double)this.blockX, (double)this.blockY, (double)this.blockZ, 30.0f, 30.0f);
        if (this.canSee) {
            try {
                if (this.theEntity.field_70170_p instanceof WorldServer) {
                    EntityFakePlayer fakePlayer = new EntityFakePlayer(this.theEntity);
                    this.targetBlock.func_149727_a(this.theEntity.field_70170_p, this.blockX, this.blockY, this.blockZ, (EntityPlayer)fakePlayer, 0, 0.5f, 0.5f, 0.5f);
                    fakePlayer.updateWrappedEntityState();
                }
            }
            catch (Exception ex) {
                _SpecialAI.console("Failed to fiddle with block! (" + Block.field_149771_c.func_148750_c((Object)this.targetBlock) + ")");
                ex.printStackTrace();
            }
            this.theEntity.func_71038_i();
            this.theEntity.func_70661_as().func_75499_g();
            this.resetTaskFiddling();
            this.activity = Activity.NONE;
        } else {
            if (this.sightCounter-- <= 0) {
                this.sightCounter = 10 + this.random.nextInt(5);
                if (this.checkSight()) {
                    this.sightCounter += 3;
                }
            }
            if (++this.giveUpDelay > 400) {
                this.theEntity.func_70661_as().func_75499_g();
                this.resetTaskFiddling();
                this.activity = Activity.NONE;
            } else if (this.theEntity.func_70661_as().func_75500_f() && this.giveUpDelay % 13 == 0) {
                this.theEntity.func_70661_as().func_75492_a((double)this.blockX, (double)this.blockY, (double)this.blockZ, 1.0);
            }
        }
    }

    private boolean checkSight() {
        double x = (double)this.blockX + 0.5;
        double y = (double)this.blockY + 0.5;
        double z = (double)this.blockZ + 0.5;
        if (this.theEntity.func_70092_e(x, y - (double)this.theEntity.func_70047_e(), z) <= (double)REACH) {
            Vec3 posVec = Vec3.func_72443_a((double)this.theEntity.field_70165_t, (double)(this.theEntity.field_70163_u + (double)this.theEntity.func_70047_e()), (double)this.theEntity.field_70161_v);
            if (this.checkSight(posVec, x, y + (this.theEntity.field_70163_u > y ? 0.5 : -0.5), z) || this.checkSight(posVec, x + (this.theEntity.field_70165_t > x ? 0.5 : -0.5), y, z) || this.checkSight(posVec, x, y, z + (this.theEntity.field_70161_v > z ? 0.5 : -0.5))) {
                this.canSee = true;
            }
            return true;
        }
        return false;
    }

    private boolean checkSight(Vec3 posVec, double x, double y, double z) {
        Vec3 targetVec = Vec3.func_72443_a((double)x, (double)y, (double)z);
        MovingObjectPosition target = this.theEntity.field_70170_p.func_72933_a(posVec, targetVec);
        return target == null || this.blockY == target.field_72312_c && this.blockX == target.field_72311_b && this.blockZ == target.field_72309_d || this.tryTargetObstructingBlock(target.field_72311_b, target.field_72312_c, target.field_72309_d);
    }

    private boolean tryTargetObstructingBlock(int x, int y, int z) {
        Block block = this.theEntity.field_70170_p.func_147439_a(x, y, z);
        switch (this.activity) {
            case GRIEFING: {
                return this.tryTargetBlockGriefing(block, x, y, z);
            }
            case FIDDLING: {
                return this.tryTargetBlockFiddling(block, x, y, z);
            }
        }
        return false;
    }

    private boolean tryTargetBlock(int x, int y, int z) {
        Block block = this.theEntity.field_70170_p.func_147439_a(x, y, z);
        return this.tryTargetBlock(block, x, y, z);
    }

    private boolean tryTargetBlock(Block block, int x, int y, int z) {
        if (this.griefing && this.tryTargetBlockGriefing(block, x, y, z)) {
            return true;
        }
        return this.fiddling && this.fiddleDelay <= 0 && this.tryTargetBlockFiddling(block, x, y, z);
    }

    private boolean tryTargetBlockGriefing(Block block, int x, int y, int z) {
        if (this.isValidTargetForGriefing(block, x, y, z)) {
            this.activity = Activity.GRIEFING;
            this.blockX = x;
            this.blockY = y;
            this.blockZ = z;
            this.targetBlock = block;
            return true;
        }
        return false;
    }

    private boolean tryTargetBlockFiddling(Block block, int x, int y, int z) {
        if (this.isValidTargetForFiddling(block, x, y, z)) {
            this.activity = Activity.FIDDLING;
            this.blockX = x;
            this.blockY = y;
            this.blockZ = z;
            this.targetBlock = block;
            return true;
        }
        return false;
    }

    private boolean isValidTargetForGriefing(Block block, int x, int y, int z) {
        TargetBlock testTargetBlock = new TargetBlock(block, this.theEntity.field_70170_p.func_72805_g(x, y, z));
        if (block != null && block != Blocks.field_150350_a && !(block instanceof BlockLiquid) && !this.griefBlacklist.contains(testTargetBlock) && (this.griefTargetsLights && block.func_149750_m() > 1 && !(block instanceof BlockFire) && block != Blocks.field_150439_ay && !(block instanceof BlockOre) || this.griefTargetBlocks.contains(testTargetBlock))) {
            return BlockHelper.shouldDamage(block, this.theEntity, this.griefNeedsTool, this.theEntity.field_70170_p, x, y, z);
        }
        return false;
    }

    private boolean isValidTargetForFiddling(Block block, int x, int y, int z) {
        TargetBlock testTargetBlock = new TargetBlock(block, this.theEntity.field_70170_p.func_72805_g(x, y, z));
        return block != null && block != Blocks.field_150350_a && !this.fiddleBlacklist.contains(testTargetBlock) && this.fiddleTargetBlocks.contains(testTargetBlock);
    }

    private static enum Activity {
        NONE,
        GRIEFING,
        FIDDLING;

    }
}

