/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.lib.network;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import java.util.List;
import net.minecraft.network.INetHandler;
import pl.asie.lib.AsieLibMod;
import pl.asie.lib.network.MessageHandlerBase;
import pl.asie.lib.network.Packet;

@ChannelHandler.Sharable
public class PacketChannelHandler
extends MessageToMessageCodec<FMLProxyPacket, Packet> {
    private final MessageHandlerBase handlerClient;
    private final MessageHandlerBase handlerServer;

    public PacketChannelHandler(MessageHandlerBase client, MessageHandlerBase server) {
        this.handlerClient = client;
        this.handlerServer = server;
    }

    protected void encode(ChannelHandlerContext ctx, Packet msg, List<Object> out) throws Exception {
        ByteBuf buffer = Unpooled.buffer();
        msg.toBytes(buffer);
        FMLProxyPacket proxy = new FMLProxyPacket(buffer, (String)ctx.channel().attr(NetworkRegistry.FML_CHANNEL).get());
        out.add(proxy);
    }

    protected void decode(ChannelHandlerContext ctx, FMLProxyPacket msg, List<Object> out) throws Exception {
        Packet newMsg = new Packet();
        newMsg.fromBytes(msg.payload());
        INetHandler netHandler = (INetHandler)ctx.channel().attr(NetworkRegistry.NET_HANDLER).get();
        AsieLibMod.proxy.handlePacket(this.handlerClient, this.handlerServer, newMsg, netHandler);
    }
}

